% This solves all the shapes.

close all
clear all

global nseries  hvec kvec eps kappa kappa_X delta_X xtab xtab_m1 nu...
    xtabm xtabp xtabTop xtabX xtabm_m1 xtabp_m1 xtabTop_m1 xtabX_m1 xm xp xTop xX...
    dh powers powers_m1 twoD epshat yTop yX cfull sfull csi psisign kappa delta...
    kvec_ref eq_option nlevels vlevel f_J f_P psi_surf psi_axis_input psimax...
    pedestal_option nu1 nu2 nu3 alphasol f_B M0 flow_option



% ---------------CASE SELECTION--------------
% See below for the parameters corresponding to each case. Enter
% case_number=21 to input any desired parameters different from the default
% cases.

case_number = 15

% flow_option = 2;
% 0 for no flow (this overrides the value of M0)
% 2 for gamma = 2
% 99 for gamma -> infinity


twoD = 0;
nR = 160;
nZ = 250;

%-------------------------------------------
% Data: Modify the data corresponding to the desired equilibrium shape.
% Note that R0 is not needed for calculating the solution. We introduce it
% here simply to be able to plot the solution.


% HEREHEREHERE

R0=1;
% ---------------GEOMETRY SELECTION--------------
% This picks one of the predefined shapes (see paper 1). If you want a
% different shape, make up a new case.

case_5 = 0
case_7 = 0
case_8 = 0
case_1 = 0
case_3 = 1

if(case_5==1)
    M0ref = 0.5
elseif(case_7==1)
    M0ref = 0.2
elseif(case_8==1)
    M0ref = 0.3
elseif(case_1==1)
    M0ref = 0.5 % Making this up
elseif(case_3==1)
    M0ref = 0.5 % Making this up
end


if(case_5==1)
    
    % TEST CASE 5: NEGATIVE DELTA
    
    eq_option = 1;
    eps = 1/3;
    delta = -0.6;
    kappa = 1.9;
    nu = 0.5;
    
elseif(case_7==1)
    
    % TEST CASE 7: SPHERICAL TOKAMAK DN
    
    eq_option = 2;
    eps = 0.75;
    epshat = 2*eps/(1+eps^2);
    delta_X = 0.8;
    kappa_X = 2.4;
    nu = 1/epshat;
    
elseif(case_8==1)
    
    % TEST CASE 8: STANDARD SN
    
    eq_option = 3;
    eps = 1/3;
    delta_X = 0.5;
    kappa_X = 2.;
    delta = 0.4;
    kappa = 1.6;
    nu = 1;
    
elseif(case_1==1)
    
    % TEST CASE 1: CIRCLE
    
    eq_option = 1;
    eps = 1/3;
    delta = 0.;
    kappa = 1.;
    nu = 1;    
    
elseif(case_3==1)
    
    % TEST CASE 3: STANDARD TOKAMAK
    
    eq_option = 1;
    eps = 1/3;
    delta = 0.6;
    kappa = 1.8;
    nu = 0.3;
    
end

dh = asin(delta);

if(case_number == 1)
    M0=0;
    f_B=0.35;
    f_P=0;
    f_J=0;
    flow_option=0;
elseif(case_number == 2)
    M0=0;
    f_B=0.35;
    f_P=0.2;
    f_J=0;
    flow_option=0;
elseif(case_number == 3)
    M0=0;
    f_B=0.35;
    f_P=0.2;
    f_J=0.25;
    flow_option=0;
elseif(case_number == 4)
    M0=0;
    f_B=0;
    f_P=0.;
    f_J=0.25;
    flow_option=0;
elseif(case_number == 5)
    M0=M0ref;
    flow_option=2;
    f_B=0.35;
    f_P=0;
    f_J=0;
elseif(case_number == 6)
    M0=M0ref;
    flow_option=2;
    f_B=0.35;
    f_P=0.2;
    f_J=0;
elseif(case_number == 7)
    M0=M0ref;
    flow_option=2;
    f_B=0.35;
    f_P=0.2;
    f_J=0.25;
elseif(case_number == 8)
    M0=M0ref;
    flow_option=2;
    f_B=0;
    f_P=0;
    f_J=0.25;
elseif(case_number == 9)
    M0=2*M0ref;
    flow_option=2;
    f_B=0.35;
    f_P=0;
    f_J=0;
elseif(case_number == 10)
    M0=2*M0ref;
    flow_option=2;
    f_B=0.35;
    f_P=0.2;
    f_J=0;
elseif(case_number == 11)
    M0=2*M0ref;
    flow_option=2;
    f_B=0.35; % 0.25 seems to work for case 5
    f_P=0.2;
    f_J=0.25;
elseif(case_number == 12)
    M0=2*M0ref;
    flow_option=2;
    f_B=0;
    f_P=0;
    f_J=0.25;
elseif(case_number == 13)
    M0=M0ref;
    flow_option=99;
    f_B=0.35;
    f_P=0;
    f_J=0;
elseif(case_number == 14)
    M0=M0ref;
    flow_option=99;
    f_B=0.35;
    f_P=0.2;
    f_J=0;
elseif(case_number == 15)
    M0=M0ref;
    flow_option=99;
    f_B=0.35;
    f_P=0.2;
    f_J=0.25;
elseif(case_number == 16)
    M0=M0ref;
    flow_option=99;
    f_B=0;
    f_P=0;
    f_J=0.25;
elseif(case_number == 17)
    M0=2*M0ref;
    flow_option=99;
    f_B=0.35;
    f_P=0;
    f_J=0;
elseif(case_number == 18)
    M0=2*M0ref;
    flow_option=99;
    f_B=0.35;
    f_P=0.2;
    f_J=0;
elseif(case_number == 19)
    M0=2*M0ref;
    flow_option=99;
    f_B=0.35;
    f_P=0.2;
    f_J=0.25;
elseif(case_number == 20)
    M0=2*M0ref;
    flow_option=99;
    f_B=0;
    f_P=0;
    f_J=0.25
elseif(case_number == 21)
    % debug case
    M0=0.5; %M0ref;
    flow_option=2;
    f_B=0.;
    f_P=0.;
    f_J=0.;
%    nu = .1
end


% ---------------END OF CASE SELECTION--------------


psi_surf = f_J/(1-f_J);
psi_axis_input = 1/(1-f_J);

if(f_J==0)
    pedestal_option = 0;
else
    pedestal_option = 1;
end

zeta = M0^2*(1+eps^2)/(1+M0^2*eps^2);

if(flow_option==0)
    nu1 = nu;
    nu2 = 0;
    nu3 = 0;
elseif(flow_option==2)
    nu1 = (1+2*zeta)*nu;
    nu2 = zeta*(2+zeta)*nu;
    nu3 = zeta^2*nu;
elseif(flow_option==99)
    nu1 = (1+zeta)*nu;
    nu2 = zeta*nu;
    nu3 = 0;
end

if((eq_option==2)||(eq_option==3))
    
    sqdX=sqrt(1-delta_X^2);
    csi = sqdX/(kappa_X-sqdX);
    sqcsi = sqrt(1-csi^2);
    kappa_0 = kappa_X/sqcsi;
    
    xx1 = (csi-delta_X)/(1-csi);
    xx2 = (csi+delta_X)/(1-csi);
    
    theta0 = atan(sqcsi/csi);
    
end

a = eps*R0;
epshat = 2*eps/(1+eps^2);

nseries = 150;
nseries = 500;
psisign = 1;


%-------------------------------------------
% Part 0: define the points.
% Observe that once the geometry is defined all terms involving z never
% change, so they can be calculated once and for all outside the error
% function.

% Here we define the plasma reference shape, too.

if(eq_option==1)
    
    theta = linspace(0, 2*pi,300);
    bigR_edge = R0*(1+eps*cos(theta+dh*sin(theta)));
    bigZ_edge = kappa*R0*eps*sin(theta);
    
elseif(eq_option==2)
    
    thetaL = linspace(pi-theta0,pi+theta0,150);
    thetaR = linspace(-theta0,theta0,150);
    
    bigX_L = xx1+(1+xx1)*cos(thetaL);
    bigY_L = kappa_0*sin(thetaL);
    
    bigX_R = -xx2+(1+xx2)*cos(thetaR);
    bigY_R = kappa_0*sin(thetaR);
    
    bigX=[bigX_L, bigX_R];
    bigY=[bigY_L, bigY_R];
    
    bigR_edge = a*bigX+R0;
    bigZ_edge = a*bigY;
    
elseif(eq_option==3)
    
    thetaup = linspace(0,pi,150);
    thetaL = linspace(pi,pi+theta0,150);
    thetaR = linspace(2*pi-theta0,2*pi,150);
    
    bigX_up = cos(thetaup+dh*sin(thetaup));
    bigY_up = kappa*sin(thetaup);
    
    bigX_L = xx1+(1+xx1)*cos(thetaL);
    bigY_L = kappa_0*sin(thetaL);
    
    bigX_R = -xx2+(1+xx2)*cos(thetaR);
    bigY_R = kappa_0*sin(thetaR);
    
    bigX=[bigX_up, bigX_L, bigX_R];
    bigY=[bigY_up, bigY_L, bigY_R];
    
    bigR_edge = a*bigX+R0;
    bigZ_edge = a*bigY;
    
end



xm = -1;
xp = 1;

if(eq_option==1)
    xTop = -delta-eps/2*(1-delta^2);
    yTop = kappa;
elseif(eq_option==2)
    xX = -delta_X-eps/2*(1-delta_X^2);
    yX = kappa_X;
    xTop = xX;
    yTop = yX;
elseif(eq_option==3)
    xTop = -delta-eps/2*(1-delta^2);
    yTop = kappa;
    xX = -delta_X-eps/2*(1-delta_X^2);
    yX = -kappa_X;
end

powers = [0:nseries];
powers_m1 = [0,0:nseries-1]; %The first 0 is just a place holder.

if(eq_option==1)
    xtab = [xm; xp; xTop].^powers;
    xtab_m1 = powers.*[xm; xp; xTop].^powers_m1;
elseif(eq_option==2)
    xtab = [xm; xp; xX].^powers;
    xtab_m1 = powers.*[xm; xp; xX].^powers_m1;
elseif(eq_option==3)
    xtab = [xm; xp; xTop; xX].^powers;
    xtab_m1 = powers.*[xm; xp; xTop; xX].^powers_m1;
end

% Still deciding the best way: it may work better to have matrices of the
% same points for different values of k.

xtabm = repmat(xtab(1,:),4,1);
xtabp = repmat(xtab(2,:),4,1);

xtabm_m1 = repmat(xtab_m1(1,:),4,1);
xtabp_m1 = repmat(xtab_m1(2,:),4,1);

if(eq_option==1)
    xtabTop = repmat(xtab(3,:),4,1);
    xtabTop_m1 = repmat(xtab_m1(3,:),4,1);
elseif(eq_option==2)
    xtabX = repmat(xtab(3,:),4,1);
    xtabX_m1 = repmat(xtab_m1(3,:),4,1);
elseif(eq_option==3)
    xtabTop = repmat(xtab(3,:),4,1);
    xtabTop_m1 = repmat(xtab_m1(3,:),4,1);
    xtabX = repmat(xtab(4,:),4,1);
    xtabX_m1 = repmat(xtab_m1(4,:),4,1);
end

% This combination works well for most cases. Feel free to experiment!
kvec_ref = [0 1/6 6/7 1];

% Uncomment this part to see a plot of the error as a function of alpha.
% This may occasionally be needed to get a good guess for the location of
% the root.

if(f_J>0)
    alphaminplot = 0.6;
    alphamaxplot = 2.25;
else
    alphaminplot = 1;
    alphamaxplot = 2.75;
end

nplot = 600;

% tic

% for iii = 1:1000

alphaplot = linspace(alphaminplot,alphamaxplot,nplot);
vals=NaN(size(alphaplot));
for i = 1:length(alphaplot)
    vals(i) = Err_general(alphaplot(i));
end
figure(1)
plot(alphaplot,vals)
dalpha = (alphamaxplot-alphaminplot)/(nplot-1);



% Now find alpha. First find local minima in vals, then use them as
% starting points for the minimum search. Stop when the value of the
% function is less than 10^-8;

locs = islocalmin(vals);
alphastarts=alphaplot(locs);

options = optimset('Display','iter','TolX',1e-8,'TolFun',1e-8);
% options = optimset('TolX',1e-8,'TolFun',1e-8);

alphaerr=1;
ind = 0;

while(alphaerr>10^-8)
    ind = ind+1;
    alphaL = alphastarts(ind)-dalpha;
    alphaR = alphastarts(ind)+dalpha;
    %    alphasol = fminsearch(@Err_general,alphastarts(ind),options)
    alphasol = fminbnd(@Err_general,alphaL,alphaR,options)
    alphaerr = Err_general(alphasol)
end

% end

%toc


% Note that psi_axis should automatically be positive, but we can check to
% make sure.

psimax = 1;
psiref = psi_any_shape(0,0);

if(psiref<0)
    psisign = -1;
end

psiref = psisign*psiref;

% Let's plot the solution, just to visualize what we have done.
bigR = linspace(R0*(1-eps)-0.05,R0*(1+eps)+0.05,nR);
if(eq_option==1)
    bigZ = linspace(-a*kappa-0.05,a*kappa+0.05,nZ);
elseif(eq_option==2)
    bigZ = linspace(-a*kappa_X-0.05,a*kappa_X+0.05,nZ);
elseif(eq_option==3)
    bigZ = linspace(-a*kappa_X-0.05,a*kappa+0.05,nZ);
end

x_for_plot = (bigR.^2/R0^2-1-eps^2)/(2*eps);
y_for_plot = bigZ./a;

twoD = 1;
% psi2D = psisign*psi_any_shape(x_for_plot,y_for_plot);
if(pedestal_option==0)
    psi2D = psi_any_shape(x_for_plot,y_for_plot);
elseif(pedestal_option==1)
    psi2D = psisign*psi_any_shape(x_for_plot,y_for_plot);
end
% Keep in mind that psi_any_shape is normalized to 1 in the center. We can
% change this if we like.
nlevels = 10;
% In this case we do not divide by psimax because of the different
% definition of psi (or in this case, psi hat).
%vlevel = linspace(psi_surf/psimax,psiref,nlevels);
vlevel = linspace(psi_surf,psiref,nlevels);

figure('Renderer', 'painters', 'Position', [500 300 900 600])
[cm, h] = contourf(bigR,bigZ,psi2D,vlevel);
% if(eq_option==1)
%     pbaspect([1 kappa 1])
% elseif((eq_option==2)||(eq_option==3))
%     pbaspect([1 kappa_X 1])
% end
axis image
hold on

plot(bigR_edge,bigZ_edge,'r','LineWidth',1)
grid on

