% This part of the code does the postprocessing.
% We are keeping this separate because it is more time consuming than
% calculating the equilibrium and one may not want all the data every time
% an equilibrium is calculated.
% This version uses surfaces calculated in (x,y).

global eps epshat twoD psimax nlevels vlevel alphasol eq_option...
    xlvlfunS ylvlfunS dB_ov_B beta0 psi_axis I_plasma_temp ...
    xlvlfunSder ylvlfunSder M0 flow_option case_5 case_7 case_8 case_1...
    M0ref case_number psi_surf Iparphi DeltaB_sol f_J f_P f_B

% We import all the input definitions as global variables. Therefore, they
% do not need to be redefined here.

% case_5 = 1
% case_7 = 0
% case_8 = 0
%
% if(case_5==1)
%     M0ref = 0.5
% elseif(case_7==1)
%     M0ref = 0.2
% elseif(case_8==1)
%     M0ref = 0.3
% end
%
% case_number = 1;

if(case_5==1)
    case_name = '_case_5_';
elseif(case_7==1)
    case_name = '_case_7_';
elseif(case_8==1)
    case_name = '_case_8_';
elseif(case_1==1)
    case_name = '_case_1_';
elseif(case_3==1)
    case_name = '_case_3_';
end

name = join([case_name,num2str(case_number),'.plt'])
nameb = join([case_name,num2str(case_number),'.txt'])

if(case_number == 1)
    if((M0==0)&&(f_B==0.35)&&(f_P==0)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 2)
    if((M0==0)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 3)
    if((M0==0)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 4)
    if((M0==0)&&(f_B==0.)&&(f_P==0.)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 5)
    if((M0==M0ref)&&(flow_option==2)&&(f_B==0.35)&&(f_P==0)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 6)
    if((M0==M0ref)&&(flow_option==2)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 7)
    if((M0==M0ref)&&(flow_option==2)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 8)
    if((M0==M0ref)&&(flow_option==2)&&(f_B==0)&&(f_P==0)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 9)
    if((M0==2*M0ref)&&(flow_option==2)&&(f_B==0.35)&&(f_P==0)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 10)
    if((M0==2*M0ref)&&(flow_option==2)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 11)
    if((M0==2*M0ref)&&(flow_option==2)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 12)
    if((M0==2*M0ref)&&(flow_option==2)&&(f_B==0)&&(f_P==0)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 13)
    if((M0==M0ref)&&(flow_option==99)&&(f_B==0.35)&&(f_P==0)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 14)
    if((M0==M0ref)&&(flow_option==99)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 15)
    if((M0==M0ref)&&(flow_option==99)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 16)
    if((M0==M0ref)&&(flow_option==99)&&(f_B==0)&&(f_P==0)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 17)
    if((M0==2*M0ref)&&(flow_option==99)&&(f_B==0.35)&&(f_P==0)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 18)
    if((M0==2*M0ref)&&(flow_option==99)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 19)
    if((M0==2*M0ref)&&(flow_option==99)&&(f_B==0.35)&&(f_P==0.2)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 20)
    if((M0==2*M0ref)&&(flow_option==99)&&(f_B==0)&&(f_P==0)&&(f_J==0.25))
        disp('consistency check passed')
    else
        disp('consistency check failed')
        return
    end
elseif(case_number == 21)
    disp('WARNING: debug case')
end

tic

alphasol
eps
%nu
dB_ov_B = 0;%%%%
psi_axis = 1;%%%%

if(eq_option==1)
    delta
    kappa
elseif(eq_option==2)
    delta_X
    kappa_X
elseif(eq_option==3)
    delta
    kappa
    delta_X
    kappa_X
end



pick_q0 = 1;

if(flow_option==0)
    Gexp = 0;
elseif(flow_option==2)
    Gexp = 2;
elseif(flow_option==99)
    Gexp = 1;
end

safe_small = 5*10.^-3;

twoD = 0;
psimax = 1;

% This should not happen: need to check!

if(psi_any_shape(0,0)<0)
    fun_for_max = @(xx) psi_any_shape(xx(1),xx(2));
else
    fun_for_max = @(xx) -psi_any_shape(xx(1),xx(2));
end

xxstart = [0 0];
options = optimset('Display','iter','TolX',1e-8,'TolFun',1e-8);
xxmax = fminsearch(fun_for_max,xxstart,options);
psimax = abs(psi_any_shape(xxmax(1),xxmax(2)));

xaxis = xxmax(1);
yaxis = xxmax(2);
R_axis = sqrt(2*eps*xaxis + 1 + eps^2) * R0;
Z_axis = a*yaxis;

% Define remaining input parameters (by default, we have already defined R0
% elsewhere).

B0 = 1; % Vacuum toroidal field on geometric axis
if(pick_q0==0)
    
    beta0 = 0.0605 % Toroidal beta on the magnetic axis
    
elseif(pick_q0==1)
    
    q0 = 1;
    psi_xx_0 = psi_xx_any_shape(xaxis,yaxis);
    psi_yy_0 = psi_yy_any_shape(xaxis,yaxis);
    xloc = 1+eps^2+2*eps*xaxis;
    
    % psiloc = 1;
    ffrac = (1+f_J)/(1-f_J);
    
    beta0 = ffrac * eps^2*alphasol^2*nu / ...
        ((1-f_P)*(1+M0^2*eps^2)^Gexp) / ...
        ( q0^2*xloc^2*psi_xx_0*psi_yy_0 - ...
        (1+eps^2)*(1-nu)*eps^2*alphasol^2 )
    
end

mu0  = 4*pi*10^-7;

xmin = -1;
xmax = 1;

if((eq_option==1)||(eq_option==2))
    % Miller shape and Double Null
    ymin = -yTop;
    ymax = yTop;
elseif(eq_option==3)
    % Singe Null
    ymin = yX; % yX<0 by definition
    ymax = yTop;
end

% --------------------- CALCULATE AND SAVE P AND J ----------------------------
%------------------ Save Jphi ------------------

xofR = @(R) (R.^2/R0^2 - 1 - eps^2)./(2*eps);
yofZ = @(Z) Z/(eps*R0);

Rofx = @(x) R0*sqrt(1+2*eps*x+eps^2);
Zofy = @(y) eps*R0*y;

dpsidRofRZ = @(R,Z) R/(eps*R0^2) .* psi_x_any_shape(xofR(R),yofZ(Z));
dpsidZofRZ = @(R,Z) 1/(eps*R0) .* psi_y_any_shape(xofR(R),yofZ(Z));

delstarfun = @(R,Z) -1./R.*dpsidRofRZ(R,Z) + ...
    1/(eps*R0)^2 .* psi_yy_any_shape(xofR(R),yofZ(Z)) + ...
    1./R.*dpsidRofRZ(R,Z) + R.^2/(eps*R0^2)^2 .* psi_xx_any_shape(xofR(R),yofZ(Z));

Jphifun0 = @(R,Z) -1/mu0 ./ R .* delstarfun(R,Z);

bigRb = linspace(R0*(1-eps),R0*(1+eps),nR);
bigRb = bigRb';

Jphi1D = Jphifun0(bigRb,zeros(size(bigRb)));
Jphi1D = Jphi1D./max(Jphi1D);

Jphi1Dtab = [bigRb Jphi1D];

Jphi1Dname = 'Jphi_1D';
temp = [Jphi1Dname, name];
file2 = join(temp);

if(case_5==1)
    nfile2 = fullfile('../../','for paper/data with pedestal/case 5',file2);
elseif(case_7==1)
    nfile2 = fullfile('../../','for paper/data with pedestal/case 7',file2);
elseif(case_8==1)
    nfile2 = fullfile('../../','for paper/data with pedestal/case 8',file2);
elseif(case_1==1)
    nfile2 = fullfile('../../','for paper/data with pedestal/case 1',file2);
elseif(case_3==1)
    nfile2 = fullfile('../../','for paper/data with pedestal/case 3',file2);
end
save(nfile2,'Jphi1Dtab','-ascii');

%------------------ Save p ------------------
% We need the jump parts for this

twoD = 0;

%f_J = 0;
%f_P = 0;

h_J = f_J/(1-f_J);
% h_J is included in the definition of psi_any_shape

psiJ = @(x,y) psi_any_shape(x,y);% + h_J;

if(flow_option==0)
    gg = 0;
elseif(flow_option==2)
    gg = 2;
elseif(flow_option==99)
    gg = 1;
end

pofRZ = @(R,Z) (1 + M0^2*eps^2 + 2*M0^2*eps*xofR(R)).^gg.*...
    ((1-f_P)*(1-f_J)/(1+f_J)*psiJ(xofR(R),yofZ(Z)).^2 + (f_P-f_J^2)/(1-f_J^2));

p1D = pofRZ(bigRb',zeros(size(bigRb')));
p1D = p1D./max(p1D);


p1Dtab = [bigRb p1D'];

p1Dname = 'p_1D';
temp = [p1Dname, name];
file3 = join(temp);

if(case_5==1)
    nfile3 = fullfile('../../','for paper/data with pedestal/case 5',file3);
elseif(case_7==1)
    nfile3 = fullfile('../../','for paper/data with pedestal/case 7',file3);
elseif(case_8==1)
    nfile3 = fullfile('../../','for paper/data with pedestal/case 8',file3);
elseif(case_1==1)
    nfile3 = fullfile('../../','for paper/data with pedestal/case 1',file3);
elseif(case_3==1)
    nfile3 = fullfile('../../','for paper/data with pedestal/case 3',file3);
end
save(nfile3,'p1Dtab','-ascii');




% --------------------- STUFF TO CHECK AND CHANGE ----------------------------
% Calculate algebraic quantities.

% p0 = beta0 * B0^2/(2*mu0); % Plasma pressure on axis
%
% dB_ov_B = beta0*(1+eps^2)/2*((1-gamma)/gamma); % Plasma diamagnetism delta B / B0
dB_ov_B = beta0*(1+eps^2)*(1-f_P)/2*(1+eps^2*M0^2)^Gexp*(1-nu)/nu;
%
% psi_axis = eps*B0*R0^2/alphasol*sqrt(beta0/gamma); % Magnetic flux on axis
%
% % Plot normalized p and J_phi
%
% xofRfun = @(R) (R.^2./R0^2 - 1- eps^2)./(2*eps);
% yofZfun = @(Z) Z/a;
% Jphifunb = @(R,Z) (2*mu0*p0*R.^2 + 2*R0^2*B0^2*dB_ov_B).* ...
%     psi_any_shape(xofRfun(R),yofZfun(Z))./psi_axis./R;
%

if(flow_option==0) %Notice that this is redundant, since M0=0 anyway
    psi_axis = eps*B0*R0^2/alphasol*sqrt(beta0/nu) * ...
        sqrt((1-f_P)*(1-f_J)/(1+f_J))
elseif(flow_option==2)
    psi_axis = eps*B0*R0^2/alphasol*sqrt(beta0/nu) * ...
        sqrt((1-f_P)*(1+M0^2*eps^2)^2*(1-f_J)/(1+f_J))
elseif(flow_option==99)
    psi_axis = eps*B0*R0^2/alphasol*sqrt(beta0/nu) * ...
        sqrt((1-f_P)*(1+M0^2*eps^2)*(1-f_J)/(1+f_J))
end

% 
% xofR = @(R) (R.^2/R0^2 - 1 - eps^2)./(2*eps);
% yofZ = @(Z) Z/(eps*R0);
% 
% Rofx = @(x) R0*sqrt(1+2*eps*x+eps^2);
% Zofy = @(y) eps*R0*y;
% 
% dpsidRofRZ = @(R,Z) R/(eps*R0^2) .* psi_x_any_shape(xofR(R),yofZ(Z));
% dpsidZofRZ = @(R,Z) 1/(eps*R0) .* psi_y_any_shape(xofR(R),yofZ(Z));
% 
% delstarfun = @(R,Z) -1./R.*dpsidRofRZ(R,Z) + ...
%     1/(eps*R0)^2 .* psi_yy_any_shape(xofR(R),yofZ(Z)) + ...
%     1./R.*dpsidRofRZ(R,Z) + R.^2/(eps*R0^2)^2 .* psi_xx_any_shape(xofR(R),yofZ(Z));
% 
% Jphifun0 = @(R,Z) 1/mu0 ./ R .* delstarfun(R,Z);

% % Now calculate the various integrals that enter into all other quantities.
%
% % First define any needed functions and function handles
%
% % This is used for the area.
fun_Jac2D = @(x) a^2./(sqrt(1+eps^2+2*eps*x));

% --------------------- GET PLASMA SHAPE ---------------------
% We are going to need the plasma shape for various reasons, so we might as
% well determine it here and use it to calculate the surface and line integrals.

ntheta0 = 500; % Number of points on the surface
ntemp = 200;

% Define the input plasma shape.
% Use the desired plasma shape as a starting guess for the outermost
% surface.
if(eq_option==1)
    
    xsfun = @(theta) cos(theta+dh*sin(theta)) - ...
        eps/2 * sin(theta+dh*sin(theta)).^2;
    ysfun = @(theta) kappa*sin(theta);
    
    % Create two y(x) functions that we'll need later.
    % First, positive y.
    
    thetatemp = linspace(0, pi, ntemp);
    xtop_list = xsfun(thetatemp);
    ytop_list = ysfun(thetatemp);
    % Negative y is very similar.
    thetatemp = linspace(pi, 2*pi, ntemp);
    xbot_list = xsfun(thetatemp);
    ybot_list = ysfun(thetatemp);
    
elseif(eq_option==2)
    
    thetaL = linspace(pi-theta0,pi+theta0,ntemp);
    thetaR = linspace(-theta0,theta0,ntemp);
    
    bigX_L = xx1+(1+xx1)*cos(thetaL);
    bigY_L = kappa_0*sin(thetaL);
    
    bigX_R = -xx2+(1+xx2)*cos(thetaR);
    bigY_R = kappa_0*sin(thetaR);
    
    bigX=[bigX_L, bigX_R];
    bigY=[bigY_L, bigY_R];
    
    bigR_edge = a*bigX+R0;
    bigZ_edge = a*bigY;
    
    x_edge = (bigR_edge.^2/R0^2-1-eps^2)/(2*eps);
    y_edge = bigY;
    
    [xboundary_max ixmax]=max(x_edge);
    [xboundary_min ixmin]=min(x_edge);
    
    xbot_list_step = x_edge(ixmin+1:ixmax);
    ybot_list_step = bigY(ixmin+1:ixmax);
    
    [xbot_list isort0] = unique(xbot_list_step);
    ybot_list = ybot_list_step(isort0);
    
    xtop_list_step = [x_edge(1:ixmin-1), x_edge(ixmax+1:end-1)];
    ytop_list_step = [y_edge(1:ixmin-1), y_edge(ixmax+1:end-1)];
    
    [xtop_list_step2 isort] = sort(xtop_list_step);
    ytop_list_step2 = ytop_list_step(isort);
    
    [xtop_list isort2] = unique(xtop_list_step2);
    ytop_list = ytop_list_step2(isort2);
    
    
elseif(eq_option==3)
    
    thetaup = linspace(0,pi,ntemp);
    thetaL = linspace(pi,pi+theta0,ntemp);
    thetaR = linspace(2*pi-theta0,2*pi,ntemp);
    
    bigX_up = cos(thetaup+dh*sin(thetaup));
    bigY_up = kappa*sin(thetaup);
    
    bigX_L = xx1+(1+xx1)*cos(thetaL);
    bigY_L = kappa_0*sin(thetaL);
    
    bigX_R = -xx2+(1+xx2)*cos(thetaR);
    bigY_R = kappa_0*sin(thetaR);
    
    bigX=[bigX_up, bigX_L, bigX_R];
    bigY=[bigY_up, bigY_L, bigY_R];
    
    bigR_edge = a*bigX+R0;
    bigZ_edge = a*bigY;
    
    x_edge = (bigR_edge.^2/R0^2-1-eps^2)/(2*eps);
    y_edge = bigY;
    
    xtop_list = x_edge(1:ntemp);
    ytop_list = bigY(1:ntemp);
    
    xbot_list = x_edge(ntemp+1:end);
    ybot_list = bigY(ntemp+1:end);
    
end

fysofxT = spline(xtop_list,ytop_list);
funysofxT = @(x) ppval(fysofxT,x);

fysofxB = spline(xbot_list,ybot_list);
funysofxB = @(x) ppval(fysofxB,x);

% Create the arrays.
npoints = 250;
xlist = NaN(npoints,1);
yuplist = xlist;
ydownlist = xlist;

% Set up known edge points.
xlist = linspace(-1,1,npoints);
yuplist(1) = 0;
yuplist(end) = 0;
ydownlist(1) = 0;
ydownlist(end) = 0;

% Work on the top shape first.
for i = 2:npoints-1
    
    xloc = xlist(i);
    ffory = @(y) psi_any_shape(xloc,y)-psi_surf;
    zerostartb = yuplist(i-1);
    zerostart = [0 zerostartb];
    while(ffory(zerostart(1,1))*ffory(zerostart(1,2))>0)
        temp = zerostart(1,2) + 0.002;
        zerostart(1,2) = temp;
        
    end
    yloc = fzero(ffory,zerostart);
    yuplist(i) = yloc;
    
end

% Repeat the calculation for the bottom shape.
for i = 2:npoints-1
    
    xloc = xlist(i);
    ffory = @(y) psi_any_shape(xloc,y)-psi_surf;
    zerostartb = ydownlist(i-1);
    zerostart = [0 zerostartb];
    while(ffory(zerostart(1,1))*ffory(zerostart(1,2))>0)
        temp = zerostart(1,2) - 0.002;
        zerostart(1,2) = temp;
        
    end
    yloc = fzero(ffory,zerostart);
    ydownlist(i) = yloc;
    
end

xlist_for_FLOW = [flipud(xlist'); xlist(2:end)'];
ylist_for_FLOW = [flipud(yuplist); ydownlist(2:end)];

R_for_FLOW = R0 * sqrt(1 + eps^2 + 2*eps*xlist_for_FLOW);
Z_for_FLOW = a*ylist_for_FLOW;

save_for_FLOW = [R_for_FLOW Z_for_FLOW];

% Check that the shape was reconstructed correctly.
figure
plot(save_for_FLOW(:,1),save_for_FLOW(:,2))
axis image

save('R_Z_shape.dat','save_for_FLOW','-ascii');

fysofxT = spline(xlist,yuplist);
funysofxT = @(x) ppval(fysofxT,x);

fysofxB = spline(xlist,ydownlist);
funysofxB = @(x) ppval(fysofxB,x);

ytoplast = @(x) funysofxT(x);
ybotlast = @(x) funysofxB(x);

%----------------WE NEED TO REPRODUCE THE SURFACE PART HERE--------------



psiloc = 0;
nthetaloc = 401;
nthetamid = (nthetaloc-1)/2;

% Note that this overwrites the previous lists.
xlist = NaN(nthetaloc,1);
ylist = NaN(nthetaloc,1);
% Find the left and right crossings of the horizontal axis for this
% value of psi.


% We set up the arrays in a different way following earlier versions.
% The easiest thing to do is to redefine the arrays in the same way as
% for all other surfaces.
xcrossL = -1;
xcrossR = 1;

xlastL = xcrossL;
xlastR = xcrossR;

% Fill the x grid
xlist(1:nthetamid) = linspace(xcrossR,xcrossL,nthetamid);
xlist(nthetamid:end) = linspace(xcrossL,xcrossR,nthetamid+2);

% Fill the y grid using the functions created earlier.
% (Repeated point is just to agree with the rest, it does not create any
% issues)
ylist(1:nthetamid) = ytoplast(xlist(1:nthetamid));
ylist(nthetamid:end) = ybotlast(xlist(nthetamid:end));


yuplist = ylist(1:nthetamid);
ydownlist = ylist(nthetamid+1:end);

[xbot, ybot] = fminbnd(ybotlast,xlastL,xlastR);
ymaxBS = -ybot;

ytemp = @(x) -ytoplast(x);
[xtop, ytop] = fminbnd(ytemp,xlastL,xlastR);
ymaxTS = -ytop;



% Now determine theta

thetatempT = real(asin(yuplist./ymaxTS));
thetatempB = real(asin(ydownlist./ymaxBS));

[thmaxT iTop]=max(thetatempT);
thetatempT(iTop+1:end) = pi - thetatempT(iTop+1:end);

[thminB iBot]=min(thetatempB);
thetatempB(1:iBot) = -thetatempB(1:iBot)+pi;
thetatempB(iBot+1:end) = 2*pi + thetatempB(iBot+1:end);

theta_list = [thetatempT; thetatempB];


spline_x_levelS = spline(theta_list,xlist);
spline_x_der = fnder(spline_x_levelS,1);
xlvlfunS = @(x) ppval(spline_x_levelS,x);
xlvlfunSder = @(x) ppval(spline_x_der,x);

spline_y_levelS = spline(theta_list,ylist);
spline_y_der = fnder(spline_y_levelS,1);
ylvlfunS = @(y) ppval(spline_y_levelS,y);
ylvlfunSder = @(y) ppval(spline_y_der,y);

int_temp = @(x,y) fun_Jac2D(x).*Jphifun0(Rofx(x),Zofy(y));

I_plasma_temp = psi_axis*integral2(int_temp,xmin,xmax,ybotlast,ytoplast)
Iparphi = I_plasma_temp; % This will change if there are surface currents.
DeltaB_sol = 1; % This will change if there are surface currents.


fterm = (f_P-f_J^2)/(1-f_J)^2;

funG = @(x) (1+epshat*x).*(1+2*M0^2*eps/(1+M0^2*eps^2).*x).^Gexp - 1;
fun_psi2_new = @(x,y) psi_any_shape(x,y).^2;
fun_t2_new = @(x,y) (1+nu*funG(x))./(1+epshat*x).*(1-f_P).* fun_psi2_new(x,y);
fun_t3_new = @(x,y) (1+funG(x))./(1+epshat*x).*((1-f_P)*fun_psi2_new(x,y) + fterm);
fun_t2_right = @(x,y) (1+funG(x))./(1+epshat.*x).*((1-f_P).*fun_psi2_new(x,y) + fterm);
fun_t3_right = @(x,y) (1+nu.*funG(x))./(1+epshat.*x).*(1-f_P).* fun_psi2_new(x,y);


% int_t2_new = integral2(fun_t2_new,xmin,xmax,ybotlast,ytoplast);
% int_t3_new = integral2(fun_t3_new,xmin,xmax,ybotlast,ytoplast);
int_t2_right = integral2(fun_t2_right,xmin,xmax,ybotlast,ytoplast,'Method','iterated',...
'AbsTol',0.001,'RelTol',1e-10);
int_t3_right = integral2(fun_t3_right,xmin,xmax,ybotlast,ytoplast,'Method','iterated',...
'AbsTol',0.001,'RelTol',1e-10);

betapol = nu * int_t2_right / int_t3_right




% Check if there is a surface current.
if((f_P>0)||(f_B>0))
 %    DeltaB_finder
%     DeltaB_1 = DeltaB_sol;
    DeltaB_finder_2
%    DeltaB_finder_2b
%     DeltaB_diff = 2*(DeltaB_1 - DeltaB_sol)/(DeltaB_1 + DeltaB_sol)
end

% keyboard

%--------------------- OTHER STUFF TO CHECK AND EDIT --------------------

% Notice that we calculate the same integrals twice using different
% routines and methods for debugging purposes. This is overkill for this
% problem. The older version can be commented out.

% fun_A_new = @(x,y) fun_Jac2D(x);
% fun_A_new = @(x,y) 1+x-x;
%
% fun_psi2_new = @(x,y) psi_any_shape(x,y).^2;
% fun_psi2_new = @(x,y) psi_for_integral(x,y).^2;
%
% fun_t1_new = @(x,y) (1+gamma*epshat*x)./(1+epshat*x).* psi_for_integral(x,y);
%
% fun_t2_new = @(x,y) (1+gamma*epshat*x)./(1+epshat*x).* fun_psi2_new(x,y);
%
% % Now get the integrals
%
% int_A_new = integral2(fun_A_new,xmin,xmax,ybotlast,ytoplast)
%
% int_psi2_new = integral2(fun_psi2_new,xmin,xmax,ybotlast,ytoplast);
%
% int_t2_new = integral2(fun_t2_new,xmin,xmax,ybotlast,ytoplast);
%
% int_t1_new = integral2(fun_t1_new,xmin,xmax,ybotlast,ytoplast);
%
%
% fun_A = @(x,y) fun_Jac2D(x).*psi_for_integral(x,y)./(psi_for_integral(x,y)+10^-16);
%
% fun_psi2 = @(x,y) psi_for_integral(x,y).^2;
%
% fun_t1 = @(x,y) (1+gamma*epshat*x)./(1+epshat*x).* psi_for_integral(x,y);
%
% fun_t2 = @(x,y) (1+gamma*epshat*x)./(1+epshat*x).* fun_psi2(x,y);
%
% % Now get the integrals
%
% int_A = integral2(fun_A,xmin,xmax,ymin,ymax,'AbsTol',1e-2,'RelTol',1e-4);
%
% int_psi2 = integral2(fun_psi2,xmin,xmax,ymin,ymax);
%
% int_t2 = integral2(fun_t2,xmin,xmax,ymin,ymax);
%
% int_t1 = integral2(fun_t1,xmin,xmax,ymin,ymax);
%
% % Now we can calculate the desired integral quantities.
%
% % betator = beta0 * int_psi2/int_A;
% betator_new = beta0 * int_psi2_new/int_A_new
%
% % betapol = gamma * int_psi2/int_t2;
% betapol_new = gamma * int_psi2_new/int_t2_new
%
% I_plasma = eps*B0*R0*alphasol/mu0 * sqrt(beta0/gamma) * int_t1;
% I_plasma_new = eps*B0*R0*alphasol/mu0 * sqrt(beta0/gamma) * int_t1_new
%
% l_inductance = 4*pi/alphasol^2 * int_t2/int_t1^2;
% l_inductance_new = 4*pi/alphasol^2 * int_t2_new/int_t1_new^2
%
%
% % We have moved q_star to the end because it requires kappa_95 for the
% % cases with X points

% We need to explicitly define F(psi) for the FLOW version.
bigF = @(psi) R0*B0 *sqrt(1 + 2*dB_ov_B *psi.^2);

% q_star_2 = 2*int_A*bigF(0)/(mu0*R0^2*I_plasma);
% q_star_2_new = 2*int_A_new*bigF(0)/(mu0*R0^2*I_plasma);


% We need kappa_95 to calculate q*. The only way to find it is through
% magnetic surface reconstruction. Since we don't care about q, we only do
% this if eq_option>1.

% Now we move to line integrals. These only matter for q(psi).
% It is easier to work on one contour at a time, so add here any other line
% integrals that may come up.

% We use Jeff's simplification of the integrand to
% ymax(psi)*sin(theta)/psi_x(x(theta),y(theta))

% Set a psi value for each surface. Use the psi value to determine the x
% values for the y=0 axis first, then set up a grid in x and determine y.

if(eq_option>1)
    
    enq = 3;
    ntheta = 401*ones(enq,1); % Edit into a non-constant array if needed. Any odd number will work.
    qtab_smooth = NaN(enq+1,2); % Includes the axis
    
    psi_for_q_list = NaN(enq,1);
    psi_for_q_list = linspace(0,enq/(enq+1),enq);
    %psi_for_q_list(end) = 0.999; % Uncomment this line to confirm q0.
    
    % Make sure that one value is 0.05, so that we can give q95
    [temppsi, i95] = min(abs(psi_for_q_list(2:end)-0.05));
    psi_for_q_list(i95+1) = 0.05;
    
    xlastL = -1;
    xlastR = 1;
    
    % The safety factor goes to infinity on the LCFS if there is an X point.
    % For that reason, we start from the second value of psi.
    % If so desired, one can run the integrals starting from the psi=0 surface
    % for all shapes. The code will return a "large" value if there is an
    % X-point.
    if(eq_option==1)
        iqstart = 1;
    else
        iqstart = 2;
    end
    
    for i = iqstart:enq
        % Start from the outside and move inwards.
        
        psiloc = psi_for_q_list(i);
        nthetaloc = ntheta(i);
        nthetamid = (nthetaloc-1)/2;
        
        % Note that this overwrites the previous lists.
        xlist = NaN(nthetaloc,1);
        ylist = NaN(nthetaloc,1);
        % Find the left and right crossings of the horizontal axis for this
        % value of psi.
        
        if(i==1)
            % We set up the arrays in a different way following earlier versions.
            % The easiest thing to do is to redefine the arrays in the same way as
            % for all other surfaces.
            xcrossL = -1;
            xcrossR = 1;
            
            xlastL = xcrossL;
            xlastR = xcrossR;
            
            % Fill the x grid
            xlist(1:nthetamid) = linspace(xcrossR,xcrossL,nthetamid);
            xlist(nthetamid:end) = linspace(xcrossL,xcrossR,nthetamid+2);
            
            % Fill the y grid using the functions created earlier.
            % (Repeated point is just to agree with the rest, it does not create any
            % issues)
            ylist(1:nthetamid) = ytoplast(xlist(1:nthetamid));
            ylist(nthetamid:end) = ybotlast(xlist(nthetamid:end));
            
        else
            
            fforcross = @(x) psi_any_shape(x,0)-psi_surf-psiloc;
            crossstart = [xlastL xaxis];
            xcrossL = fzero(fforcross,crossstart);
            crossstart = [ xaxis xlastR];
            xcrossR = fzero(fforcross,crossstart);
            
            xlastL = xcrossL;
            xlastR = xcrossR;
            
            % Fill the x grid
            xlist(1:nthetamid) = linspace(xcrossR,xcrossL,nthetamid);
            xlist(nthetamid:end) = linspace(xcrossL,xcrossR,nthetamid+2);
            
            % Now fill the y grid. We need to do this by steps.
            
            ylist(1) = 0;
            
            for j = 2:nthetamid-1
                
                xloc = xlist(j);
                ffory = @(y) psi_any_shape(xloc,y)-psi_surf-psiloc;
                zerostartb = ytoplast(xloc);
                zerostart = [0 zerostartb];
                jj = 0;
                while(ffory(zerostart(1,1))*ffory(zerostart(1,2))>0)
                    temp = zerostart(1,2) + 0.002;
                    zerostart(1,2) = temp;
                end
                yloc = fzero(ffory,zerostart);
                ylist(j) = yloc;
                
            end
            
            ylist(nthetamid) = 0;
            
            for j = nthetamid+1:nthetaloc-1
                
                xloc = xlist(j);
                ffory = @(y) psi_any_shape(xloc,y)-psi_surf-psiloc;
                zerostart = [ybotlast(xloc) 0];
                while(ffory(zerostart(1))*ffory(zerostart(2))>0)
                    zerostart(1) = zerostart(1)-0.002;
                end
                yloc = fzero(ffory,zerostart);
                ylist(j) = yloc;
                
            end
            
            ylist(nthetaloc) = 0;
            
            % Now redefine the y(x) functions and use them to find ymax(s) for this
            % surface.
            
            fystepofxB = spline(xlist(1:nthetamid),ylist(1:nthetamid));
            ytoplast = @(x) ppval(fystepofxB,x);
            
            fystepofxT = spline(xlist(nthetamid:end),ylist(nthetamid:end));
            ybotlast = @(x) ppval(fystepofxT,x);
            
        end
        yuplist = ylist(1:nthetamid);
        ydownlist = ylist(nthetamid+1:end);
        
        [xbot, ybot] = fminbnd(ybotlast,xlastL,xlastR);
        ymaxB = -ybot;
        
        ytemp = @(x) -ytoplast(x);
        [xtop, ytop] = fminbnd(ytemp,xlastL,xlastR);
        ymaxT = -ytop;
        
        if(psiloc==0.05)
            kappa95 = (ymaxB+ymaxT)/2;
        end
        
        % Now determine theta
        
        thetatempT = real(asin(yuplist./ymaxT));
        thetatempB = real(asin(ydownlist./ymaxB));
        
        [thmaxT iTop]=max(thetatempT);
        thetatempT(iTop+1:end) = pi - thetatempT(iTop+1:end);
        
        [thminB iBot]=min(thetatempB);
        thetatempB(1:iBot) = -thetatempB(1:iBot)+pi;
        thetatempB(iBot+1:end) = 2*pi + thetatempB(iBot+1:end);
        
        theta_list = [thetatempT; thetatempB];
        
        
        spline_x_level = spline(theta_list,xlist);
        xlvlfun = @(x) ppval(spline_x_level,x);
        
        % We need two integrands because the plasma shape may not be symmetric.
        fq_smoothT = @(th) -ymaxT*cos(th)./((1+eps^2+2*eps*xlvlfun(th)) .* ...
            psi_x_any_shape(xlvlfun(th),ymaxT*sin(th)));
        fq_smoothB = @(th) -ymaxB*cos(th)./((1+eps^2+2*eps*xlvlfun(th)) .* ...
            psi_x_any_shape(xlvlfun(th),ymaxB*sin(th)));
        
        % Now, the issue is that this function is analytically smooth, but
        % numerically it can blow up near the zeros of the denominator. As of
        % now, it is unclear why this happens, but we'll deal with it as we can
        % for a start.
        
        % First, find the zeros.
        
        fden = @(th) psi_x_any_shape(xlvlfun(th),ymaxT*sin(th));
        zero1 = fzero(fden,pi/2);
        fden = @(th) psi_x_any_shape(xlvlfun(th),ymaxB*sin(th));
        zero2 = fzero(fden,3*pi/2);
        
        % Then break the integral in four parts, just "dropping" the trouble
        % spots.
        
        % Part 1
        
        th1_end = zero1-safe_small;
        int_part1 = integral(fq_smoothT,0,th1_end);
        th_interval_1 = th1_end;
        th_interval_1_right = zero1;
        
        int_part1 = int_part1/th_interval_1*th_interval_1_right;
        
        % Part 2
        th2_start = zero1+safe_small;
        th2_end = pi;
        int_part2 = integral(fq_smoothT,th2_start,th2_end);
        th_interval_2 = th2_end-th2_start;
        th_interval_2_right = pi-zero1;
        
        int_part2 = int_part2/th_interval_2*th_interval_2_right;
        
        % Part 3
        th3_start = pi;
        th3_end = zero2-safe_small;
        int_part3 = integral(fq_smoothB,th3_start,th3_end);
        th_interval_3 = th3_end-th3_start;
        th_interval_3_right = th_interval_3+safe_small;
        
        int_part3 = int_part3/th_interval_3*th_interval_3_right;
        
        
        % Part 4
        th4_start = zero2+safe_small;
        th4_end = 2*pi;
        int_part4 = integral(fq_smoothB,th4_start,th4_end);
        th_interval_4 = th4_end-th4_start;
        th_interval_4_right = th_interval_4+safe_small;
        
        int_part4 = int_part4/th_interval_4*th_interval_4_right;
        
        inte_smooth = int_part1+int_part2+int_part3+int_part4;
        
%         qloc_smooth = inte_smooth * bigF(psiloc)/(R0*B0)*sqrt(nu/beta0)* ...
%             eps*alphasol/(2*pi);
%         
%         qtab_smooth(i,:) = [psiloc qloc_smooth];
%         if(psiloc==0)
%             qa = qloc_smooth
%         elseif(psiloc==0.05)
%             q95 = qloc_smooth
%         end
        
    end
    
end

% Now we can calculate q*.

if(eq_option==1)
    kappa_star = kappa;
else
    kappa_star = kappa95;
end

qstar = 2*pi*eps^2*R0*B0/(mu0*I_plasma_temp) * ((1+kappa_star^2)/2) * ...
    DeltaB_sol * (1-f_B)

file4 = join(['beta_p qstar',nameb]);

beta_qstar_res = [betapol qstar];

if(case_5==1)
    nfile4 = fullfile('../../','for paper/data with pedestal/case 5',file4);
elseif(case_7==1)
    nfile4 = fullfile('../../','for paper/data with pedestal/case 7',file4);
elseif(case_8==1)
    nfile4 = fullfile('../../','for paper/data with pedestal/case 8',file4);
elseif(case_1==1)
    nfile4 = fullfile('../../','for paper/data with pedestal/case 1',file4);
elseif(case_3==1)
    nfile4 = fullfile('../../','for paper/data with pedestal/case 3',file4);
end
save(nfile4,'beta_qstar_res','-ascii');
betapol


psilist = linspace(0,1,40);
plist = beta0*B0^2/(2*mu0)*psilist.^2;
Flist = bigF(psilist);

pofpsi_out = [psilist; plist]';
Fofpsi_out = [psilist; Flist]';

save('p_iso.dat','pofpsi_out','-ascii');
save('b0.dat','Fofpsi_out','-ascii');

%keyboard
return



if(eq_option==1)
    q_star = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa^2)/int_t1;
    q_star_new = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa^2)/int_t1_new
elseif(eq_option==2)
    q_star = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1;
    q_star_new = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1_new
elseif(eq_option==3)
    q_star = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1;
    q_star_new = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1_new
end










% q_axis calculation

if(pick_q0==0)
    
    psi_xx_0 = psi_xx_any_shape(xaxis,yaxis);
    psi_yy_0 = psi_yy_any_shape(xaxis,yaxis);
    xloc = 1+eps^2+2*eps*xaxis;
    
    psiloc = 1;
    q0 = bigF(psiloc)/(R0*B0) * sqrt(gamma/beta0) * eps * alphasol / ...
        (xloc * sqrt(psi_xx_0*psi_yy_0))
    
else
    
    psiloc=1;
    q0
    
end

qtab_smooth(end,:) = [psiloc q0];

% End of q calculation
% Keep in mind that we are only using 50 points for the level curves, but
% one is free to use as many as desired. Since the solution is analytical,
% there is no intrinsic limitation on the resolution!

% Now also calculate q_star
if(eq_option==1)
    q_star = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa^2)/int_t1;
    q_star_new = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa^2)/int_t1_new
elseif(eq_option==2)
    q_star = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1;
    q_star_new = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1_new
elseif(eq_option==3)
    q_star = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1;
    q_star_new = pi*eps/alphasol * sqrt(gamma/beta0) * (1+kappa95^2)/int_t1_new
end

% Save some more FLOW input.

psilist = linspace(0,1,40);
plist = beta0*B0^2/(2*mu0)*psilist.^2;
Flist = bigF(psilist);

pofpsi_out = [psilist; plist]';
Fofpsi_out = [psilist; Flist]';

save('p_iso.dat','pofpsi_out','-ascii');
save('b0.dat','Fofpsi_out','-ascii');

save('R_Z_shape.dat','save_for_FLOW','-ascii');

if(noplots==0)
    figure
    plot(qtab_smooth(iqstart:end,1),qtab_smooth(iqstart:end,2),'-o')
    hold on
end

toc

% Other checks. There are for debugging purposes and comparison with FLOW.

% small = 10.^-6;
% xleft = xaxis-small;
% xright = xaxis+small;
% yleft = yaxis-small;
% yright = yaxis+small;
%
% psi_xx_0_test = (psi_for_integral(xleft,yaxis) - ...
%     2*psi_for_integral(xaxis,yaxis) + ...
%     psi_for_integral(xright,yaxis))/small^2;
%
% psi_yy_0_test = (psi_for_integral(xaxis,yleft) - ...
%     2*psi_for_integral(xaxis,yaxis) + ...
%     psi_for_integral(xaxis,yright))/small^2;
%
% (psi_xx_0_test-psi_xx_0)/psi_xx_0
%
% (psi_yy_0_test-psi_yy_0)/psi_yy_0

% qofpsi = load('./temp/qofpsi_11.dat');
% qofpsi(:,1) = qofpsi(:,1)/qofpsi(1,1);
% plot(qofpsi(:,1),qofpsi(:,2),'-o')
