function [bigK] = Kpar_phi_ov_B0(thetain,DeltaB)

global beta0 f_P R0 xlvlfunS ylvlfunS eps xoftheta yoftheta Roftheta psiloc

bigK = NaN;

psiloc = 0;

xoftheta = @(theta) xlvlfunS(theta);
yoftheta = @(theta) ylvlfunS(theta);
Roftheta = @(theta) R0*sqrt(1 + 2*eps*xoftheta(theta) + eps^2);

Bphihat_ov_B0 = @(theta) Bphi_ov_B0(theta) + (DeltaB-1)*R0*Roftheta(theta);

Bpolhat_ov_B0 = @(theta) sqrt(Bpol_ov_B0(theta).^2 + ...
    beta0*f_P-(DeltaB-1)*R0^2./Roftheta(theta).^2);

% Define barred quantities as normalized. This won't matter, since they
% only appear in ratios.
Bphibar = @(theta) (Bphihat_ov_B0(theta)+Bphi_ov_B0(theta))/2;
Bpolbar = @(theta) (Bpolhat_ov_B0(theta)+Bpol_ov_B0(theta))/2;
Bbar = @(theta) sqrt(Bphibar(theta)+Bpolbar(theta));

% There should be a 1/mu_0 here, but we omit it for convenience reasons.

t1 = -(Bpolhat_ov_B0(thetain) - Bpol_ov_B0(thetain))...
    .*Bphibar(thetain)./Bbar(thetain);

t2 = (Bphihat_ov_B0(thetain) - Bphi_ov_B0(thetain))...
    .*Bpolbar(thetain)./Bbar(thetain);

bigK = (t1+t2).*Bphibar(thetain)./Bbar(thetain);
