function [norm_error] = Err_for_pedestal_with_flow(alpha)
   
global nseries  hvec kvec eps kappa delta dh xtab xtab_m1 nu...
    xtabm xtabp xtabTop xtabm_m1 xtabp_m1 xtabTop_m1 xm xp xTop ...
    xX yX xtabX xtabX_m1 cfull sfull clist slist...
    anC bnC anS bnS epsbar yTop kvec_ref eq_option psi_surf zaxis yaxis...
    psi_axis_input psimax delta_X kappa_X csi ssfull scfull nu1 nu2 nu3...
    epshat


norm_error = NaN;
    
if((eq_option == 1)|(eq_option == 2))
    % Miller profile or Double Null equilibrium
    neqs = 7;
elseif(eq_option == 3)
    % Single Null equilibrium
    neqs = 12;
end
        
% Also define here the separation constants (edit as needed).

eteps = sqrt(1+eps^2)*alpha;

%-------- Standard definition -------
% kvec = [0 1/6 6/7 1]
%-------- End of standard definition -------

%------------k_n is assigned outside for clarity---------

kvec = kvec_ref;
kvec = kvec*alpha;
hvec = sqrt((alpha^2-kvec.^2)*(1+eps^2));

%-------------------------------------------
% First part: define the series coefficients

lam1 = alpha*sqrt(epshat*nu1);
lam2 = alpha*sqrt(epshat*nu2);
lam3 = alpha*sqrt(epshat*nu3);

% Notice the "+1": I prefer to enter the index of the last term, rather than
% the number of terms
anC = NaN(nseries+1,4);
bnC = anC;

anS = anC;
bnS = bnC;

if(eq_option==3)
    Xcvalue = NaN(4,4); %First index is the point location
else
    Xcvalue = NaN(3,4); %First index is the point location
end

XSvalue = Xcvalue;
Xcprim = Xcvalue;
Xsprim = XSvalue;

astartC = [1,0,0]';
bstartC = [0,0,0]';

astartS = [0,0,0]';
bstartS = [1,0,0]';

for i=1:4 % it may be possible to do this with a vector call, but it's not worth it
    [anC(:,i), bnC(:,i)] = an_bn_fun_with_flow(nseries, lam1, lam2, lam3,...
        epshat, kvec(i), astartC, bstartC);
    [anS(:,i), bnS(:,i)] = an_bn_fun_with_flow(nseries, lam1, lam2, lam3,...
        epshat, kvec(i), astartS, bstartS);
end


%-------------------------------------------
% Second part: fill the arrays of "S" and "C" functions with values

% Point xm

Xcvalue(1,:) = dot(xtabm',anC).*cos(kvec*xm) + ...
    dot(xtabm',bnC).*sin(kvec*xm);

Xsvalue(1,:) = dot(xtabm',anS).*cos(kvec*xm) + ...
    dot(xtabm',bnS).*sin(kvec*xm);

Xcprim(1,:) = dot(xtabm_m1',anC).*cos(kvec*xm) + ...
    dot(xtabm_m1',bnC).*sin(kvec*xm) + ...
    kvec.*(dot(xtabm',bnC).*cos(kvec*xm) - ...
    dot(xtabm',anC).*sin(kvec*xm));

Xsprim(1,:) = dot(xtabm_m1',anS).*cos(kvec*xm) + ...
    dot(xtabm_m1',bnS).*sin(kvec*xm) + ...
    kvec.*(dot(xtabm',bnS).*cos(kvec*xm) - ...
    dot(xtabm',anS).*sin(kvec*xm));


% Point xp

Xcvalue(2,:) = dot(xtabp',anC).*cos(kvec*xp) + ...
    dot(xtabp',bnC).*sin(kvec*xp);

Xsvalue(2,:) = dot(xtabp',anS).*cos(kvec*xp) + ...
    dot(xtabp',bnS).*sin(kvec*xp);

Xcprim(2,:) = dot(xtabp_m1',anC).*cos(kvec*xp) + ...
    dot(xtabp_m1',bnC).*sin(kvec*xp) + ...
    kvec.*(dot(xtabp',bnC).*cos(kvec*xp) - ...
    dot(xtabp',anC).*sin(kvec*xp));

Xsprim(2,:) = dot(xtabp_m1',anS).*cos(kvec*xp) + ...
    dot(xtabp_m1',bnS).*sin(kvec*xp) + ...
    kvec.*(dot(xtabp',bnS).*cos(kvec*xp) - ...
    dot(xtabp',anS).*sin(kvec*xp));

% The first two points are in common for all the shapes. For the
% remaining one or two we need to differentiate depending on the
% equilibrium shape.

if(eq_option==1)
    % Point xTop
    
    Xcvalue(3,:) = dot(xtabTop',anC).*cos(kvec*xTop) + ...
        dot(xtabTop',bnC).*sin(kvec*xTop);
    
    Xsvalue(3,:) = dot(xtabTop',anS).*cos(kvec*xTop) + ...
        dot(xtabTop',bnS).*sin(kvec*xTop);
    
    Xcprim(3,:) = dot(xtabTop_m1',anC).*cos(kvec*xTop) + ...
        dot(xtabTop_m1',bnC).*sin(kvec*xTop) + ...
        kvec.*(dot(xtabTop',bnC).*cos(kvec*xTop) - ...
        dot(xtabTop',anC).*sin(kvec*xTop));
    
    Xsprim(3,:) = dot(xtabTop_m1',anS).*cos(kvec*xTop) + ...
        dot(xtabTop_m1',bnS).*sin(kvec*xTop) + ...
        kvec.*(dot(xtabTop',bnS).*cos(kvec*xTop) - ...
        dot(xtabTop',anS).*sin(kvec*xTop));
    
elseif(eq_option==2)
    % Point xTop <-> X-point
    
    Xcvalue(3,:) = dot(xtabX',anC).*cos(kvec*xX) + ...
        dot(xtabX',bnC).*sin(kvec*xX);
    
    Xsvalue(3,:) = dot(xtabX',anS).*cos(kvec*xX) + ...
        dot(xtabX',bnS).*sin(kvec*xX);
    
    Xcprim(3,:) = dot(xtabX_m1',anC).*cos(kvec*xX) + ...
        dot(xtabX_m1',bnC).*sin(kvec*xX) + ...
        kvec.*(dot(xtabX',bnC).*cos(kvec*xX) - ...
        dot(xtabX',anC).*sin(kvec*xX));
    
    Xsprim(3,:) = dot(xtabX_m1',anS).*cos(kvec*xX) + ...
        dot(xtabX_m1',bnS).*sin(kvec*xX) + ...
        kvec.*(dot(xtabX',bnS).*cos(kvec*xX) - ...
        dot(xtabX',anS).*sin(kvec*xX));
    
elseif(eq_option==3)
    % This is a repetition, but it is worth to keep things clean.

    % Point xTop
    
    Xcvalue(3,:) = dot(xtabTop',anC).*cos(kvec*xTop) + ...
        dot(xtabTop',bnC).*sin(kvec*xTop);
    
    Xsvalue(3,:) = dot(xtabTop',anS).*cos(kvec*xTop) + ...
        dot(xtabTop',bnS).*sin(kvec*xTop);
    
    Xcprim(3,:) = dot(xtabTop_m1',anC).*cos(kvec*xTop) + ...
        dot(xtabTop_m1',bnC).*sin(kvec*xTop) + ...
        kvec.*(dot(xtabTop',bnC).*cos(kvec*xTop) - ...
        dot(xtabTop',anC).*sin(kvec*xTop));
    
    Xsprim(3,:) = dot(xtabTop_m1',anS).*cos(kvec*xTop) + ...
        dot(xtabTop_m1',bnS).*sin(kvec*xTop) + ...
        kvec.*(dot(xtabTop',bnS).*cos(kvec*xTop) - ...
        dot(xtabTop',anS).*sin(kvec*xTop));

    % Point xTop <-> X-point
    
    Xcvalue(4,:) = dot(xtabX',anC).*cos(kvec*xX) + ...
        dot(xtabX',bnC).*sin(kvec*xX);
    
    Xsvalue(4,:) = dot(xtabX',anS).*cos(kvec*xX) + ...
        dot(xtabX',bnS).*sin(kvec*xX);
    
    Xcprim(4,:) = dot(xtabX_m1',anC).*cos(kvec*xX) + ...
        dot(xtabX_m1',bnC).*sin(kvec*xX) + ...
        kvec.*(dot(xtabX',bnC).*cos(kvec*xX) - ...
        dot(xtabX',anC).*sin(kvec*xX));
    
    Xsprim(4,:) = dot(xtabX_m1',anS).*cos(kvec*xX) + ...
        dot(xtabX_m1',bnS).*sin(kvec*xX) + ...
        kvec.*(dot(xtabX',bnS).*cos(kvec*xX) - ...
        dot(xtabX',anS).*sin(kvec*xX));
    
end
%-------------------------------------------
% Third part: fill the matrix of coefficients and right-hand side.
% Important note: the error is going to be defined in terms of the
% normalization requirement. Therefore we will have 7 equations and
% coefficients, instead of the 6 in the smooth case.
% Very important: the order of variables is {c1,c2,s2,c3,s3,c4,s4} for the
% Miller case and the double-null case.

mcoef = NaN(neqs);
rhs = NaN(neqs,1);

indC = [1 2 4 6];
indS = [3 5 7];

if(eq_option==3)
    indsC = [8 9 10];
    indsS = [11 12];
end

eqind = 0;

% Equation 1 (a): psi(-1,0) = psi_surf

eqind = eqind + 1;

mcoef(eqind,indC) = Xcvalue(1,:);
mcoef(eqind,indS) = Xsvalue(1,2:4);

if(eq_option==3)
    mcoef(eqind,indsC) = 0;
    mcoef(eqind,indsS) = 0;
end

rhs(eqind) = psi_surf;


% Equation 2 (b): psi(1,0) = psi_surf

eqind = eqind + 1;

mcoef(eqind,indC) = Xcvalue(2,:);
mcoef(eqind,indS) = Xsvalue(2,2:4);

if(eq_option==3)
    mcoef(eqind,indsC) = 0;
    mcoef(eqind,indsS) = 0;
end

rhs(eqind) = psi_surf;


% Equation 3 (c): psi(z_top,y_top) = psi_surf

eqind = eqind + 1;

if(eq_option==1)
    mcoef(eqind,indC) = Xcvalue(3,:).*cos(yTop*hvec(:))';
    mcoef(eqind,indS) = Xsvalue(3,2:4).*cos(yTop*hvec(2:4));
elseif(eq_option==2)
    mcoef(eqind,indC) = Xcvalue(3,:).*cos(yX*hvec(:))';
    mcoef(eqind,indS) = Xsvalue(3,2:4).*cos(yX*hvec(2:4));
elseif(eq_option==3)
    mcoef(eqind,indC) = Xcvalue(3,:).*cos(yTop*hvec(:)');
    mcoef(eqind,indS) = Xsvalue(3,2:4).*cos(yTop*hvec(2:4));
    mcoef(eqind,indsC) = Xcvalue(3,1:3).*sin(yTop*hvec(1:3));
    mcoef(eqind,indsS) = Xsvalue(3,2:3).*sin(yTop*hvec(2:3));
end

rhs(eqind) = psi_surf;

if(eq_option==3)
    % Equation 4 (d)
    % The new Eq. (d) is imposed in the lower X point
    
    eqind = eqind + 1;
    
    mcoef(eqind,indC) = Xcvalue(4,:).*cos(yX*hvec(:)');
    mcoef(eqind,indS) = Xsvalue(4,2:4).*cos(yX*hvec(2:4));
    mcoef(eqind,indsC) = Xcvalue(4,1:3).*sin(yX*hvec(1:3));
    mcoef(eqind,indsS) = Xsvalue(4,2:3).*sin(yX*hvec(2:3));
    
    rhs(eqind) = psi_surf;
 
    % Equation 5 (e): psi_y(-1,0) = 0
    
    eqind = eqind + 1;
    
    mcoef(eqind,indC) = 0;
    mcoef(eqind,indS) = 0;
    mcoef(eqind,indsC) = Xcvalue(1,1:3).*hvec(1:3);
    mcoef(eqind,indsS) = Xsvalue(1,2:3).*hvec(2:3);
    
    rhs(eqind) = 0;
    
    % Equation 6 (f): psi_y(1,0) = 0
    
    eqind = eqind + 1;
    
    mcoef(eqind,indC) = 0;
    mcoef(eqind,indS) = 0;
    mcoef(eqind,indsC) = Xcvalue(2,1:3).*hvec(1:3);
    mcoef(eqind,indsS) = Xsvalue(2,2:3).*hvec(2:3);
    
    rhs(eqind) = 0;

end



% Equation 4 (d): psi_z(z_top,y_top) = 0
% This is Equation 7 for the SN case

eqind = eqind + 1;

if(eq_option==1)
    mcoef(eqind,indC) = Xcprim(3,:).*cos(yTop*hvec(:))';
    mcoef(eqind,indS) = Xsprim(3,2:4).*cos(yTop*hvec(2:4));
elseif(eq_option==2)
    mcoef(eqind,indC) = Xcprim(3,:).*cos(yX*hvec(:))';
    mcoef(eqind,indS) = Xsprim(3,2:4).*cos(yX*hvec(2:4));
elseif(eq_option==3)
    mcoef(eqind,indC) = Xcprim(3,:).*cos(yTop*hvec(:)');
    mcoef(eqind,indS) = Xsprim(3,2:4).*cos(yTop*hvec(2:4));
    mcoef(eqind,indsC) = Xcprim(3,1:3).*sin(yTop*hvec(1:3));
    mcoef(eqind,indsS) = Xsprim(3,2:3).*sin(yTop*hvec(2:3));
end

rhs(eqind) = 0;

if(eq_option==3)
    
    % Equation 8 (h): psi_z(xX,yX)=0
    % This is the same as old Eq. (d).
    
    eqind = eqind + 1;
    
    mcoef(eqind,indC) = Xcprim(4,:).*cos(yX*hvec(:)');
    mcoef(eqind,indS) = Xsprim(4,2:4).*cos(yX*hvec(2:4));
    mcoef(eqind,indsC) = Xcprim(4,1:3).*sin(yX*hvec(1:3));
    mcoef(eqind,indsS) = Xsprim(4,2:3).*sin(yX*hvec(2:3));
    
    rhs(eqind) = 0;
   
    % Equation 9 (i): psi_y(xX,yX)=0
    % This is to define the X-point [used to be Eq. (g) in the DN version].
    
    eqind = eqind + 1;
    
    mcoef(eqind,indC) =  -hvec(:).*sin(yX*hvec(:)).*Xcvalue(4,:)';
    mcoef(eqind,indS) = -hvec(2:4).*sin(hvec(2:4)*yX).*Xsvalue(4,2:4);
    mcoef(eqind,indsC) = hvec(1:3).*cos(hvec(1:3)*yX).*Xcvalue(4,(1:3));
    mcoef(eqind,indsS) = hvec(2:3).*cos(hvec(2:3)*yX).*Xsvalue(4,2:3);
    
    rhs(eqind) = 0;
    
end


% Equation 5 (e): assign curvature in (-1,0)
% This is equation 10 for the SN case.

eqind = eqind + 1;

% Note: we define this with the opposite sign with respect to Jeff's notes.
if(eq_option==1)
    Lambda1 = -(1-eps)*(1-dh)^2/(kappa^2);
elseif(eq_option==2)
    Lambda1 = -(1-eps)*(1-delta_X)*(1+csi)/(kappa_X^2);
elseif(eq_option==3)
    Lambda1 =  -(1-eps)*(1-dh)^2/(kappa^2)-(1-eps)*(1-delta_X)*(1+csi)/(kappa_X^2);
    Lambda1 = Lambda1/2;
end

mcoef(eqind,indC) = Xcvalue(1,:).*(hvec(:).^2)' + ...
    Lambda1*Xcprim(1,:);
mcoef(eqind,indS) = Xsvalue(1,2:4).*(hvec(2:4).^2 )+ ...
    Lambda1*Xsprim(1,2:4);

if(eq_option==3)
    mcoef(eqind,indsC) = 0;
    mcoef(eqind,indsS) = 0;
end

rhs(eqind) = 0;


% Equation 6 (f): assign curvature in (1,0)
% This is Equation 11 for the SN case.

eqind = eqind + 1;

if(eq_option==1)
    Lambda2 = (1+eps)*(1+dh)^2/(kappa^2);
elseif(eq_option==2)
    Lambda2 = (1+eps)*(1+delta_X)*(1+csi)/(kappa_X^2);
elseif(eq_option==3)
    Lambda2 = (1+eps)*(1+dh)^2/(kappa^2)+(1+eps)*(1+delta_X)*(1+csi)/(kappa_X^2);
    Lambda2 = Lambda2/2;
end

mcoef(eqind,indC) = Xcvalue(2,:).*(hvec(:).^2)' + ...
    Lambda2*Xcprim(2,1:4);
mcoef(eqind,indS) = Xsvalue(2,2:4).*(hvec(2:4).^2 )+ ...
    Lambda2*Xsprim(2,2:4);

if(eq_option==3)
    mcoef(eqind,indsC) = 0;
    mcoef(eqind,indsS) = 0;
end

rhs(eqind) = 0;


% Equation 7 (g): assign curvature in (z_top,y_top)

eqind = eqind + 1;

if(eq_option==1)
    
    Lambda3 = kappa/((1-eps*delta)^2*(1-delta^2));
    
    d2term = -(kvec.^2+lam1^2*xTop+lam2^2*xTop.^2+lam3^2*xTop.^3)/(1+epshat*xTop);
    
    mcoef(eqind,indC) = (cos(yTop*hvec).*d2term + ...
        Lambda3*hvec.*sin(yTop*hvec)).*Xcvalue(3,:);
    mcoef(eqind,indS) = (cos(yTop*hvec(2:4)).*d2term(2:4) + ...
        Lambda3*hvec(2:4).*sin(yTop*hvec(2:4))).*Xsvalue(3,2:4);
    
elseif(eq_option==2)
    
    mcoef(eqind,indC) = hvec.*sin(hvec*yX).*Xcvalue(3,:);
    mcoef(eqind,indS) = hvec(2:4).*sin(hvec(2:4)*yX).*Xsvalue(3,2:4);
    
elseif(eq_option==3)
    
    Lambda3 = kappa/((1-eps*delta)^2*(1-delta^2));
    
    d2term = -(kvec.^2+lam1^2*xTop+lam2^2*xTop.^2+lam3^2*xTop.^3)/(1+epshat*xTop);
    
    mcoef(eqind,indC) = (cos(yTop*hvec).*d2term + ...
        Lambda3*hvec.*sin(yTop*hvec)).*Xcvalue(3,:);
    mcoef(eqind,indS) = (cos(yTop*hvec(2:4)).*d2term(2:4) + ...
        Lambda3*hvec(2:4).*sin(yTop*hvec(2:4))).*Xsvalue(3,2:4);
    
    mcoef(eqind,indsC) = (sin(yTop*hvec(1:3)).*d2term(1:3) - ...
        Lambda3*hvec(1:3).*cos(yTop*hvec(1:3))).*Xcvalue(3,1:3);
    mcoef(eqind,indsS) = (sin(yTop*hvec(2:3)).*d2term(2:3) - ...
        Lambda3*hvec(2:3).*cos(yTop*hvec(2:3))).*Xsvalue(3,2:3);

end

rhs(eqind) = 0;

%-------------------------------------------
% Fourth part: solve the linear system and replace values in the
% normalization equation.

solvec = linsolve(mcoef,rhs);

clist = solvec(indC)';
slist = solvec(indS)';

if(eq_option==3)
    sclist = solvec(indsC)';
    sslist = solvec(indsS)';
end

% Since we have already used all the equations, the arrays of sn and cn
% already have all necessary elements and orders. We still introduce
% additional arrays to match what is done in the "smooth" case.

sfull = [0, slist];

cfull = clist;
indCfull = indC;

if(eq_option==3)
    scfull = sclist;
    ssfull = [0, sslist];
end

% Now the time-consuming part: We need to find the axis.

psimax = 1;

fun_for_max = @(xx) -psi_any_shape(xx(1),xx(2));

xxstart = [0 0];
xxmax = fminsearch(fun_for_max,xxstart);
psimax = psi_any_shape(xxmax(1),xxmax(2));

zaxis = xxmax(1);
yaxis = xxmax(2);

norm_error = ((psimax - psi_axis_input)/(abs(psimax) + psi_axis_input))^2;


end