% This solves all the shapes.

close all
clear all

global nseries  hvec kvec eps kappa kappa_X delta_X xtab xtab_m1 gamma...
    xtabm xtabp xtabTop xtabX xtabm_m1 xtabp_m1 xtabTop_m1 xtabX_m1 xm xp zTop xX...
    dh powers powers_m1 twoD epsbar yTop yX cfull sfull csi psisign kappa delta...
    kvec_ref eq_option nlevels vlevel f_J f_P psi_surf psi_axis_input psimax...
    pedestal_option


pedestal_option = 0;
eq_option = 2;
% 1 for Miller profile,
% 2 for Double Null
% 3 for Single Null

twoD = 0;
nR = 160;
nZ = 250;

oneDplot = 0;
noplots = 0;

%-------------------------------------------
% Data: Modify the data corresponding to the desired equilibrium shape.
% Note that R0 is not needed for calculating the solution. We introduce it
% here simply to be able to plot the solution.

if(eq_option==1)
    % Miller profile
    
%     %circle
%     eps = 1/4;
%     eps = 0.87/2.52; %TFTR, just use 1/3
%     eps = 1/3;
%     delta = 0;
%     kappa = 1;
%     % For 1/4
%     alpha_L = 2.35; %2.02
%     alpha_R = 2.37; %2.06
%     % For 1/3
%     alpha_L = 2.33; %2.02
%     alpha_R = 2.37; %2.06
    
    %ellipse
%     eps = 1/4; % just to change something
%     delta = 0;
%     kappa = 2;

    %ellipse, high elongation
%     eps = 0.8;
%     delta = 0.;
%     kappa = 3;

    % Standard, DIII-D-like
%     eps = 1/3;
%     delta = 0.6;
%     kappa = 1.8;

%     % High triangularity, high beta poloidal
%     eps = 0.4;
%     delta = 0.75;
%     kappa = 1.6;
    
%     % High triangularity, high beta poloidal, high kappa
%     eps = 0.4;
%     delta = 0.75;
%     kappa = 2.2;    
    
%     % High triangularity, high beta poloidal, high kappa, final version
%     (gamma=1)
    eps = 0.4;
    delta = 0.75;
    kappa = 2.0;

%     % Negative delta, DIII-D-like
%     eps = 1/3;
%     delta = -0.6;
%     kappa = 1.9;
elseif(eq_option==2)
    % Double null profile
    
    %NSTX
%     eps = 0.79;
%     kappa_X = 2.2;
%     delta_X = 0.5;
%     alpha_L = 1.75; %2.02
%     alpha_R = 1.77; %2.06
    
    % random possibility, but use SPARC
%     eps = 1/2.5;
eps=1/3;
    delta_X = 0.5;
    kappa_X = 2.0;
    % SPARC data
%     eps = 0.308;
%     delta_X = 0.54;
%     kappa_X = 1.97;
    %     R0 = 1.85;
    
    % High elongation
%     eps = 0.75;
%     delta_X = 0.8;
%     kappa_X = 2.4;
%     
%     eps = 0.2;
%     delta_X = 0.6;
%     kappa_X = 3;
    
elseif(eq_option==3)
    % Single null profile
    eps = 1/3;
    delta_X = 0.5;
    kappa_X = 2.;
    delta = 0.4;
    kappa = 1.6;

% low aspect ratio case
%     eps = 1/4;
%     delta_X = 0.8;
%     kappa_X = 2.1;
%     delta = 0.6;
%     kappa = 1.8;

%         eps = 0.2;
%     delta_X = 0.7;
%     kappa_X = 3;
%     delta = 0.5;
%     kappa = 3;
end

% HEREHEREHERE: Just enter the input you want to use here, if it is more
% convenient.
% TEST CASE 7: SPHERICAL TOKAMAK DN

eq_option = 2;
eps = 0.75;
epsbar = 2*eps/(1+eps^2);
delta_X = 0.8;
kappa_X = 2.4;
gamma = 1/epsbar;




dh = asin(delta);

if((eq_option==2)||(eq_option==3))
    
    sqdX=sqrt(1-delta_X^2);
    csi = sqdX/(kappa_X-sqdX);
    sqcsi = sqrt(1-csi^2);
    kappa_0 = kappa_X/sqcsi;
    
    xx1 = (csi-delta_X)/(1-csi);
    xx2 = (csi+delta_X)/(1-csi);
    
    theta0 = atan(sqcsi/csi);
    
end

R0 = 1.;
a = eps*R0;
epsbar = 2*eps/(1+eps^2);


nseries = 150;
nseries = 220;
psisign = 1;


%-------------------------------------------
% Part 0: define the points.
% Observe that once the geometry is defined all terms involving z never
% change, so they can be calculated once and for all outside the error
% function.

% Here we define the plasma reference shape, too. This is needed only for
% plotting.


if (noplots==0)
    
    if(eq_option==1)
        
        theta = linspace(0, 2*pi,300);
        bigR_edge = R0*(1+eps*cos(theta+dh*sin(theta)));
        bigZ_edge = kappa*R0*eps*sin(theta);
        
    elseif(eq_option==2)
        
        thetaL = linspace(pi-theta0,pi+theta0,150);
        thetaR = linspace(-theta0,theta0,150);
        
        bigX_L = xx1+(1+xx1)*cos(thetaL);
        bigY_L = kappa_0*sin(thetaL);
        
        bigX_R = -xx2+(1+xx2)*cos(thetaR);
        bigY_R = kappa_0*sin(thetaR);
        
        bigX=[bigX_L, bigX_R];
        bigY=[bigY_L, bigY_R];
        
        bigR_edge = a*bigX+R0;
        bigZ_edge = a*bigY;
        
    elseif(eq_option==3)
        
        thetaup = linspace(0,pi,150);
        thetaL = linspace(pi,pi+theta0,150);
        thetaR = linspace(2*pi-theta0,2*pi,150);
        
        bigX_up = cos(thetaup+dh*sin(thetaup));
        bigY_up = kappa*sin(thetaup);
        
        bigX_L = xx1+(1+xx1)*cos(thetaL);
        bigY_L = kappa_0*sin(thetaL);
        
        bigX_R = -xx2+(1+xx2)*cos(thetaR);
        bigY_R = kappa_0*sin(thetaR);
        
        bigX=[bigX_up, bigX_L, bigX_R];
        bigY=[bigY_up, bigY_L, bigY_R];
        
        bigR_edge = a*bigX+R0;
        bigZ_edge = a*bigY;
        
    end
    
end

xm = -1;
xp = 1;

if(eq_option==1)
    zTop = -delta-eps/2*(1-delta^2);
    yTop = kappa;
elseif(eq_option==2)
    xX = -delta_X-eps/2*(1-delta_X^2);
    yX = kappa_X;
    zTop = xX;
    yTop = yX;
elseif(eq_option==3)
    zTop = -delta-eps/2*(1-delta^2);
    yTop = kappa;
    xX = -delta_X-eps/2*(1-delta_X^2);
    yX = -kappa_X;
end

powers = [0:nseries];
powers_m1 = [0,0:nseries-1]; %The first 0 is just a place holder.

if(eq_option==1)
    xtab = [xm; xp; zTop].^powers;
    xtab_m1 = powers.*[xm; xp; zTop].^powers_m1;
elseif(eq_option==2)
    xtab = [xm; xp; xX].^powers;
    xtab_m1 = powers.*[xm; xp; xX].^powers_m1;
elseif(eq_option==3)
    xtab = [xm; xp; zTop; xX].^powers;
    xtab_m1 = powers.*[xm; xp; zTop; xX].^powers_m1;
end

% Still deciding the best way: it may work better to have matrices of the
% same points for different values of k.

xtabm = repmat(xtab(1,:),4,1);
xtabp = repmat(xtab(2,:),4,1);

xtabm_m1 = repmat(xtab_m1(1,:),4,1);
xtabp_m1 = repmat(xtab_m1(2,:),4,1);

if(eq_option==1)
    xtabTop = repmat(xtab(3,:),4,1);
    xtabTop_m1 = repmat(xtab_m1(3,:),4,1);
elseif(eq_option==2)
    xtabX = repmat(xtab(3,:),4,1);
    xtabX_m1 = repmat(xtab_m1(3,:),4,1);
elseif(eq_option==3)
    xtabTop = repmat(xtab(3,:),4,1);
    xtabTop_m1 = repmat(xtab_m1(3,:),4,1);
    xtabX = repmat(xtab(4,:),4,1);
    xtabX_m1 = repmat(xtab_m1(4,:),4,1);
end

% This combination works well for most cases. Feel free to experiment!
kvec_ref = [0 1/6 6/7 1];

    alphaminplot = 0.9;
    alphamaxplot = 2.75;


nplot = 600;

% This is used to get a good guess for the location of the root.

alphaplot = linspace(alphaminplot,alphamaxplot,nplot);
vals=NaN(size(alphaplot));
for i = 1:length(alphaplot)
    vals(i) = Err_smooth(alphaplot(i));
end
figure(1)
plot(alphaplot,vals)
dalpha = (alphamaxplot-alphaminplot)/(nplot-1);



% Now find alpha. First find local minima in vals, then use them as
% starting points for the minimum search. Stop when the value of the
% function is less than 10^-8;

locs = islocalmin(vals);
alphastarts=alphaplot(locs);

options = optimset('Display','iter','TolX',1e-8,'TolFun',1e-8);
% options = optimset('TolX',1e-8,'TolFun',1e-8);

alphaerr=1;
ind = 0;

while(alphaerr>10^-8)
    ind = ind+1;
    alphaL = alphastarts(ind)-dalpha;
    alphaR = alphastarts(ind)+dalpha;
    %    alphasol = fminsearch(@Err_general,alphastarts(ind),options)
    alphasol = fminbnd(@Err_smooth,alphaL,alphaR,options)
    alphaerr = Err_smooth(alphasol)
end

% end

%toc



Err_smooth(alphasol);

% In this case we need to check the sign of psi_axis.

psimax = 1;
psiref = psi_any_shape(0,0);

if(psiref<0)
    psisign = -1;
end

psiref = psisign*psiref;

if(noplots==0)
    
    % Let's plot the solution, just to visualize what we have done.
    bigR = linspace(R0*(1-eps)-0.05,R0*(1+eps)+0.05,nR);
    if(eq_option==1)
        bigZ = linspace(-a*kappa-0.05,a*kappa+0.05,nZ);
    elseif(eq_option==2)
        bigZ = linspace(-a*kappa_X-0.05,a*kappa_X+0.05,nZ);
    elseif(eq_option==3)
        bigZ = linspace(-a*kappa_X-0.05,a*kappa+0.05,nZ);
    end
    
    z_for_plot = (bigR.^2/R0^2-1-eps^2)/(2*eps);
    y_for_plot = bigZ./a;
    
    twoD = 1;
    psi2D = psi_any_shape(z_for_plot,y_for_plot);
    
    % Keep in mind that psi_any_shape is normalized to 1 in the center. We can
    % change this if we like.
    nlevels = 10;
    vlevel = linspace(0,psiref,nlevels);
    
    figure('Renderer', 'painters', 'Position', [500 300 900 600])
    [cm, h] = contourf(bigR,bigZ,psi2D,vlevel);
%     if(eq_option==1)
%         pbaspect([1 kappa 1])
%     elseif((eq_option==2)||(eq_option==3))
%         pbaspect([1 kappa_X 1])
%     end
axis image
    hold on
    
    plot(bigR_edge,bigZ_edge,'r','LineWidth',1)
    grid on
    
end


if(oneDplot>0)
    
    twoD = 0;
    bigR1D = linspace(R0*(1-eps),R0*(1+eps),nR);
    z_for_plot_1D = (bigR1D.^2/R0^2-1-eps^2)/(2*eps);
    %    psi1D = psimax*psi_any_shape(z_for_plot_1D,zeros(size(bigR1D)));
    psi1D = psi_any_shape(z_for_plot_1D,zeros(size(bigR1D)));
    
    figure(3)
    plot(bigR,psi1D)
    hold on
    
    
    %     figure(4)
    %     plot(bigR,psi1D/max(psi1D))
    %     hold on
    %
    %     figure(5)
    %     plot(bigR,(psi1D/max(psi1D)).^2)
    %     hold on
    
    % pressure
    figure
    plot(bigR1D,psi1D.^2*p0,'LineWidth',1.5)
    title('pressure')
    
    % J_phi
    Jphifunb = @(R,Z) (2*mu0*p0*R.^2 + 2*R0^2*B0^2*dB_ov_B).* ...
        psi_any_shape(zofRfun(R),yofZfun(Z))./psi_axis./R;
    figure
    plot(bigR1D,Jphifunb(bigR1D,zeros(size(bigR1D)))./mu0,'LineWidth',1.5)
    title('J_p_h_i')
    
end

