!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine tstep
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, ONLY : dkind, rsh,fcourant,dt,dx,dy,nx,ny,timen,&
	                    dt_min,rkappa,rnu,An, rmu0
	use mod_arrays, ONLY:rho,u,v,w,p,bx,by,bz,tn
	use boundary_routines, only : sort_grid

	implicit none

	real(kind=dkind) :: dt_dif_min, cv, dij, dt_dif, va, cs, dtx, dty, dti, dt_ps, time
	integer :: idt, jdt
	integer :: i, j

	dt_dif_min=1e30
	cv=1./(An*(rsh-1.))
    dt=1.d10
	do j=1,ny
	do i=1,nx

		if(sort_grid(i,j)<0) cycle

		 dij   =rkappa/(cv*rho(i,j)*(rnu+1.))
		 dt_dif=dx**2/(dij*(rnu+1)*tn(i,j)**rnu)
		 if(dt_dif<dt_dif_min)dt_dif_min=dt_dif 

		va=dsqrt((bz(i,j)**2+bx(i,j)**2+by(i,j)**2)/(rmu0*rho(i,j))) ! Alfven speed
		cs=    dsqrt(rsh*dabs(p(i,j)/rho(i,j)))  ! sound speed

		dtx=fcourant*dx/(cs+va+dabs(u(i,j))+dabs(w(i,j))+1.d-30)
		dty=fcourant*dy/(cs+va+dabs(v(i,j))+dabs(w(i,j))+1.d-30)

!	dtx=   fcourant*dx/(dabs(u(i,j))+cs+1.d-30)
!	dty=   fcourant*dy/(dabs(v(i,j))+cs+1.d-30)

! apply COURANT condition
		dti=   dmin1(dtx,dty)

! reset dt and remember the location where dt is minimum
      if(dti.le.dt) then
	  idt=i  ;  jdt=j ;  dt=dti
	  endif

!	       if(dt_dif_min.le.dt) then
!	  idt=i  ;  jdt=j ;  dt=dt_dif_min
!	  endif

    end do
	end do
 
! Update time 
  timen=timen+dt



! print warning for dt<10^-7 ps and location of minimum dt

dt_ps  =  dt
  if(dt_ps<=dt_min) then
    time =  timen !*1d12

  	  print '(2x)'
	  print '(1x,"*************** WARNING AT TIME",F7.2,"*****************")',time
      print*," SMALL TIME STEP: dt = ",dt !*1d12
	  print*," Located at  i = ",idt,"   j =",jdt

  endif

  return

end subroutine tstep