!*********************************************************************************
!      Triadiagonal Matrix Solver withour Pivoting. From NUMERICAL RECEPIES
!
!          Solves :  a(i)x(i-1)+b(i)x(i)+c(i)x(i+1)=r(i)
!********************************************************************************

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine tridiag(a,b,c,r,u,n,max_dim)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, only : dkind

	implicit none

	integer :: n, max_dim
	real(kind=dkind), dimension(max_dim) :: a, b, c, r, gam, u
	real(kind=dkind) :: bet
	integer :: j


	if(b(1).eq.0)pause 'tridiag:rewrite equations'
	    bet  = b(1)
	    u(1) = r(1)/bet
	do j=2,n
	    gam(j)  =  c(j-1)/bet
	    bet     =  b(j)-a(j)*gam(j)
	      if(bet.eq.0.)pause 'tridiag failed'
	    u(j)    =  (r(j)-a(j)*u(j-1))/bet
	enddo 

	do  j=n-1,1,-1
	    u(j)=u(j)-gam(j+1)*u(j+1)
	enddo 


	return

end subroutine tridiag