!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine start_conditions
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY: restart_option, numerical_input_option, divergence_init,  &
												source_type, poloidal_momentum, poloidal_momentum_0,  &
												timen
	use vacuum_module, only : set_vacuum, res_implicit_option
	use GS_equilibrium, only : mach_theta_option

	implicit none

	if(restart_option>0)then
!	       starts from restart-file and overwrites the initial conditions
	        numerical_input_option = 0
			call initial
	        call read_restart
	else
!		starts from initial conditions 
	    call initial
    endif

	if((res_implicit_option==4).or.(res_implicit_option==5).or.(res_implicit_option==6).or.  &
		(res_implicit_option==14).or.(res_implicit_option==15).or.(res_implicit_option==16)  &
		.or.(res_implicit_option==25).or.(res_implicit_option==35).or.(res_implicit_option==45)) then
		call set_vacuum
	endif

	if((timen==0.d0).and.(mach_theta_option<0)) call initial_velocity

	if(divergence_init) call div_init_cycle

	if(source_type<0) then
		call poloidal_momentum_integral
		poloidal_momentum_0 = poloidal_momentum
	endif

end subroutine start_conditions


