!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine momentum_source(rho,bx,by,bz,u,v,w,p)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, nx, ny, source_type, run_source, source_option
	use mod_arrays, only : nmx, nmy

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rho,bx,by,bz,u,v,w,p
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: gx, gy, gz, enfl

	if(run_source) then
		continue
	else
		return
	endif

	if(abs(source_type)==1) then
		call momentum_source_1(rho,bx,by,bz,u,v,w)
	elseif(abs(source_type)==2) then
		call conservative_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)
		call momentum_source_2(gx,gy,gz,enfl,bx,by,bz,u,v,w)
		call primitive_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)
	endif

	if(source_option==99) source_option = 0


end subroutine momentum_source

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine momentum_source_1(rho,bx,by,bz,u,v,w)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
! dividing by 4 takes into account the predictor-corrector, alternate direction scheme

	use mod_parameters, only : dkind, nx, ny, rsource_min, rsource_max,  &
                                   rmu0, rhomin, dt, xlength, ylength,  &
                                   source_option, timen, psi_source_min, psi_source_max,  &
                                   psi_axis
	use mod_arrays, only : nmx, nmy, xV, yV, psi_init
	use vacuum_module, only : edge_distance

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rho,bx,by,bz,u,v,w
	real(kind=dkind) :: rloc, thetaloc, VAloc, deltaV, Bloc, Bpolloc, rloc2

	real(kind=dkind), dimension(1:nx,1:ny) :: du, dv, dw, deltaV_ij ! for debugging

	integer, save :: source_option_time = 0
	integer :: source_option_abs
	real(kind=dkind) :: time_factor = 1.d0
	real(kind=dkind) :: alphasource_fun, source_time_fun, alphasource_fun_psi
	real(kind=dkind) , save  :: VA0 = 0.d0
	real(kind=dkind) :: psiloc = 1.d3

	integer, save :: save_source = 0

	integer :: i, j

	source_option_abs = abs(source_option)

	if(source_option_abs>100) then
		source_option_time = source_option_abs/100
		do while(source_option_abs>100)
			source_option_abs = source_option_abs-100
		enddo
		source_option = source_option_abs * sign(1,source_option)
	endif

	time_factor = source_time_fun(timen,source_option_time)
	if(time_factor==0.d0) return

	if((source_option_abs==7).and.(VA0==0.d0)) then
		VA0 = sqrt(bx(nx/2,ny/2)**2+by(nx/2,ny/2)**2+bz(nx/2,ny/2)**2)/  &
					sqrt(rmu0*rho(nx/2,ny/2))
	elseif(((source_option_abs==10).or.(source_option_abs==11).or.  &
				(source_option_abs==12).or.(source_option_abs==13).or.  &
				(source_option_abs==21).or.(source_option_abs==22)).and.(VA0==0.d0)) then
		VA0 = sqrt(bx(nx/2,ny/2)**2+by(nx/2,ny/2)**2+bz(nx/2,ny/2)**2)/  &
					sqrt(rmu0*rho(nx/2,ny/2))*rho(nx/2,ny/2)
	elseif((source_option_abs==14).and.(VA0==0.d0)) then
		VA0 = sqrt(bx(nx/2,ny/2)**2+by(nx/2,ny/2)**2+bz(nx/2,ny/2)**2)/  &
					sqrt(rmu0*rho(nx/2,ny/2))*rho(nx/2,ny/2)/((xlength+ylength)/4.d0)
	endif

	if(save_source==0) then

		du = 0.d0; dv = 0.d0; dw = 0.d0; deltaV_ij = 0.d0

	endif


	do j = 1, ny
	do i = 1, nx

		if((source_option_abs==21).or.(source_option_abs==22).or.(source_option_abs==99)) then

			rloc = edge_distance(i,j)

		else

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			rloc2 = sqrt(((xV(i)/xlength-1.d0/2.d0)*2.d0)**2+((yV(j)/ylength-1.d0/2.d0)*2.d0)**2)

			if((xlength/=ylength).and.(source_option_abs/=14)) rloc = rloc2

			if(source_option_abs>=10) psiloc = psi_init(i,j) / psi_axis

		endif

!!!		if(((source_option<10).and.((rloc>rsource_min).and.(rloc<rsource_max))).or.  &
!!!			((source_option>=10).and.((psiloc>psi_source_min).and.(psiloc<psi_source_max)))) then

!		if((source_option_abs<10).or.(source_option_abs==21)) then
!			if((rloc<rsource_min).or.(rloc>rsource_max)) cycle
!		endif

		if((source_option_abs>=10).and.(source_option_abs<20)) then
			if((psiloc<psi_source_min).or.(psiloc>psi_source_max)) cycle
		endif

		if((source_option_abs==1).or.(source_option_abs==2).or.(source_option_abs==3)) then
			Bloc = sqrt(bx(i,j)**2+by(i,j)**2+bz(i,j)**2)
			VAloc = Bloc/sqrt(rmu0*max(rhomin,rho(i,j)))
		elseif((source_option_abs==4).or.(source_option_abs==5).or.(source_option_abs==6)) then
			Bloc = sqrt(bx(nx/2,ny/2)**2+by(nx/2,ny/2)**2+bz(nx/2,ny/2)**2)
			VAloc = Bloc/sqrt(rmu0*max(rhomin,rho(nx/2,ny/2)))
		elseif((source_option_abs==7).or.(source_option_abs==10).or.(source_option_abs==11)  &
				.or.(source_option_abs==12).or.(source_option_abs==13).or.(source_option_abs==14).or.  &
				(source_option_abs==21).or.(source_option_abs==22).or.(source_option_abs==99)) then
			Bloc = sqrt(bx(i,j)**2+by(i,j)**2)
			VAloc = VA0
			if(Bloc==0.d0) cycle	! to avoid issues with the x-point
		endif

!			thetaloc = datan2((xV(i)-xlength/2.d0),(yV(j)-ylength/2.d0))
		if(source_option_abs==7) then
			deltaV = alphasource_fun(rloc,source_option_abs,i,j) * VAloc * dt
		elseif((source_option_abs==10).or.(source_option_abs==11)) then
			deltaV = alphasource_fun_psi(psiloc,source_option_abs) * VAloc / rho(i,j) * dt
		elseif((source_option_abs==12).or.(source_option_abs==13)) then
			deltaV = alphasource_fun_psi(psiloc,source_option_abs) * VAloc * dt
		elseif(source_option_abs==14) then
			deltaV = alphasource_fun_psi(psiloc,source_option_abs) * VAloc * dt * rloc
		elseif((source_option_abs==21).or.(source_option_abs==22)) then
			deltaV = alphasource_fun(rloc,source_option_abs,i,j) * VAloc * dt
		elseif(source_option_abs==99) then
			deltaV = alphasource_fun(rloc,source_option_abs,i,j)
		else
			deltaV = alphasource_fun(rloc,source_option_abs,i,j) * VAloc * dt/4.d0
		endif

		if((source_option_abs==1).or.(source_option_abs==3).or.(source_option_abs==4).or.  &
			(source_option_abs==5).or.(source_option_abs==6).or.(source_option_abs==7).or.  &
			(source_option_abs==10).or.(source_option_abs==11).or.(source_option_abs==12)  &
			.or.(source_option_abs==13).or.(source_option_abs==14).or.(source_option_abs==21)  &
			.or.(source_option_abs==22).or.(source_option_abs==99)) then
			u(i,j) = u(i,j) + deltaV * bx(i,j)/Bloc
			v(i,j) = v(i,j) + deltaV * by(i,j)/Bloc
		elseif(source_option_abs==2) then
			Bpolloc = sqrt(bx(i,j)**2+by(i,j)**2+1.d-32)
			u(i,j) = u(i,j) + deltaV * bx(i,j)/Bpolloc
			v(i,j) = v(i,j) + deltaV * by(i,j)/Bpolloc
		endif

		if(source_option_abs==5) then
			continue
			w(i,j) = w(i,j) + deltaV * bz(i,j)/Bloc
		endif

		if(save_source==0) then
		! save source shape for debugging

			if((source_option_abs==1).or.(source_option_abs==3).or.(source_option_abs==4).or.  &
				(source_option_abs==5).or.(source_option_abs==6).or.(source_option_abs==7).or.  &
				(source_option_abs==10).or.(source_option_abs==11).or.(source_option_abs==12)  &
				.or.(source_option_abs==13).or.(source_option_abs==14).or.(source_option_abs==21)  &
				.or.(source_option_abs==22).or.(source_option_abs==99)) then
					du(i,j) = deltaV * bx(i,j)/Bloc
					dv(i,j) = deltaV * by(i,j)/Bloc
			elseif(source_option_abs==2) then
				Bpolloc = sqrt(bx(i,j)**2+by(i,j)**2+1.d-32)
				du(i,j) = deltaV * bx(i,j)/Bpolloc
				dv(i,j) = deltaV * by(i,j)/Bpolloc
			endif

			if(source_option_abs==5) then
				continue
				dw(i,j) = deltaV * bz(i,j)/Bloc
			endif

			deltaV_ij(i,j) = deltaV

		endif

!			u(i,j) = u(i,j) - deltaV * sin(thetaloc)
!			v(i,j) = v(i,j) + deltaV * cos(thetaloc)

!!!		endif

		continue

	enddo
	enddo

	if(save_source==0) then
		call source_check
		save_source = 1
	endif

	continue

	return

	!-------------------------------------------------
	contains

	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	subroutine source_check
	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

		open(69,file='source.plt')
		write(69,*)'TITLE="momentum source shape"'
		write(69,*)'Variables = "X", "Y","du","dv","dw","deltaV"'
		write(69,*)'ZONE I=',nx,',J=',ny,',F=Point'

	    do  j=1,ny
		do  i=1,nx

			write(69,219) xV(i),yV(j),du(i,j),dv(i,j),dw(i,j),deltaV_ij(i,j)

		end do
		end do

		close(69)

	219 format(E13.6,4(5x,E13.6))


	end subroutine source_check

end subroutine momentum_source_1

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine momentum_source_2(gx, gy, gz, enfl, bx, by, bz, u, v, w)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
! in this version, the source is used self-consistently in the momentum and energy equations
! NOTE: SOME OPTIONS I DON'T USE STILL HAVE TO BE IMPLEMENTED!

	use mod_parameters, only : dkind, nx, ny, dt, rsh, source_option, xlength, ylength,  &
				   psi_axis, psi_source_min, psi_source_max, rho_boundary, p_boundary,  &
                                   x_axis
	use mod_arrays, only : nmx, nmy, xV, yV, psi_init
	use vacuum_module, only : edge_distance

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: gx, gy, gz, enfl, bx, by, bz, u, v, w
	real(kind=dkind), save :: mom_edge = 0.d0
	real(kind=dkind) :: delta_mom, rloc, Bloc, Bpolloc, rloc2

	real(kind=dkind), dimension(1:nx,1:ny) :: dgx, dgy, dgz, delta_mom_ij ! for debugging

	integer, save :: source_option_time = 0
	integer :: source_option_abs
!	real(kind=dkind) :: time_factor = 1.d0
	real(kind=dkind) :: alphasource_fun, source_time_fun, alphasource_fun_psi, alphasource_fun_variable
	real(kind=dkind) :: psiloc = 1.d3

	integer, save :: save_source = 0

	integer :: i, j

	if(mom_edge==0.d0) mom_edge = rho_boundary * sqrt(rsh*p_boundary/rho_boundary)
	! this is used to normalize the source: alpha is dimensionless

	source_option_abs = abs(source_option)

	if(source_option_abs>100) then
		source_option_time = source_option_abs/100
		do while(source_option_abs>100)
			source_option_abs = source_option_abs-100
		enddo
		source_option = source_option_abs * sign(1,source_option)
	endif

	if(save_source==0.d0) then
		dgx=0.d0; dgy=0.d0; dgz=0.d0; delta_mom_ij =0.d0
	endif


	do j = 1, ny
	do i = 1, nx

		if((source_option_abs==21).or.(source_option_abs==22).or.(source_option_abs==23).or.(source_option==31)  &
       .or.(source_option_abs==32).or.(source_option_abs==33).or.(source_option_abs==43)) then

			rloc = edge_distance(i,j)

		else

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			rloc2 = sqrt(((xV(i)/xlength-1.d0/2.d0)*2.d0)**2+((yV(j)/ylength-1.d0/2.d0)*2.d0)**2)

			if((xlength/=ylength).and.(source_option_abs/=14)) rloc = rloc2

			if(source_option_abs>=10) psiloc = psi_init(i,j) / psi_axis

		endif

		if((source_option_abs>=10).and.(source_option_abs<20)) then
			if((psiloc<psi_source_min).or.(psiloc>psi_source_max)) cycle
		endif

		if((source_option_abs==23).or.(source_option_abs==43)) then
			if(xV(i)<x_axis) cycle
		endif

		if((source_option_abs==1).or.(source_option_abs==2).or.(source_option_abs==3)) then
			Bloc = sqrt(bx(i,j)**2+by(i,j)**2+bz(i,j)**2)
		elseif((source_option_abs==4).or.(source_option_abs==5).or.(source_option_abs==6)) then
			Bloc = sqrt(bx(nx/2,ny/2)**2+by(nx/2,ny/2)**2+bz(nx/2,ny/2)**2)
		elseif((source_option_abs==7).or.(source_option_abs==10).or.(source_option_abs==11)  &
				.or.(source_option_abs==12).or.(source_option_abs==13).or.(source_option_abs==14).or.  &
				(source_option_abs==21).or.(source_option_abs==22).or.(source_option_abs==23)  &
				.or.(source_option_abs==31).or.(source_option_abs==32).or.(source_option_abs==33)  &
                                .or.(source_option_abs==43)) then
			Bloc = sqrt(bx(i,j)**2+by(i,j)**2)
			if(Bloc==0.d0) cycle	! to avoid issues with the x-point
		endif

		if(source_option_abs==7) then
			delta_mom = alphasource_fun(rloc,source_option_abs,i,j) * dt
		elseif((source_option_abs==10).or.(source_option_abs==11)) then
			delta_mom = alphasource_fun_psi(psiloc,source_option_abs) * dt
		elseif((source_option_abs==12).or.(source_option_abs==13)) then
			delta_mom = alphasource_fun_psi(psiloc,source_option_abs) * dt
		elseif(source_option_abs==14) then
			delta_mom = alphasource_fun_psi(psiloc,source_option_abs) * dt * rloc
		elseif((source_option_abs==21).or.(source_option_abs==22).or.(source_option_abs==23)) then
			delta_mom = alphasource_fun(rloc,source_option_abs,i,j) * dt
		elseif((source_option_abs==31).or.(source_option_abs==32).or.(source_option_abs==33).or.(source_option_abs==43)) then
			delta_mom = alphasource_fun_variable(i,j,rloc,source_option_abs) * dt
		else
			delta_mom = alphasource_fun(rloc,source_option_abs,i,j) * dt/4.d0
		endif

		if((source_option_abs==1).or.(source_option_abs==3).or.(source_option_abs==4).or.  &
			(source_option_abs==5).or.(source_option_abs==6).or.(source_option_abs==7).or.  &
			(source_option_abs==10).or.(source_option_abs==11).or.(source_option_abs==12)  &
			.or.(source_option_abs==13).or.(source_option_abs==14).or.(source_option_abs==21)  &
			.or.(source_option_abs==22).or.(source_option_abs==23).or.(source_option_abs==31)  &
                        .or.(source_option_abs==32).or.(source_option_abs==33).or.(source_option_abs==43)) then

			gx(i,j) = gx(i,j) + delta_mom * bx(i,j)/Bloc
			gy(i,j) = gy(i,j) + delta_mom * by(i,j)/Bloc
			enfl(i,j) = enfl(i,j) + delta_mom * (bx(i,j)*u(i,j)+by(i,j)*v(i,j))/Bloc

		elseif(source_option_abs==2) then

			Bpolloc = sqrt(bx(i,j)**2+by(i,j)**2+1.d-32)
			gx(i,j) = gx(i,j) + delta_mom * bx(i,j)/Bpolloc
			gy(i,j) = gy(i,j) + delta_mom * by(i,j)/Bpolloc
			enfl(i,j) = enfl(i,j) + delta_mom * (bx(i,j)*u(i,j)+by(i,j)*v(i,j))/Bpolloc

		endif

		if(source_option_abs==5) then
			continue
			gz(i,j) = gz(i,j) + delta_mom * bz(i,j)/Bloc
			enfl(i,j) = enfl(i,j) + delta_mom * bz(i,j)*w(i,j)/Bloc
		endif

		if(save_source==0) then
		! save source shape for debugging

			if((source_option_abs==1).or.(source_option_abs==3).or.(source_option_abs==4).or.  &
				(source_option_abs==5).or.(source_option_abs==6).or.(source_option_abs==7).or.  &
				(source_option_abs==10).or.(source_option_abs==11).or.(source_option_abs==12)  &
				.or.(source_option_abs==13).or.(source_option_abs==14).or.(source_option_abs==21)  &
				.or.(source_option_abs==22).or.(source_option_abs==23).or.(source_option_abs==31)  &
                                .or.(source_option_abs==32).or.(source_option_abs==33).or.(source_option_abs==43)) then
					dgx(i,j) = delta_mom * bx(i,j)/Bloc
					dgy(i,j) = delta_mom * by(i,j)/Bloc
			elseif(source_option_abs==2) then
				Bpolloc = sqrt(bx(i,j)**2+by(i,j)**2+1.d-32)
				dgx(i,j) = delta_mom * bx(i,j)/Bpolloc
				dgy(i,j) = delta_mom * by(i,j)/Bpolloc
			endif

			if(source_option_abs==5) then
				continue
				dgz(i,j) = delta_mom * bz(i,j)/Bloc
			endif

			delta_mom_ij(i,j) = delta_mom

		endif

		continue

	enddo
	enddo

	if(save_source==0) then
		call momentum_source_check
		save_source = 1
	endif

	!-------------------------------------------------
	contains

	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	subroutine momentum_source_check
	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

		open(69,file='momentum_source.plt')
		write(69,*)'TITLE="momentum source shape"'
		write(69,*)'Variables = "X", "Y","dgx","dgy","dgz","deltaV"'
		write(69,*)'ZONE I=',nx,',J=',ny,',F=Point'

	    do  j=1,ny
		do  i=1,nx

			write(69,219) xV(i),yV(j),dgx(i,j),dgy(i,j),dgz(i,j),delta_mom_ij(i,j)

		end do
		end do

		close(69)

	219 format(E13.6,4(5x,E13.6))


	end subroutine momentum_source_check

end subroutine momentum_source_2

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
function source_time_fun(t,option) result(answer)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind,time_end_source

	implicit none

	real(kind=dkind) :: answer
	real(kind=dkind) :: t
	integer, intent(in) :: option

	if(option==0) then

		if(t<time_end_source) then
			answer = 1.d0
		else
			answer = 0.d0
		endif

	elseif(option==1) then

		if(t<time_end_source) then
			answer = 1.d0 - t/time_end_source
		else
			answer = 0.d0
		endif

	endif

end function source_time_fun


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
function alphasource_fun(r,source_option,i,j) result(answer)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, rsource_min, rsource_max, alpha_source_max, rsh
        use mod_arrays, only : rho, p, bx, by, bz

	implicit none

	real(kind=dkind) :: answer
	real(kind=dkind) :: r
	real(kind=dkind) :: rhat
	integer :: source_option
	integer :: i,j

	if((source_option==1).or.(source_option==2)) then

		answer = 4.d0*alpha_source_max*(r-rsource_min)*(rsource_max-r) /  &
								(rsource_max+rsource_min)

	elseif((source_option==3).or.(source_option==4).or.(source_option==5).or.(source_option==7)) then

		answer = alpha_source_max * (r-rsource_min)/(rsource_max-rsource_min)

	elseif(source_option==6) then

		rhat = (r-rsource_min)/(rsource_max-rsource_min)

		if(rhat<0.5d0) then
			answer = alpha_source_max * 2.d0*rhat
		else
			answer = alpha_source_max
		endif

	elseif(source_option==21) then
	! rsource_min is negative!

		if((r<rsource_max).and.(r>rsource_min)) then
			answer = alpha_source_max * (r-rsource_min)/(rsource_max-rsource_min)
		else
			answer = 0.d0
		endif

	elseif(source_option==22) then
	! rsource_min is negative!

		if((r<rsource_max).and.(r>rsource_min)) then
			if(r>0.d0) then
				answer = alpha_source_max
			elseif(r<0.d0) then
				answer = alpha_source_max * (r-rsource_min)/abs(rsource_min)
			endif
		else
			answer = 0.d0
		endif

	elseif(source_option==23) then
	! rsource_min is negative! (same as previous one, but only for R>R0)

		if((r<rsource_max).and.(r>rsource_min)) then
			if(r>0.d0) then
				answer = alpha_source_max
			elseif(r<0.d0) then
				answer = alpha_source_max * (r-rsource_min)/abs(rsource_min)
			endif
		else
			answer = 0.d0
		endif

	elseif(source_option==99) then
	! initial velocity as function of distance and c_sp (rsource_min<0)

		if((r>rsource_max).or.(r<2.d0*rsource_min)) then
			answer = 0.d0
		elseif((r<rsource_min).and.(r>2.d0*rsource_min)) then
			answer = 2.d0*alpha_source_max * (2.d0*rsource_min-r)/rsource_min
		elseif((r>rsource_min).and.(r<rsource_max)) then
			answer = 2.d0*alpha_source_max * (rsource_max-r)/(rsource_max-rsource_min)
		endif

		if(answer/=0.d0) then
			answer  = answer * sqrt(rsh*p(i,j)/rho(i,j)*(bx(i,j)**2+by(i,j)**2)/(bx(i,j)**2+by(i,j)**2+bz(i,j)**2))
		endif

	endif

end function alphasource_fun

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
function alphasource_fun_psi(psi,source_option) result(answer)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only :dkind,  psi_source_min, psi_source_max, alpha_source_max

	implicit none

	real(kind=dkind) :: answer
	real(kind=dkind) :: psi
	real(kind=dkind) :: psihat
	integer :: source_option

	psihat = 1.d0 - (psi-psi_source_min)/(psi_source_max-psi_source_min)

	if(source_option==10) then

		answer = alpha_source_max * psihat

	elseif(source_option==11) then

		answer = alpha_source_max * sqrt(psihat)

	elseif(source_option==12) then

		answer = alpha_source_max * sqrt(psihat)

	elseif(source_option==13) then

		answer = alpha_source_max * psihat**2

	elseif(source_option==14) then

		answer = alpha_source_max * sqrt(psihat)

	endif

end function alphasource_fun_psi


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
function alphasource_fun_variable(i,j,r,source_option) result(answer)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, rsource_min, rsource_max, alpha_source_max,  &
												psi_source_max, psi_source_min, p_boundary, rho_boundary
	use mod_arrays, only : p, rho
	use vacuum_module, only : res_eta, res_eta_max, res_phys_exp

	implicit none

	real(kind=dkind) :: answer
	real(kind=dkind) :: r
	real(kind=dkind) :: rhat
	integer :: source_option
	integer :: i, j
	real(kind=dkind), save :: var_S_min=0
	real(kind=dkind), save :: var_S_max=0
	real(kind=dkind) :: varloc


	if(source_option==31) then
        ! source is function of resistivity, limited by distance from original edge

		if(var_S_max==0.d0) then
			var_S_min = res_eta_max*psi_source_min
			var_S_max = res_eta_max*psi_source_max
		endif

		varloc = res_eta(i,j,0)

		if((r>rsource_max).or.(r<rsource_min)) then
			answer = 0.d0
		elseif((varloc<var_S_min).or.(varloc>var_S_max)) then
			answer = 0.d0
		else
			answer = alpha_source_max*((varloc-var_S_min)/(var_S_max-var_S_min))**res_phys_exp
		endif

	elseif(source_option==32) then
        ! source is function of pressure, limited by distance from original edge

		if(var_S_max==0.d0) then
			var_S_min = p_boundary*psi_source_min
			var_S_max = p_boundary*psi_source_max
		endif

		varloc = p(i,j)

		if((r>rsource_max).or.(r<rsource_min)) then
			answer = 0.d0
		elseif((varloc<var_S_min).or.(varloc>var_S_max)) then
			answer = 0.d0
		else
			answer = alpha_source_max*((var_S_max-varloc)/(var_S_max-var_S_min))
		endif


	elseif(source_option==33) then
        ! source is function of temperature, limited by distance from original edge

		if(var_S_max==0.d0) then
			var_S_min = p_boundary/rho_boundary*psi_source_min
			var_S_max = p_boundary/rho_boundary*psi_source_max
		endif

		varloc = p(i,j)/rho(i,j)

		if((r>rsource_max).or.(r<rsource_min)) then
			answer = 0.d0
		elseif((varloc<var_S_min).or.(varloc>var_S_max)) then
			answer = 0.d0
		else
			answer = alpha_source_max*((var_S_max-varloc)/(var_S_max-var_S_min))
		endif


	elseif(source_option==43) then
        ! source is function of temperature, limited by distance from original edge (same as previous one, but only for R>R0)

		if(var_S_max==0.d0) then
			var_S_min = p_boundary/rho_boundary*psi_source_min
			var_S_max = p_boundary/rho_boundary*psi_source_max
		endif

		varloc = p(i,j)/rho(i,j)

		if((r>rsource_max).or.(r<rsource_min)) then
			answer = 0.d0
		elseif((varloc<var_S_min).or.(varloc>var_S_max)) then
			answer = 0.d0
		else
			answer = alpha_source_max*((var_S_max-varloc)/(var_S_max-var_S_min))
		endif

	endif

end function alphasource_fun_variable

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine mass_recycling
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : mass_recycling_factor

	if(mass_recycling_factor>0.d0) then
		call mass_recycling_0
	elseif(mass_recycling_factor<0.d0) then
		call mass_recycling_1
	endif

end subroutine mass_recycling

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine mass_recycling_0
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : nx, ny, dt, rsh, xlength, ylength, external_surface,  &
												mass_source, mass_recycling_factor, rho_boundary, p_boundary
	use mod_arrays, only : rho
	use boundary_routines, only : sort_grid, Mach_boundary

	implicit none

	integer :: i, j

	if(mass_source==0.d0) then
		mass_source = sqrt(rsh*p_boundary/rho_boundary)*Mach_boundary*  &
								2.d0*(xlength+ylength) * mass_recycling_factor
	endif

	do j = 1, ny
	do i = 1, nx

		if(sort_grid(i,j) == 1) then
			rho(i,j) = rho(i,j) + dt * mass_source
		endif

	enddo
	enddo

	continue

	return

end subroutine mass_recycling_0

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine mass_recycling_1
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, nx, ny, dt, rsh, xlength, ylength, external_surface,  &
												mass_source, mass_recycling_factor, timen, dt_smooth,  &
												t_smooth, rho_boundary, p_boundary
	use mod_arrays, only : rho
	use boundary_routines, only : sort_grid, Mach_boundary

	implicit none

	real(kind=dkind), save :: boundary_mass_0 = 0.d0
	real(kind=dkind) :: boundary_mass
	integer :: i, j

	if(mass_source==0.d0) then
		mass_source = sqrt(rsh*p_boundary/rho_boundary)*Mach_boundary*  &
								2.d0*(xlength+ylength) * abs(mass_recycling_factor)
	endif

	! update the source only at smoothing times
	if (((timen >= dt_smooth).and.(timen >= t_smooth)).or.(boundary_mass_0==0.d0)) then

		call boundary_mass_integral(boundary_mass)

		if(boundary_mass_0==0.d0) boundary_mass_0 = boundary_mass

		! update the mass source (remember that mass_recycling_factor is <0)
		if(boundary_mass>boundary_mass_0) then
			mass_source = mass_source * (1.d0-abs(mass_recycling_factor))
		elseif(boundary_mass<boundary_mass_0) then
			mass_source = mass_source * (1.d0+abs(mass_recycling_factor))
		endif

	endif


	do j = 1, ny
	do i = 1, nx

		if(sort_grid(i,j) == 1) then
			rho(i,j) = rho(i,j) + dt * mass_source
		endif

	enddo
	enddo

	continue

	return

end subroutine mass_recycling_1
