!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine smoothing_cycle
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : nx, ny, art_diff_option, dt, dx, dy, smoothing_option,  &
												smoothing_ite, istart, iend, jstart, jend, istart_smooth,  &
												iend_smooth, jstart_smooth, jend_smooth, timen,  &
												smoothing_index_B, smoothing_index_L, smoothing_index_T, smoothing_index_R,  &
												resistivity_smoothing
	use mod_arrays, only : nmx, nmy, rho,p,u,v,w,bx,by,bz,eta_phys
	use vacuum_module, only : res_implicit_option, resistive_diffusion

	implicit none

	integer, parameter :: dkind=kind(1.d0)
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: ptemp, rhotemp, utemp, vtemp
	real(kind=dkind) :: divB_err
	integer :: divB_ite, do_divB
	integer :: art_diff_option_true
	real(kind=dkind) :: fix_time
	integer :: smoothing_option_fix, delta_index, n_sides
	integer :: i, j

	do_divB = smoothing_ite/10
	art_diff_option_true = art_diff_option

	if(smoothing_option==2) then

		istart = istart_smooth
		iend = iend_smooth
		jstart = jstart_smooth
		jend = jend_smooth

	endif

	fix_time = timen

	smoothing_option_fix = smoothing_option

	if(smoothing_option==3) then

		delta_index = iend_smooth - istart_smooth
		smoothing_option = 2
		n_sides = 4

	elseif(smoothing_option==4) then

		smoothing_option = 2
		n_sides = 4

	elseif(smoothing_option==5) then

		smoothing_option = 2
		n_sides = 4

	else

		n_sides = 1

	endif


	if((art_diff_option==0).or.(art_diff_option==2).or.(art_diff_option==4)) then

		if((smoothing_option==0).or.(smoothing_option==2)) then

			art_diff_option = 0

		elseif(smoothing_option==1) then

			art_diff_option = 4

		endif

	elseif((art_diff_option==1).or.(art_diff_option==3).or.(art_diff_option==5)) then

		if((smoothing_option==0).or.(smoothing_option==2)) then

			art_diff_option = 1

		elseif(smoothing_option==1) then

			art_diff_option = 5

		endif


	endif

	!--------------------------------smoothing cycle--------------------------------

	! fix time step AND p, rho, u, v during the cycle
	call tstep

	ptemp(0:nx+1,0:ny+1) = p(0:nx+1,0:ny+1)
	rhotemp(0:nx+1,0:ny+1) = rho(0:nx+1,0:ny+1)

	if (smoothing_option_fix==5) then

		utemp(0:nx+1,0:ny+1) = u(0:nx+1,0:ny+1)
		vtemp(0:nx+1,0:ny+1) = v(0:nx+1,0:ny+1)

	endif

	do i = 1, smoothing_ite

		do j = 1, n_sides

			if(smoothing_option_fix==3) then

				if(j==1) then	! BOTTOM
					istart = 1; iend = nx
					jstart = 1; jend = 1 + delta_index
				elseif(j==2) then	! RIGHT
					istart = nx - delta_index; iend = nx
					jstart = 1; jend = ny
				elseif(j==3) then	! TOP
					istart = 1; iend = nx
					jstart = ny - delta_index; jend = ny
				elseif(j==4) then	! LEFT
					istart = 1; iend = 1 + delta_index
					jstart = 1; jend = ny
				endif

			elseif((smoothing_option_fix==4).or.(smoothing_option_fix==5)) then

				if(j==1) then	! BOTTOM
					istart = 1; iend = nx
					jstart = 1; jend = 1 + smoothing_index_B
				elseif(j==2) then	! RIGHT
					istart = nx - smoothing_index_R; iend = nx
					jstart = 1; jend = ny
				elseif(j==3) then	! TOP
					istart = 1; iend = nx
					jstart = ny - smoothing_index_T; jend = ny
				elseif(j==4) then	! LEFT
					istart = 1; iend = 1 + smoothing_index_L
					jstart = 1; jend = ny
				endif

			endif


			if((art_diff_option==0).or.(art_diff_option==4)) then

				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,0)

				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,0)

				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,0)

				if(res_implicit_option==45) then

					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,eta_phys,ptemp,rhotemp,u,v,0)

				 endif

				if(smoothing_option_fix==5) then

					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,u,ptemp,rhotemp,utemp,vtemp,0)

					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,v,ptemp,rhotemp,utemp,vtemp,0)

				endif

			elseif((art_diff_option==1).or.(art_diff_option==5)) then

				!$omp parallel default(shared)
				!$omp sections

				!$omp section
				call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,bx,by,bz,0)

				!$omp section
				 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,bx,by,bz,0)

				!$omp section
				 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,bx,by,bz,0)

				!$omp section
				if(res_implicit_option==45) then

					 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,eta_phys,ptemp,rhotemp,u,v,bx,by,bz,0)

				 endif

				!$omp section
				if(smoothing_option_fix==5) then

					 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,u,ptemp,rhotemp,u,v,bx,by,bz,0)

					 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,v,ptemp,rhotemp,u,v,bx,by,bz,0)

				endif

				!$omp end sections
				!$omp end parallel

			endif

			call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

		enddo

		if(resistivity_smoothing==1) then

			call resistive_diffusion(i)

		endif

		if(do_divB>0) then
			if(modulo(i,do_divB)==0) then
			! also improve the divergence, which does not require as many iterations

				divB_err = 1.d1; divB_ite = 0
				do while((divB_err>1.d-6).and.(divB_ite<10))
					call divergence_B(bx,by,1,divB_err,fix_time)
					call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)
					divB_ite = divB_ite+1
				enddo

			endif
		endif

	enddo

	art_diff_option = art_diff_option_true
	istart = 1; iend=nx
	jstart = 1; jend = ny
	smoothing_option = smoothing_option_fix

	timen = fix_time

	continue

	return

end subroutine smoothing_cycle

!!$!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!!$subroutine smoothing_cycle_failed
!!$!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!!$
!!$	use mod_parameters, only : nx, ny, art_diff_option, dt, dx, dy, smoothing_option,  &
!!$												smoothing_ite, istart, iend, jstart, jend, istart_smooth,  &
!!$												iend_smooth, jstart_smooth, jend_smooth, timen,  &
!!$												smoothing_index_B, smoothing_index_L, smoothing_index_T, smoothing_index_R
!!$	use mod_arrays, only : nmx, nmy, rho,p,u,v,w,bx,by,bz
!!$
!!$	implicit none
!!$
!!$	integer, parameter :: dkind=kind(1.d0)
!!$	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: ptemp, rhotemp, utemp, vtemp
!!$	real(kind=dkind), dimension(0:nmx+1,0:nmy+1,1:5) :: phi
!!$	real(kind=dkind) :: divB_err
!!$	integer :: divB_ite, do_divB
!!$	integer :: art_diff_option_true
!!$	real(kind=dkind) :: fix_time
!!$	integer :: smoothing_option_fix, delta_index, n_sides
!!$	integer :: i, j
!!$
!!$	do_divB = smoothing_ite/10
!!$	art_diff_option_true = art_diff_option
!!$
!!$	if(smoothing_option==2) then
!!$
!!$		istart = istart_smooth
!!$		iend = iend_smooth
!!$		jstart = jstart_smooth
!!$		jend = jend_smooth
!!$
!!$	endif
!!$
!!$	fix_time = timen
!!$
!!$	smoothing_option_fix = smoothing_option
!!$
!!$	if(smoothing_option==3) then
!!$
!!$		delta_index = iend_smooth - istart_smooth
!!$		smoothing_option = 2
!!$		n_sides = 4
!!$
!!$	elseif(smoothing_option==4) then
!!$
!!$		smoothing_option = 2
!!$		n_sides = 4
!!$
!!$	elseif(smoothing_option==5) then
!!$
!!$		smoothing_option = 2
!!$		n_sides = 4
!!$
!!$	else
!!$
!!$		n_sides = 1
!!$
!!$	endif
!!$
!!$
!!$	if((art_diff_option==0).or.(art_diff_option==2).or.(art_diff_option==4)) then
!!$
!!$		if((smoothing_option==0).or.(smoothing_option==2)) then
!!$
!!$			art_diff_option = 0
!!$
!!$		elseif(smoothing_option==1) then
!!$
!!$			art_diff_option = 4
!!$
!!$		endif
!!$
!!$	elseif((art_diff_option==1).or.(art_diff_option==3).or.(art_diff_option==5)) then
!!$
!!$		if((smoothing_option==0).or.(smoothing_option==2)) then
!!$
!!$			art_diff_option = 1
!!$
!!$		elseif(smoothing_option==1) then
!!$
!!$			art_diff_option = 5
!!$
!!$		endif
!!$
!!$
!!$	endif
!!$
!!$	!--------------------------------smoothing cycle--------------------------------
!!$
!!$	! fix time step during the cycle
!!$	call tstep
!!$
!!$
!!$	do i = 1, smoothing_ite
!!$
!!$		do j = 1, n_sides
!!$
!!$			if(smoothing_option_fix==3) then
!!$
!!$				if(j==1) then	! BOTTOM
!!$					istart = 1; iend = nx
!!$					jstart = 1; jend = 1 + delta_index
!!$				elseif(j==2) then	! RIGHT
!!$					istart = nx - delta_index; iend = nx
!!$					jstart = 1; jend = ny
!!$				elseif(j==3) then	! TOP
!!$					istart = 1; iend = nx
!!$					jstart = ny - delta_index; jend = ny
!!$				elseif(j==4) then	! LEFT
!!$					istart = 1; iend = 1 + delta_index
!!$					jstart = 1; jend = ny
!!$				endif
!!$
!!$			elseif((smoothing_option_fix==4).or.(smoothing_option_fix==5)) then
!!$
!!$				if(j==1) then	! BOTTOM
!!$					istart = 1; iend = nx
!!$					jstart = 1; jend = 1 + smoothing_index_B
!!$				elseif(j==2) then	! RIGHT
!!$					istart = nx - smoothing_index_R; iend = nx
!!$					jstart = 1; jend = ny
!!$				elseif(j==3) then	! TOP
!!$					istart = 1; iend = nx
!!$					jstart = ny - smoothing_index_T; jend = ny
!!$				elseif(j==4) then	! LEFT
!!$					istart = 1; iend = 1 + smoothing_index_L
!!$					jstart = 1; jend = ny
!!$				endif
!!$
!!$			endif
!!$
!!$			ptemp(0:nx+1,0:ny+1) = p(0:nx+1,0:ny+1)
!!$			rhotemp(0:nx+1,0:ny+1) = rho(0:nx+1,0:ny+1)
!!$
!!$			if (smoothing_option_fix==5) then
!!$
!!$				utemp(0:nx+1,0:ny+1) = u(0:nx+1,0:ny+1)
!!$				vtemp(0:nx+1,0:ny+1) = v(0:nx+1,0:ny+1)
!!$
!!$			endif
!!$
!!$			if((art_diff_option==0).or.(art_diff_option==4)) then
!!$
!!$				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,0) !,1)
!!$
!!$				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,0) !,1)
!!$
!!$				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,0) !,1)
!!$
!!$				if(smoothing_option_fix==5) then
!!$
!!$					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,u,ptemp,rhotemp,utemp,vtemp,0) !,1)
!!$
!!$					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,v,ptemp,rhotemp,utemp,vtemp,0) !,1)
!!$
!!$				endif
!!$
!!$			elseif((art_diff_option==1).or.(art_diff_option==5)) then
!!$
!!$				if(smoothing_option_fix==5) then
!!$
!!$					phi(:,:,1) = rho(:,:)
!!$					phi(:,:,2) = p(:,:)
!!$					phi(:,:,3) = w(:,:)
!!$					phi(:,:,4) = u(:,:)
!!$					phi(:,:,5) = v(:,:)
!!$
!!$					call art_dif_alfven_array(dt,dx,dy,nx,ny,phi(:,:,1:5),ptemp,rhotemp,utemp,vtemp,bx,by,bz,0,5)
!!$
!!$				else
!!$
!!$					phi(:,:,1) = rho(:,:)
!!$					phi(:,:,2) = p(:,:)
!!$					phi(:,:,3) = w(:,:)
!!$
!!$					call art_dif_alfven_array(dt,dx,dy,nx,ny,phi(:,:,1:3),ptemp,rhotemp,utemp,vtemp,bx,by,bz,0,3)
!!$
!!$				endif
!!$
!!$
!!$			endif
!!$
!!$			call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p)
!!$
!!$		enddo
!!$
!!$		if(do_divB>0) then
!!$			if(modulo(i,do_divB)==0) then
!!$			! also improve the divergence, which does not require as many iterations
!!$
!!$				divB_err = 1.d1; divB_ite = 0
!!$				do while((divB_err>1.d-6).and.(divB_ite<10))
!!$					call divergence_B(bx,by,1,divB_err,fix_time)
!!$					call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p)
!!$					divB_ite = divB_ite+1
!!$				enddo
!!$
!!$			endif
!!$		endif
!!$
!!$	enddo
!!$
!!$	art_diff_option = art_diff_option_true
!!$	istart = 1; iend=nx
!!$	jstart = 1; jend = ny
!!$	smoothing_option = smoothing_option_fix
!!$
!!$	timen = fix_time
!!$
!!$	continue
!!$
!!$	return
!!$
!!$end subroutine smoothing_cycle_failed

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine smoothing_cycle_old
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : nx, ny, art_diff_option, dt, dx, dy, smoothing_option,  &
												smoothing_ite, istart, iend, jstart, jend, istart_smooth,  &
												iend_smooth, jstart_smooth, jend_smooth, timen,  &
												smoothing_index_B, smoothing_index_L, smoothing_index_T, smoothing_index_R
	use mod_arrays, only : nmx, nmy, rho,p,u,v,w,bx,by,bz,eta_phys

	implicit none

	integer, parameter :: dkind=kind(1.d0)
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: ptemp, rhotemp, utemp, vtemp
	real(kind=dkind) :: divB_err
	integer :: divB_ite, do_divB
	integer :: art_diff_option_true
	real(kind=dkind) :: fix_time
	integer :: smoothing_option_fix, delta_index, n_sides
	integer :: i, j

	do_divB = smoothing_ite/10
	art_diff_option_true = art_diff_option

	if(smoothing_option==2) then

		istart = istart_smooth
		iend = iend_smooth
		jstart = jstart_smooth
		jend = jend_smooth

	endif

	fix_time = timen

	smoothing_option_fix = smoothing_option

	if(smoothing_option==3) then

		delta_index = iend_smooth - istart_smooth
		smoothing_option = 2
		n_sides = 4

	elseif(smoothing_option==4) then

		smoothing_option = 2
		n_sides = 4

	elseif(smoothing_option==5) then

		smoothing_option = 2
		n_sides = 4

	else

		n_sides = 1

	endif


	if((art_diff_option==0).or.(art_diff_option==2).or.(art_diff_option==4)) then

		if((smoothing_option==0).or.(smoothing_option==2)) then

			art_diff_option = 0

		elseif(smoothing_option==1) then

			art_diff_option = 4

		endif

	elseif((art_diff_option==1).or.(art_diff_option==3).or.(art_diff_option==5)) then

		if((smoothing_option==0).or.(smoothing_option==2)) then

			art_diff_option = 1

		elseif(smoothing_option==1) then

			art_diff_option = 5

		endif


	endif

	!--------------------------------smoothing cycle--------------------------------

	! fix time step during the cycle
	call tstep


	do i = 1, smoothing_ite

		do j = 1, n_sides

			if(smoothing_option_fix==3) then

				if(j==1) then	! BOTTOM
					istart = 1; iend = nx
					jstart = 1; jend = 1 + delta_index
				elseif(j==2) then	! RIGHT
					istart = nx - delta_index; iend = nx
					jstart = 1; jend = ny
				elseif(j==3) then	! TOP
					istart = 1; iend = nx
					jstart = ny - delta_index; jend = ny
				elseif(j==4) then	! LEFT
					istart = 1; iend = 1 + delta_index
					jstart = 1; jend = ny
				endif

			elseif((smoothing_option_fix==4).or.(smoothing_option_fix==5)) then

				if(j==1) then	! BOTTOM
					istart = 1; iend = nx
					jstart = 1; jend = 1 + smoothing_index_B
				elseif(j==2) then	! RIGHT
					istart = nx - smoothing_index_R; iend = nx
					jstart = 1; jend = ny
				elseif(j==3) then	! TOP
					istart = 1; iend = nx
					jstart = ny - smoothing_index_T; jend = ny
				elseif(j==4) then	! LEFT
					istart = 1; iend = 1 + smoothing_index_L
					jstart = 1; jend = ny
				endif

			endif

			ptemp(0:nx+1,0:ny+1) = p(0:nx+1,0:ny+1)
			rhotemp(0:nx+1,0:ny+1) = rho(0:nx+1,0:ny+1)

			if (smoothing_option_fix==5) then

				utemp(0:nx+1,0:ny+1) = u(0:nx+1,0:ny+1)
				vtemp(0:nx+1,0:ny+1) = v(0:nx+1,0:ny+1)

			endif

			if((art_diff_option==0).or.(art_diff_option==4)) then

				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,0) !,1)

				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,0) !,1)

				 call art_dif_peaks_nn(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,0) !,1)

				if(smoothing_option_fix==5) then

					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,u,ptemp,rhotemp,utemp,vtemp,0) !,1)

					 call art_dif_peaks_nn(dt,dx,dy,nx,ny,v,ptemp,rhotemp,utemp,vtemp,0) !,1)

				endif

			elseif((art_diff_option==1).or.(art_diff_option==5)) then

				!$omp parallel default(shared)
				!$omp sections

				!$omp section
				call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,bx,by,bz,0)

				!$omp section
				 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,bx,by,bz,0)

				!$omp section
				 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,bx,by,bz,0)

				!$omp section
				if(smoothing_option_fix==5) then

					 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,u,ptemp,rhotemp,u,v,bx,by,bz,0)

					 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,v,ptemp,rhotemp,u,v,bx,by,bz,0)

				endif

				!$omp end sections
				!$omp end parallel

			endif

			call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

		enddo

		if(do_divB>0) then
			if(modulo(i,do_divB)==0) then
			! also improve the divergence, which does not require as many iterations

				divB_err = 1.d1; divB_ite = 0
				do while((divB_err>1.d-6).and.(divB_ite<10))
					call divergence_B(bx,by,1,divB_err,fix_time)
					call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)
					divB_ite = divB_ite+1
				enddo

			endif
		endif

	enddo

	art_diff_option = art_diff_option_true
	istart = 1; iend=nx
	jstart = 1; jend = ny
	smoothing_option = smoothing_option_fix

	timen = fix_time

	continue

	return

end subroutine smoothing_cycle_old
