!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine read_restart
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, only : nx, ny, time_0, boundary_option, psi_axis, dt_scale, rho_boundary, p_boundary,  &
													restart_option
	use mod_arrays, ONLY : nmx, nmy, rho,bx,by,bz,u,v,w,p,psi_init,eta_phys
	use GS_equilibrium, only : dofpsi, pofpsi
	use numerical_input, only : read_numerical, numerical_n, numerical_p,  &
											  numerical_Bz, numerical_mtheta
	use vacuum_module, only : res_implicit_option, res_factor, res_xmin, res_xmax

	implicit none

	character*6 :: title_time
	integer :: jtime
	integer i,j

	jtime = time_0/dt_scale
!    write(title_time(01:06),'(i6)')jtime
	call get_title(title_time,jtime)

	if(restart_option==1) then
		call read_restart_1
	elseif(restart_option==2) then
		call read_restart_2
	endif

	call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)


	!------------------------------------------------------------------
	contains

	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
	subroutine read_restart_1
	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

		open (unit=17, file=title_time//'_bin.out', form='unformatted', status='old', action='read')

		do j=0,ny+1
		do i=0,nx+1

			read(17) rho(i,j),bx(i,j),by(i,j),bz(i,j),u(i,j),v(i,j),w(i,j),p(i,j),psi_init(i,j)

		enddo
		enddo

		close(17)

		psi_axis = maxval(psi_init)

		if((boundary_option==6).or.(boundary_option>=10)) then

			numerical_n = .true.
			if(boundary_option==6) then
				numerical_p = .false.
			else
				numerical_p = .true.
			endif
			numerical_Bz = .false.
			numerical_mtheta = .false.
			call read_numerical
			rho_boundary = dofpsi(0.d0)
			p_boundary = pofpsi(0.d0)

			if((res_implicit_option==25) .or.(res_implicit_option==35) )then
				rho_boundary = rho_boundary/res_factor
			endif

			if(res_implicit_option==35) then
				res_xmin = rho_boundary
				res_xmax = dofpsi(1.d0)
			endif

		endif

		continue

	end subroutine read_restart_1

	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
	subroutine read_restart_2
	!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

		use mod_arrays, only : eta_phys

		open (unit=18, file=title_time//'_SIM2D_bin.out', form='unformatted', status='old', action='read')

		do j=0,ny+1
		do i=0,nx+1

			read(18) rho(i,j),bx(i,j),by(i,j),bz(i,j),u(i,j),v(i,j),w(i,j),p(i,j),psi_init(i,j),eta_phys(i,j)

		enddo
		enddo

		close(18)

		psi_axis = maxval(psi_init)

		if((boundary_option==6).or.(boundary_option>=10)) then

			numerical_n = .true.
			if(boundary_option==6) then
				numerical_p = .false.
			else
				numerical_p = .true.
			endif
			numerical_Bz = .false.
			numerical_mtheta = .false.
			call read_numerical
			rho_boundary = dofpsi(0.d0)
			p_boundary = pofpsi(0.d0)

			if((res_implicit_option==25) .or.(res_implicit_option==35) )then
				rho_boundary = rho_boundary/res_factor
			endif

			if(res_implicit_option==35) then
				res_xmin = rho_boundary
				res_xmax = dofpsi(1.d0)
			endif

		endif

		continue

	end subroutine read_restart_2


end subroutine read_restart
