!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine read_input
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY: grid, times, physical, numerical, toroidal, boundary,  &
												control, equilibrium_numerical, source, axis, smoothing,  &
												nx,ny,xlength,ylength, time_0,timax,                    &
												tstartprint, dt_print, dt_restart, dt_scale,           &
												dt_min, fcourant, v_shear, art_visc1,art_visc2, &
												art_visc_sound_1,art_visc_sound_2,&
												art_cond1,art_cond2, art_diff1,art_diff2, &
												v_shear_edge, v_shear_exponent,  &
												pmin, tmin, rhomin, numerical_input_option,  &
												itemax, restart_option, i_oper_splitting, torus, rmajor, boundary_option,  &
												art_diff_force1, art_diff_force2, art_diff_option, rsh, rmu0, tmu0,  &
												rsource_min, rsource_max, alpha_source_max, source_option,  &
												time_end_source, rdiff_min, diff_index_range, x_axis, y_axis,  &
												output_option, psi_source_min, psi_source_max,  &
												smoothing_option, istart, iend, jstart, jend, smoothing_ite, &
												istart_smooth, iend_smooth, jstart_smooth, jend_smooth, dt_smooth,  &
												smoothing_index_B, smoothing_index_L, smoothing_index_T, smoothing_index_R,  resistivity_smoothing, &
												divergence_tolerance, vacuum_region, divergence_init, boundary_Mach,  &
												res_coeff, divB_option, mass_recycling_factor, source_type, run_source


	use GS_equilibrium, only : FLOW,  &
											rmajor_FLOW, dcenter, de_o_dc, alpha, alpha_rho, beta_center,  &
											pe_o_pc, p_add, b_phi_zero, Fc_o_Fv, kappa, mach_phi_max,  &
											alpha_mphi, mphi_min, mach_theta_max, mach_theta_edge, t_mth,  &
											mach_theta_option

	use vacuum_module, only : vacuum_input, res_eta_max, res_eta_min, res_factor, res_eta_xjump,  &
											res_implicit_option, res_phys_exp, eta_phys_boundary, eta_phys_center, initialize_eta_phys, additional_res_steps

	use boundary_routines, only : Mach_boundary

	implicit none



!	input namelists

!	write(*,*) rmajor_FLOW
!	write(*,*) dcenter
!	write(*,*) de_o_dc
!	write(*,*) alpha
!	write(*,*) alpha_rho
!	write(*,*) beta_center
!	write(*,*) pe_o_pc
!	write(*,*) p_add
!	write(*,*) b_phi_zero
!	write(*,*) Fc_o_Fv
!	write(*,*) kappa
!	write(*,*) mach_phi_max
!	write(*,*) alpha_mphi
!	write(*,*) mphi_min
!	write(*,*) mach_theta_max
!	write(*,*) mach_theta_edge
!	write(*,*) t_mth
!	write(*,*) mach_theta_option


!	read input parameters

	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,grid);        write(*,grid); close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,times);       write(*,times); close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,physical);   write(*,physical);close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,numerical);   write(*,numerical);close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,toroidal);   write(*,toroidal);close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,boundary);    write(*,boundary); close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,control);     write(*,control); close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,source);     write(*,source); close(55)
	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,axis);     write(*,axis); close(55)


	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,equilibrium_numerical);  write(*,equilibrium_numerical); close(55)


	open(unit=55,file='input/inputfile_SIM2D.dat',status='old', action='read')
!	write(*,FLOW)
	read(55,FLOW)
	write(*,FLOW)
	close(55)

	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,vacuum_input)
	if(vacuum_region==1) then
		write(*,vacuum_input)
	endif
	close(55)


	open(55,file='input/inputfile_SIM2D.dat',status='old');read(55,smoothing);  write(*,smoothing); close(55)

	! store original input for future reference
	open(66,file='input/inputfile_SIM2D_original')

	write(66,grid)
	write(66,*) '		'

	write(66,times)
	write(66,*) '		'

	write(66,physical)
	write(66,*) '		'

	write(66,numerical)
	write(66,*) '		'

	write(66,toroidal)
	write(66,*) '		'

	write(66,boundary)
	write(66,*) '		'

	write(66,control)
	write(66,*) '		'

	write(66,source)
	write(66,*) '		'

	write(66,axis)
	write(66,*) '		'

	write(66,equilibrium_numerical)
	write(66,*) '		'
!	print*, 'before writing FLOW'

	write(66,FLOW)
	write(66,*) '		'
!	print*, 'after writing FLOW'

	write(66,smoothing)
	write(66,*) '		'

	write(66,vacuum_input)

	close(66)

!	if(smoothing_option==4) dt_smooth = 0.d0

	istart_smooth = istart; istart = 1
	iend_smooth = iend; iend = nx
	jstart_smooth = jstart; jstart = 1
	jend_smooth = jend; jend = ny

	tmu0 = 2.d0*rmu0

	Mach_boundary = boundary_Mach

	if(res_implicit_option<=0) then
		! only del**2 treated implicitly
		res_coeff = 1.d0
	elseif(res_implicit_option==1) then
		! all but terms with eta derivatives treated implicitly
		res_coeff(1) = 0.d0
		res_coeff(2) = 1.d0
	elseif(res_implicit_option>=2) then
		! all resistivity terms treated implicitly
		res_coeff = 0.d0
	endif

	if((restart_option<2).and.(res_implicit_option==45)) then
		initialize_eta_phys = .true.
	endif

	if(source_type>0.d0) run_source = .true.


	return

end subroutine read_input


