!***************************************************************************
! Subroutine  Primitive_var     generates primitive variables
!                               from conservative variables
!
!   The primitive variables are: 
!   x-velocity                          u=gx/rho  
!   y-velocity                          v=gy/rho        
!   pressure                            p=(rsh-1)*(enfl-0.5*rho*(u^2+v^2))
!
!  If the calcuted pressure or density are less than pmin and rhomin
!     then p and rho are reset equal to pmin and rhomin
!****************************************************************************

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine primitive_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, ONLY: dkind, rsh,pmin,rhomin,tmu0, nx, ny
	use mod_arrays, only : nmx, nmy

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rho, gx, gy, gz, enfl, u, v, w, p, bx, by, bz
	real(kind=dkind) :: bsqij
	integer :: i, j

!$omp parallel default(shared)
!$omp do private(i,j,bsqij)
	do  j=1,ny 
    do  i=1,nx

	u(i,j)=gx(i,j)/rho(i,j)
	v(i,j)=gy(i,j)/rho(i,j)
	w(i,j)=gz(i,j)/rho(i,j)

	bsqij=bx(i,j)**2+by(i,j)**2+bz(i,j)**2
	p(i,j)=(rsh-1.d0)*(enfl(i,j)-bsqij/tmu0 &
	        -0.5d0*rho(i,j)*(u(i,j)**2+v(i,j)**2+w(i,j)**2))

	p(i,j)=dmax1(pmin,p(i,j))
	rho(i,j)=dmax1(rhomin,rho(i,j))


    end do
    end do
!$omp enddo
!$omp end parallel

  
	return

end subroutine primitive_var
