!********************************************************************
!  param  ::  calculates essential parameters and initialize some
!             time variables.
!             tprint  -> It sets the time for output printing
!             An  = mass_ions/(1+atomic_number)
!             dx  = cell size in x
!             dy  = xell size in y
!             xv(i)   x-coordinate of point i
!             yv(j)   y-coordinate of point j
!*********************************************************************


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine param
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	  use mod_parameters, ONLY: An,nx,ny,dx,dy,xlength,ylength,timen,time_0, &
							    tprint,tstartprint,dt,dt_min, rmajor, torus, t_restart, t_smooth,  &
								dt_smooth
							  
	use mod_arrays, ONLY: xv,yv,Rmaj, Rmaj_plushalf
	use vacuum_module, only : res_implicit_option

	! allocate arrays
	call initialize_arrays

!  initialize relevant times
    timen=time_0
	tprint=tstartprint
	t_restart = time_0
	t_smooth = time_0 + dt_smooth

! initialize time step dt
    dt=dt_min

! calculate  An=mass_ions/(1+atomic_number)
	An=1  !rmi/(1.0d0+zef)
! calculate cell size
	dx=xlength/nx
	dy=ylength/ny

! calculate x-coordinates of grid points
	do i=0,nx+1
	    xv(i)=(i-1.)*dx+0.5*dx
	end do

! calculate y-coordinates of grid points
	do j=0,ny+1
	    yv(j)=(j-1.)*dy+0.5*dy
	end do 

! calculate major radius of grid points
	do i=0,nx+1
	    Rmaj(i)=rmajor + torus*(xV(i)-xlength/2.d0)
	end do

! calculate major radius of half grid points, if necessary
	if(res_implicit_option==3) then
		do i=0,nx+1
			Rmaj_plushalf(i)=rmajor + torus*(xV(i)-xlength/2.d0)+0.5d0*dx
		end do
	endif

	return

end subroutine param


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine initialize_arrays
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, only : nx, ny
	use mod_arrays, only : nmx, nmy, rho, u, v, w, p, Tn, psi_init, bx, by, bz, xV, yV, Rmaj, Rmaj_plushalf,  &
											rhopr, bxpr, bypr, bzpr, gx, gxpr, gy, gypr, gz, gzpr, upr, vpr, wpr, ppr, enfl, enflpr,  &
											eta_phys, eta_physpr

	implicit none

	nmx = nx
	nmy = ny

	allocate(rho(0:nmx+1,0:nmy+1),&  ! density in kg/m^3
						u(0:nmx+1,0:nmy+1), &   ! velocity in x in m/s
						v(0:nmx+1,0:nmy+1), &   ! velocity  in y in m/s
						w(0:nmx+1,0:nmy+1), &   ! velocity  in z in m/s
						p(0:nmx+1,0:nmy+1), &   ! pressure in newton/m^2
						Tn(0:nmx+1,0:nmy+1),&   ! active
						psi_init(0:nmx+1,0:nmy+1), &	! initial psi, for restart files
						eta_phys(0:nmx+1,0:nmy+1) )	! for resitivity profile (must be allocated for restart compatibility)

	allocate(bx(0:nmx+1,0:nmy+1),&   ! magnetic field in Tesla, x component
						by(0:nmx+1,0:nmy+1),&   ! magnetic field in Tesla,  y component
						bz(0:nmx+1,0:nmy+1)  ) ! magnetic field in Tesla,  z component
																
	allocate(yv(0:nmy+1),&   ! grid in y
						xv(0:nmx+1), &     ! grid in x
						Rmaj(0:nmx+1), &     ! major radius of the torus
						Rmaj_plushalf(0:nmx+1) )

	allocate(rhopr(0:nmx+1,0:nmy+1), bxpr(0:nmx+1,0:nmy+1), bypr(0:nmx+1,0:nmy+1),  &
				 bzpr(0:nmx+1,0:nmy+1), gx(0:nmx+1,0:nmy+1), gxpr(0:nmx+1,0:nmy+1),  &
				 gy(0:nmx+1,0:nmy+1), gypr(0:nmx+1,0:nmy+1), gz(0:nmx+1,0:nmy+1),  &
				 gzpr(0:nmx+1,0:nmy+1), upr(0:nmx+1,0:nmy+1), vpr(0:nmx+1,0:nmy+1),  &
				 wpr(0:nmx+1,0:nmy+1), ppr(0:nmx+1,0:nmy+1), enfl(0:nmx+1,0:nmy+1),  &
				 enflpr(0:nmx+1,0:nmy+1), eta_physpr(0:nmx+1,0:nmy+1))

end subroutine initialize_arrays