
!**********************************************************************
!  Output:  determines when to print. It calls the printing subroutine
!           output_sub at every interval dt_print
!***********************************************************************
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine output
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

    use mod_parameters, ONLY : dkind, timen,dt_print,tprint,t_restart, dt_restart
	use mod_arrays, ONLY: xv,yv

	implicit none


!	print*, 'output, times:', timen, tprint

	if(timen >= tprint)then
		print*,"#####################################"
	    print '(1x," PRINT AT TIME = ",F8.3)',timen*100
	    call output_sub
	   call conservation_integrals
	    tprint=tprint+dt_print
!	        pause
!		else
!		       	print '(1x," NOT PRINTING AT TIME = ",F8.3)',timen*100
	endif

	if(timen >= t_restart)then
	    call write_restart
		t_restart = t_restart + dt_restart
	endif

end subroutine output


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine output_sub
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, ONLY : dkind, An,nx,ny,dx,dy,timen,  &
	                         rsh, dt_scale,  output_option
	use mod_arrays, ONLY:rho,bx,by,bz,u,v,w,p,xv,yv
	use boundary_routines, only : sort_grid
	use vacuum_module, only : res_eta

	implicit none

	real(kind=dkind) :: timeps
	integer :: jtime
    character*16:: title, last_file
	integer :: visit_file = 75
	character*200 :: header
	real(kind=dkind) :: cs, csp, Bp, mach, Bsq, Jz
	integer :: imin, imax, jmin, jmax
	integer :: i, j


	if(output_option==0) then
		imin = 0
		imax = nx+1
		jmin = 0
		jmax = ny+1
	elseif(output_option==1) then
		imin = 1
		imax = nx
		jmin = 1
		jmax = ny
	endif


! generate output file name and print action on screed
!	timeps = timen*100
	timeps = timen/dt_scale
	jtime=timeps
	    title(07:16)='_SIM2D.plt'
	call get_title(title(01:06),jtime)

!	    write(title(01:06),'(i6)')jtime
	  print*,"  Printing in Output File:  ",title
	  print*,"#####################################"

	open(visit_file,file='database_SIM2D.visit')

	read(visit_file,200,end=34) last_file

	do
		read(visit_file,201,end=34) last_file
	enddo

34	if(last_file/=title) then
		write(visit_file,201) title
	endif

	close(visit_file)

	if((title(4:6)=='500').or.(title(4:6)=='000')) then
	! also add an entry to the "short" database

		open(visit_file,file='short_database_SIM2D.visit')

		read(visit_file,200,end=36) last_file

		do
			read(visit_file,201,end=36) last_file
		enddo

	36	if(last_file/=title) then
			write(visit_file,201) title
		endif

		close(visit_file)

	endif

	header = 'Variables = "X", "Y","RHO","BX","BY","BZ","P","U","V","W", "Jz", "C_s", "C_s_p","Mach_p","resistivity"'

! open output file and print header for Tecplot
	open(61,file=title)
	write(61,*)'TITLE="solution at time t=',timeps,'"'
!	write(61,*)'Variables = "X", "Y","RHO","BX","BY","BZ","P","U","V","W","VORT"'	! ,"VAVE"
!	write(61,*)'Variables = "X", "Y","RHO","BX","BY","BZ","P","U","V","W"'	! ,"VAVE"
	write(61,221) header
!	write(61,*)'ZONE I=',nx,',J=',ny,',F=Point'
	write(61,*)'ZONE I=',imax-imin+1,',J=',jmax-jmin+1,',F=Point'

!  print output 

!    Do  j=1,ny
    Do  j = jmin, jmax

!	Do  i=1,nx
	Do  i = imin, imax

		Bsq = sqrt(bx(i,j)**2+by(i,j)**2+bz(i,j)**2)
		Bp = sqrt(bx(i,j)**2+by(i,j)**2)

		if((rho(i,j)<=0.d0).or.(Bsq<=0.d0).or.(p(i,j)<=0.d0).or.(Bp<=0.d0)) then
			cs=0.d0
			csp = 0.d0
			mach = 0.d0
		else
			cs = sqrt(rsh*p(i,j)/rho(i,j))
			csp = cs*Bp/Bsq
			mach = min(sqrt(u(i,j)**2+v(i,j)**2)/(csp+1.d-18),10.d0)
		endif

		if(((min(i,j)<1).or.(i>nx).or.(j>ny)).or.(sort_grid(i,j)<0)) then

			Jz = 0.d0

		else

			Jz = (by(i+1,j)-by(i-1,j))/(2.d0*dx) -  &
				   (bx(i,j+1)-bx(i,j-1))/(2.d0*dy)

		endif


!	 write(61,222)x_mic,y_mic,rho_gcm3,bx(i,j),by(i,j),bz(i,j),p_Mb,t_kev,,u(i,j),v(i,j),vort_ns,v_ave
!	 write(61,222)x_mic,y_mic,rho_gcm3,bx(i,j),by(i,j),bz(i,j),p_Mb,u(i,j),v(i,j),w(i,j),vort_ns	!,v_ave
!	 write(61,222)xV(i),yV(j),rho(i,j),bx(i,j),by(i,j),bz(i,j),p(i,j),u(i,j),v(i,j),w(i,j)	!,v_ave
		write(61,223) xV(i),yV(j),rho(i,j),bx(i,j),by(i,j),bz(i,j),p(i,j),u(i,j),v(i,j),w(i,j), Jz, cs, csp, mach, res_eta(i,j,0)


200 format((a10))
201 format((a16))
221 format((a200))
222 format(E13.6,10(5x,E13.6))
223 format(E13.6,15(5x,E13.6))



    end do
    end do

	close(61)

!	pause


 	return

end subroutine output_sub



!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine conservation_integrals
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, timen, nx, ny, dA,  &
												check_conservation, conservation_file
	use mod_arrays, only : nmx, nmy, rho, bx, by, bz, u, v, w, p, Rmaj
	use boundary_routines, only : sort_grid

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: gx, gy, gz, enfl
	real(kind=dkind) :: int_rho, int_gx, int_gy, int_gz, int_enfl, poloidal_momentum
	real(kind=dkind) :: Bpol
	real(kind=dkind) :: g_factor
	integer :: i,j

	if(check_conservation) then
		continue
	else
		return
	endif

	int_rho = 0.d0
	int_gx = 0.d0
	int_gy = 0.d0
	int_gz = 0.d0
	int_enfl = 0.d0

	call conservative_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)

	do j = 0, ny
	do i = 0, nx

		! this will mess up things a bit in the corners, but better than nothing

		g_factor = dA * (Rmaj(i)+Rmaj(i+1))/2.d0


		int_rho = int_rho +  g_factor *&
						0.25d0*( rho(i,j) + rho(i+1,j) + rho(i,j+1) + rho(i+1,j+1) )

		int_gx = int_gx +  g_factor *&
						0.25d0*( gx(i,j) + gx(i+1,j) + gx(i,j+1) + gx(i+1,j+1) )

		int_gy = int_gy +  g_factor *&
						0.25d0*( gy(i,j) + gy(i+1,j) + gy(i,j+1) + gy(i+1,j+1) )

		int_gz = int_gz +  g_factor *&
						0.25d0*( gz(i,j) + gz(i+1,j) + gz(i,j+1) + gz(i+1,j+1) )

		int_enfl = int_enfl +  g_factor *&
						0.25d0*( enfl(i,j) + enfl(i+1,j) + enfl(i,j+1) + enfl(i+1,j+1) )


		if(sort_grid(i,j)<2) then

			cycle

		else

			Bpol = sqrt(bx(i,j)**2+by(i,j)**2)

			if(Bpol<1.d-2) cycle
			! ad hoc, to avoid problems in the center

			poloidal_momentum = poloidal_momentum + rho(i,j) *  &
												(u(i,j)*bx(i,j) + v(i,j)*by(i,j)) / Bpol * dA

		endif

	enddo
	enddo

	write(conservation_file,111) timen, int_rho, int_gx, int_gy, int_gz, poloidal_momentum, int_enfl

111 format(7(e15.9, 3x))


end subroutine conservation_integrals

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine poloidal_momentum_integral
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, nx, ny, dA, poloidal_momentum
	use mod_arrays, only : rho, u, v, bx, by
	use boundary_routines, only : sort_grid

	implicit none

	real(kind=dkind) :: Bpol
	integer :: i, j

	poloidal_momentum = 0.d0

	do j = 1, ny
	do i = 1, nx

		if(sort_grid(i,j)<2) cycle

		Bpol = sqrt(bx(i,j)**2+by(i,j)**2)

		if(Bpol<1.d-2) cycle
		! ad hoc, to avoid problems in the center

		poloidal_momentum = poloidal_momentum + rho(i,j) *  &
											(u(i,j)*bx(i,j) + v(i,j)*by(i,j)) / Bpol * dA

	enddo
	enddo

	continue

	return

end subroutine poloidal_momentum_integral

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine boundary_mass_integral(mass)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, nx, ny, dA
	use mod_arrays, only : rho, Rmaj
	use boundary_routines, only : sort_grid

	implicit none

	real(kind=dkind) :: mass
	real(kind=dkind) :: g_factor
	integer :: i, j

	mass = 0.d0

	do j = 0, ny
	do i = 0, nx

		if(sort_grid(i,j)/=1.d0) cycle

		! this will mess up things a bit in the corners, but better than nothing

		g_factor = dA * (Rmaj(i)+Rmaj(i+1))/2.d0

		mass = mass +  g_factor *&
						0.25d0*( rho(i,j) + rho(i+1,j) + rho(i,j+1) + rho(i+1,j+1) )

	enddo
	enddo


111 format(6(e15.9, 3x))


end subroutine boundary_mass_integral


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine write_predictor(rhopr,upr,vpr,wpr,ppr,bxpr,bypr,bzpr)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : rsh, nx, ny
	use mod_arrays, only : xV, yV

	implicit none

	integer, parameter :: dkind=kind(1.d0)
	real(kind=dkind), dimension(0:nx+1, 0:ny+1) :: rhopr, upr, vpr, wpr,  &
								ppr, bxpr, bypr, bzpr

	real(kind=dkind) :: vx, vy, bsq, bp, cs, csp, mach, Bx, By
	integer :: i,j



	open(61,file='pippa_predictor.plt')
	write(61,*)'TITLE="predictor step"'
	write(61,221) 'Variables = "X", "Y","RHO","Bx","By","bz","P","Vx","Vy","Vphi", "C_s", "C_s_p","Mach_p"'
	write(61,*)'ZONE I=',nx+2,',J=',ny+2,',F=Point'

!  print output 

	do  j=0,ny+1
	do  i=0,nx+1

		Bsq = sqrt(bxpr(i,j)**2+bypr(i,j)**2+bzpr(i,j)**2)
		Bp = abs(bypr(i,j))

		if((rhopr(i,j)<=0.d0).or.(Bsq==0.d0).or.(ppr(i,j)<=0.d0).or.(Bp==0.d0)) then
			cs=0.d0
			csp = 0.d0
			mach = 0.d0
		else
			cs = sqrt(rsh*ppr(i,j)/rhopr(i,j))
			csp = cs*Bp/Bsq
			mach = min(sqrt(upr(i,j)**2+vpr(i,j)**2)/(csp+1.d-18),10.d0)
		endif

		vx = upr(i,j)
		vy = vpr(i,j)

		Bx = bxpr(i,j)
		By = bypr(i,j)

		write(61,223) xV(i),yV(j),rhopr(i,j),Bx,By,bzpr(i,j),ppr(i,j),vx,vy,wpr(i,j), cs, csp, mach

	enddo
	enddo

	close(61)


221 format((a200))
223 format(E13.6,13(5x,E13.6))

end subroutine write_predictor

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine write_corrector(rho,u,v,w,p,bx,by,bz)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : rsh, nx, ny
	use mod_arrays, only : xV, yV

	implicit none

	integer, parameter :: dkind=kind(1.d0)
	real(kind=dkind), dimension(0:nx+1, 0:ny+1) :: rho, u, v, w,  &
								p, bx, by, bz
	integer :: i_corrector

	real(kind=dkind) :: vx, vy, bsq, bp, cs, csp, mach, Bxloc, Byloc
	integer :: i,j


	open(61,file='pippa_corrector.plt')
	write(61,*)'TITLE="predictor step"'
	write(61,221) 'Variables = "X", "Y","RHO","Bx","By","bz","P","Vx","Vy","Vphi", "C_s", "C_s_p","Mach_p"'
	write(61,*)'ZONE I=',nx+2,',J=',ny+2,',F=Point'

!  print output 

	do  j=0,ny+1
	do  i=0,nx+1


		Bsq = sqrt(bx(i,j)**2+by(i,j)**2+bz(i,j)**2)
		Bp = sqrt(bx(i,j)**2+by(i,j)**2)

		if((rho(i,j)<=0.d0).or.(Bsq==0.d0).or.(p(i,j)<=0.d0).or.(Bp==0.d0)) then
			cs=0.d0
			csp = 0.d0
			mach = 0.d0
		else
			cs = sqrt(rsh*p(i,j)/rho(i,j))
			csp = cs*Bp/Bsq
			mach = min(sqrt(u(i,j)**2+v(i,j)**2)/(csp+1.d-18),10.d0)
		endif

		vx = u(i,j)
		vy = v(i,j)

		Bxloc = bx(i,j)
		Byloc = by(i,j)

		write(61,223) xV(i),yV(j),rho(i,j),Bx(i,j),By(i,j),bz(i,j),p(i,j),vx,vy,w(i,j), cs, csp, mach

	enddo
	enddo

	close(61)


221 format((a200))
223 format(E13.6,13(5x,E13.6))


end subroutine write_corrector

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine write_mom_x(rho,u,v,w,p,bx,by,bz)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : rsh, nx, ny, dx, dy, rmu0
	use mod_arrays, only : xV, yV, Rmaj

	implicit none

	integer, parameter :: dkind=kind(1.d0)
	real(kind=dkind), dimension(0:nx+1, 0:ny+1) :: rho, u, v, w,  &
								p, bx, by, bz

	real(kind=dkind) :: vx, vy, bsq, bp, cs, csp, mach, Bxloc, Byloc, total
	real(kind=dkind), dimension(1:7) :: term
	real(kind=dkind) :: dx2, dy2
	integer :: i,j

	dx2 = 2.d0*dx; dy2 = 2.d0*dy


	open(69,file='mom_x_terms.plt')
	write(69,*)'TITLE="momentum x"'
	write(69,221) 'Variables = "X", "Y","rho_u^2","Bx^2","Ptot","rho_u_v","Bx_By","rho_w^2","Bz^2","sum"'
	write(69,*)'ZONE I=',nx,',J=',ny,',F=Point'

!  print output 

	do  j=1,ny
	do  i=1,nx

		term = 0.d0

		term(1) = (Rmaj(i+1)*rho(i+1,j)*u(i+1,j)**2-Rmaj(i-1)*rho(i-1,j)*u(i-1,j)**2)/dx2/Rmaj(i)
		term(2) = -(Rmaj(i+1)*Bx(i+1,j)**2-Rmaj(i-1)*Bx(i-1,j)**2)/dx2/Rmaj(i)/rmu0

		term(3) = ( ( p(i+1,j) + (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/2.d0/rmu0 ) -  &
						( p(i-1,j) + (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/2.d0/rmu0 ) )/dx2

		term(4) = ( rho(i,j+1)*u(i,j+1)*v(i,j+1)-rho(i,j-1)*u(i,j-1)*v(i,j-1) ) / dy2
		term(5) = -( Bx(i,j+1)*By(i,j+1)-Bx(i,j-1)*By(i,j-1) ) / dy2 / rmu0

		term(6) = -rho(i,j)*w(i,j)**2/Rmaj(i)
		term(7) = Bz(i,j)**2/Rmaj(i)/rmu0

		total = sum(term)


		write(69,223) xV(i),yV(j),term(1),term(2),term(3),term(4),term(5),term(6),term(7),total

	enddo
	enddo

	close(69)


221 format((a200))
223 format(E13.6,9(5x,E13.6))


end subroutine write_mom_x


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine write_restart
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_arrays, ONLY:rho,bx,by,bz,u,v,w,p,psi_init,eta_phys
	use mod_parameters, ONLY: grid, times, physical, numerical, toroidal, boundary,  &
												control, equilibrium_numerical, source, axis, smoothing,  &
												timen, nx,ny,xlength,ylength,              &
												time_0,timax, tstartprint, dt_print,           &
												dt_restart, dt_scale, dt_min, fcourant,            &
												v_shear, art_visc1,art_visc2, &
												art_visc_sound_1,art_visc_sound_2,&
												art_cond1,art_cond2, art_diff1,art_diff2, &
												v_shear_edge, v_shear_exponent,  &
												pmin, tmin, rhomin,              &
												numerical_input_option,  &
												itemax, restart_option, i_oper_splitting,        &
												torus, rmajor, boundary_option,  &
												art_diff_force1, art_diff_force2, art_diff_option,  &
												rsh, rmu0, tmu0,  &
												rsource_min, rsource_max, alpha_source_max, source_option,  &
												time_end_source, rdiff_min, diff_index_range, x_axis, y_axis,  &
												output_option, psi_source_min, psi_source_max,  &
												smoothing_option, istart, iend, jstart, jend, smoothing_ite, &
												istart_smooth, iend_smooth, jstart_smooth, jend_smooth, dt_smooth,  resistivity_smoothing, &
												divergence_tolerance, vacuum_region, divergence_init, divB_option,  &
												mass_recycling_factor, source_type


	use GS_equilibrium, only : FLOW,   &
											rmajor_FLOW, dcenter, de_o_dc, alpha, alpha_rho, beta_center,  &
											pe_o_pc, p_add, b_phi_zero, Fc_o_Fv, kappa, mach_phi_max,  &
											alpha_mphi, mphi_min, mach_theta_max, mach_theta_edge, t_mth,  &
											mach_theta_option

	use vacuum_module, only : vacuum_input, res_eta_max, res_eta_min, res_factor, res_eta_xjump, res_phys_exp,  &
													eta_phys_boundary, eta_phys_center, initialize_eta_phys, additional_res_steps !, res_eta

	use boundary_routines, only : Mach_boundary

	implicit none

	character*6 :: title_time
	integer :: jtime
	integer i,j

	jtime = timen/dt_scale
!    write(title_time(01:06),'(i6)')jtime
	call get_title(title_time,jtime)

!	open (unit=17, file=title_time//'_bin.out', form='unformatted', status='unknown', action='write')
	open (unit=18, file=title_time//'_SIM2D_bin.out', form='unformatted', status='unknown', action='write')

	do j=0,ny+1
	do i=0,nx+1

!		write(17) rho(i,j),bx(i,j),by(i,j),bz(i,j),u(i,j),v(i,j),w(i,j),p(i,j),psi_init(i,j) !, res_eta(i,j,0)
		write(18) rho(i,j),bx(i,j),by(i,j),bz(i,j),u(i,j),v(i,j),w(i,j),p(i,j),psi_init(i,j), eta_phys(i,j)

	enddo
	enddo

!	close(17)
	close(18)

	continue

	!------------------------2/17/2010: also rewrite inputfile for parallel runs queue system------------------------

	time_0 = jtime/100
	tstartprint = max(time_0, tstartprint)
	restart_option = 2

	istart = istart_smooth
	iend = iend_smooth
	jstart = jstart_smooth
	jend = jend_smooth

	open(66,file='input/inputfile_SIM2D.dat')

	write(66,grid)
	write(66,*) '		'

	write(66,times)
	write(66,*) '		'

	write(66,physical)
	write(66,*) '		'

	write(66,numerical)
	write(66,*) '		'

	write(66,toroidal)
	write(66,*) '		'

	write(66,boundary)
	write(66,*) '		'

	write(66,control)
	write(66,*) '		'

	write(66,source)
	write(66,*) '		'

	write(66,axis)
	write(66,*) '		'

	write(66,equilibrium_numerical)
	write(66,*) '		'

	write(66,FLOW)
	write(66,*) '		'

	write(66,smoothing)
	write(66,*) '		'

	write(66,vacuum_input)

	close(66)

	istart = 1
	iend = nx
	jstart = 1
	jend = ny

	continue

	return

end subroutine write_restart


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine get_title(title_time,jtime)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	implicit none

	character*6 :: title_time
	integer :: jtime

	integer i

	do i = 1, 6
	    write(title_time(i:i),'(i1)') 0
	enddo

	if(jtime<10) then
	    write(title_time(06:06),'(i1)')jtime
	elseif(jtime<100) then
	    write(title_time(05:06),'(i2)')jtime
	elseif(jtime<1000) then
	    write(title_time(04:06),'(i3)')jtime
	elseif(jtime<10000) then
	    write(title_time(03:06),'(i4)')jtime
	elseif(jtime<100000) then
	    write(title_time(02:06),'(i5)')jtime
	elseif(jtime<1000000) then
	    write(title_time(01:06),'(i6)')jtime
	else
		print*, 'time is too large: increase dt_scale'
		print*, '999999 returned'
	    write(title_time(01:06),'(i6)') 999999
	endif

end subroutine get_title
