module mod_parameters

	implicit none

	integer, parameter :: dkind=kind(1.d0)


	! Fixed Physical parameters 
	real(kind=dkind), parameter :: mp=1.d0,	 & 	!1.6726e-27   ! mass of the proton in kg
			                    rkappa=3.734d+69, & !3.734d+69   ! Spitzer coefficient for thermal conduction (default:3.74d+69)
								rnu=2.5d0,       &    ! power index for thermal conduction
								pi=3.141592653589793238462d0

	real(kind=dkind)::              An                    ! mi/(1+z_eff)

	real(kind=dkind) :: 					            rsh= 1.66666666666667d0, &    ! ratio of specific heats 5/3 1.6666667d0,
								rmu0=1.d0, & !1.2566370614359172954d-6,& !mu0=vacuum permittivity
								tmu0=2.d0 !2.5132741228718345908d-6  !2*mu0



	logical :: check_conservation = .true.

	real(kind=dkind) :: torus = 1.d0 ! 0 for cyliindrical, 1 for toroidal
	real(kind=dkind) :: rmajor = 5.d2 ! relevant only if torus==1

	! Numerical parameters assigned from input
	real(kind=dkind):: art_visc1,&  ! coefficient quadratic artificial viscosity
                   art_visc2,&  ! coefficient linear artificial viscosity
					art_visc_sound_1,&  ! coeff. linear art. visc. proportional to csound
					art_visc_sound_2,&  ! coeff. quadratic art.visc. proportional to grad(csound)
				   art_cond1,&  ! coefficient quadratic artificial conduction
				   art_cond2,&  ! coefficient linear artificial conduction
                   art_diff1,&  ! coefficient for sound speed in artificial diffusion
				   art_diff2,&  ! coefficient for flow velocity in artificial diffusion
                   art_diff_force1,&  ! coefficient for sound speed in artificial diffusion (force smoothing)
				   art_diff_force2,&  ! coefficient for flow velocity in artificial diffusion (force smoothing)
				   v_shear,  &  ! coefficient for shear artificial viscosity (normally zero) 
				   fcourant, &  ! Courant factor (normally 0.5)
				   pmin,     &  ! minimum acceptable value of the pressure
				   tmin,     &  ! minimum acceptable value of the temperature
				   rhomin,  &       ! minimum acceptable value of the density
				   v_shear_edge,  &  ! parameter for increasing edge shear viscosity (boundary multiplicator for v_shear)
				   v_shear_exponent  ! parameter for increasing edge shear viscosity (v_shear variation exponent)

	real(kind=dkind) rdiff_min	! no diffusion for r<rdiff_min (to keep the core as it is)
	integer :: diff_index_range	! apply diffusion to the peaks, and points within diff_index_range of the peaks

	! Grid Parameters to be used in the computation
	Integer::          nx, &  ! number of grid points in x
					   ny   ! number of grid points in y 

	real(kind=dkind):: dx,      & ! cell size in x 
					   dy,      & ! cell size in y
					   xlength, & ! box size in x
					   ylength, & ! box size in y 
					   dt,  &         ! time step
					   dA			! cell area for conservation check

	! Physical parameters used to control the equilibrium
	real(kind=dkind) :: pedge	! pressure at plasma edge

	integer :: numerical_input_option
	! 1->1D equilibrium, 2-> (FLOW) 2D equilibrium

	! output parameters
	real(kind=dkind):: tstartprint, & ! time when output starts
                   dt_print,    & ! interval bewteen outputs
				   time_0,      & ! beginning time of computation
				   timen,       & ! time in sec
				   tprint,      & ! print when timen > tprint
				   dt_min,      & ! minimum time step (from input)
				   timax,  &          ! length of the computation = final time
				   t_restart,  &	! save restart files when timen>t_restart
				   dt_restart,  &		! interval between restart output
				   dt_scale		! time unit for tecplot files (~dt_print)



	! Control parameters
	Integer:: itemax   ! maximum number of cycles

	Logical::   & ! i_keep_equi = true/false-> activate equilibrium control
!			  irestart,      & ! determine if using a restart file
			  i_oper_splitting, & ! choose the algorithm between "operator splitting" and "combined directions"         
			  integrated      ! choose to integrate the artificial terms and sources into the predictor corrector

	integer :: restart_option
	! 0 -> no restart
	! 1 -> restart from bin file (no resistivity saved)
	! 2 -> restart from SIM2D_bin file (resistivity saved)

	real(kind=dkind) :: FV = 0.d0
	real(kind=dkind) :: FC
	! for GS solver

	integer :: boundary_option
	! 4; 5 -> gridless options, obsolete
	! 6 -> rhoflat version (limited density at the edge)
	! 14 -> sonic (*Mach_boundary) outflow from boundary

	integer :: art_diff_option
	! 0 for sound speed, 1 for Alfven speed
	! 2 for sound speed peaks only, 3 for Alfven speed peaks only
	! 4 for sound speed peaks only plus radius limitation and neighbouring points
	! 5 for Alfven speed peaks only plus radius limitation and neighbouring points

	real(kind=dkind) :: current
	! total plasma current

	real(kind=dkind) :: rsource_min, rsource_max, psi_source_min, psi_source_max
	! for momentum source

	real(kind=dkind) :: alpha_source_max

	integer :: source_option
	! 21 -> with vacuum, linear in radius
	real(kind=dkind) :: time_end_source

	integer :: source_type
	! 1 -> velocity source
	! 2 -> momentum source (including energy term)
	! >0 -> assigned source
	! <0 -> keep track of poloidal momentum

	real(kind=dkind) :: poloidal_momentum, poloidal_momentum_0

	logical :: run_source
	! to switch source on and off if poloidal momentum feedback is in use

	real(kind=dkind) :: external_surface
	! 2D surface of the vacuum region

	real(kind=dkind) :: mass_source = 0.d0

	integer :: smoothing_option
	! 0 for uniform, 1 for peaks

	real(kind=dkind) :: x_axis, y_axis
	! coordinates of the magnetic axis for dissipation routines

	integer :: output_option
	! 0 -> save values on the boundary
	! 1 -> save only internal points

	real(kind=dkind) :: psi_axis = 1.d0
	! psi on the magnetic axis

	integer :: 	istart, iend, jstart, jend

	integer :: 	istart_smooth, iend_smooth, jstart_smooth, jend_smooth, smoothing_ite
	! for smoothing

	integer :: smoothing_index_B, smoothing_index_L, smoothing_index_T, smoothing_index_R

	real(kind=dkind) :: t_smooth, dt_smooth

	integer :: resistivity_smoothing = 0

	real(kind=dkind) :: divergence_tolerance ! for divergence of B

	integer :: vacuum_region
	! 0 -> no vacuum region
	! 1 -> vacuum region (resistive plasma)

	real(kind=dkind), dimension(1:2) :: res_coeff
	! the two coefficients are either "0" or "1", depending on the implicit option
	! (res_implicit_option in vacuum_module)

	logical :: divergence_init
	! whether to initialize the divergence
	! (if .true., the code starts with an extensive divergence run)

	real(kind=dkind) :: boundary_Mach

	real(kind=dkind) :: mass_recycling_factor
	! gives a numerical factor for both the mass recycling and (if negative) for the variation of the recycling

	integer :: divB_option
	! 0 -> B_n = 0 on boundary
	! 1 -> phi = 0 on boundary

	real(kind=dkind) :: rho_boundary = -1.d1
	real(kind=dkind) :: p_boundary = 1.d-1
	! moved here from boundary_routines because they are needed in a higher-level module 

	integer, parameter :: conservation_file=911
	integer, parameter :: visit_file=75

!---------------------input namelists---------------------

	namelist/grid/        nx, ny, xlength, ylength

	namelist/times/       time_0, timax, tstartprint, dt_print, dt_restart,  &
						  dt_min, dt_scale

	namelist/physical/ rsh, rmu0

    namelist/numerical/   fcourant, v_shear, v_shear_edge, v_shear_exponent,  &
						  art_visc1, art_visc2, art_visc_sound_1, art_visc_sound_2, art_cond1,  &
                          art_cond2, art_diff1,art_diff2, art_diff_force1, art_diff_force2,  &
						  art_diff_option, pmin, tmin, rhomin, rdiff_min, diff_index_range, divergence_tolerance

	namelist/toroidal/        torus, rmajor

    namelist/boundary/        boundary_option, boundary_Mach, mass_recycling_factor

	namelist/control/     itemax, restart_option, i_oper_splitting, output_option, &
									vacuum_region, divergence_init, divB_option

	namelist/equilibrium_numerical/  numerical_input_option

	namelist/source/ rsource_min, rsource_max, psi_source_min, psi_source_max,  &
								alpha_source_max, source_option, time_end_source, source_type

	namelist/axis/ x_axis, y_axis

	namelist/smoothing/ smoothing_option, istart, iend, jstart, jend, smoothing_ite, dt_smooth,  &
									smoothing_index_B, smoothing_index_L, smoothing_index_T, smoothing_index_R,  &
									resistivity_smoothing


!---------------------end input namelists---------------------

end module mod_parameters


