module mod_arrays

	use mod_parameters, only : dkind

	! Physical 2-dimensional arrays 
	Integer :: nmx, nmy ! maximum array size in x and y

	! Primitive  arrays variables
	real(kind=dkind), allocatable, dimension(:,:) :: rho,&  ! density in kg/m^3
						u, &   ! velocity in x in m/s
						v, &   ! velocity  in y in m/s
						w, &   ! velocity  in z in m/s
						p   ! pressure in newton/m^2
	real(kind=dkind), allocatable, dimension(:,:) :: Tn,  &   ! active
						psi_init,  &	! initial psi, for restart files
						eta_phys	! for resistivity profile

	! Primitive  arrays variables
	real(kind=dkind), allocatable, dimension(:,:), target :: &
						bx, &   ! magnetic field in Tesla, x component
						by, &   ! magnetic field in Tesla,  y component
						bz   ! magnetic field in Tesla,  z component

	real(kind=dkind), allocatable, dimension(:) :: xV, &   ! grid in x
						yV, &     ! grid in y
						Rmaj, &     ! major radius of the torus
						Rmaj_plushalf

	real(kind=dkind), allocatable, dimension(:,:) :: rhopr, bxpr, bypr, bzpr, gx, gxpr,  &
																		      gy, gypr, gz, gzpr, upr, vpr, wpr, ppr, enfl, enflpr, eta_physpr
end module mod_arrays


