! ********************************************************************************
! magnethydro_pred::  execute the predictor step
!
! The predictor variables are :
!   density                             rhopr 
!	magnetic field-x				bxpr
!	magnetic field-y				bypr
!	magnetic field-z				bzpr
!   x-momentum                          gxpr=rhopr*upr
!   y-momentum                          gypr=rhopr*vpr
!   z-momentum                          gypr=rhopr*vpr
!   total energy                        enflpr=ppr/(rsh-1)+rhopr*(upr^2+vpr^2+wpr^2)/2 + ...
!														(bxpr^2+bypr^2+bzpr^2)/(2mu0)
! ********************************************************************************
!NOTE: this does the same as ALL Riccardo's various pred_back/forw routines
!NOTE: the corrector routine could also be included here; we keep them separate for clarity

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine magnetohydro_pred(ishift, jshift)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY: dkind, tmu0, rmu0, torus, nx, ny, dt, dx, dy,   &
												art_diff_option, res_coeff
    use mod_arrays,     ONLY: Rmaj, rho,bx,by,bz,u,v,w,   &
                           p,gx,gy,gz,enfl,rhopr,bxpr,bypr,bzpr,gxpr,gypr,gzpr,enflpr, eta_phys, eta_physpr
	use vacuum_module, only : res_eta, res_implicit_option

	implicit none

	integer, intent(in) :: ishift, jshift
	!VERY IMPORTANT: these two determine the direction!

	real(kind=dkind) :: &
						fmoxxishiftj_2D(0:nx+1,0:ny+1), fmoxxij_2D(0:nx+1,0:ny+1),  &
						fmoxyij_2D(0:nx+1,0:ny+1),													&
						fmoxyijshift_2D(0:nx+1,0:ny+1), fmoyyij_2D(0:nx+1,0:ny+1),  &
						fmoyyijshift_2D(0:nx+1,0:ny+1),											  &
						fmoyxij_2D(0:nx+1,0:ny+1), fmoyxishiftj_2D(0:nx+1,0:ny+1),  &
						fmozxishiftj_2D(0:nx+1,0:ny+1), fmozxij_2D(0:nx+1,0:ny+1),  &
						fmozyijshift_2D(0:nx+1,0:ny+1), fmozyij_2D(0:nx+1,0:ny+1),  &
!
						fenxishiftj_2D(0:nx+1,0:ny+1), fenxij_2D(0:nx+1,0:ny+1),  &
						fenyijshift_2D(0:nx+1,0:ny+1), fenyij_2D(0:nx+1,0:ny+1),  &
!
						fbxxishiftj_2D(0:nx+1,0:ny+1), fbxxij_2D(0:nx+1,0:ny+1),  &
						fbzxishiftj_2D(0:nx+1,0:ny+1), fbzxij_2D(0:nx+1,0:ny+1),  &
						fbyxishiftj_2D(0:nx+1,0:ny+1), fbyxij_2D(0:nx+1,0:ny+1),  &
						fbzyijshift_2D(0:nx+1,0:ny+1), fbzyij_2D(0:nx+1,0:ny+1),  &
						fbxyijshift_2D(0:nx+1,0:ny+1), fbxyij_2D(0:nx+1,0:ny+1),  &
						fbyyijshift_2D(0:nx+1,0:ny+1), fbyyij_2D(0:nx+1,0:ny+1),  &
!
						forcex_2D(0:nx+1,0:ny+1), forcey_2D(0:nx+1,0:ny+1),  &
						forcez_2D(0:nx+1,0:ny+1)

	real(kind=dkind) :: vdotbishiftj, vdotbijshift, vdotbij,  &
								bsqishiftj, bsqijshift, bsqij

	real(kind=dkind) :: dtx, dty

	integer :: i,j

	dtx=dt/dx
	dty=dt/dy

	! 2/18/2010: inizializations and scalars have been removed
	! to improve parallelization

! first fill in the matrices

!$omp parallel default(shared)
!$omp do private(i,j,vdotbij,vdotbishiftj,vdotbijshift,bsqij,bsqishiftj,bsqijshift)
do j=1,ny
do i=1,nx

!	if(sort_grid(i,j)<=0) cycle

!   GENERATION OF FLUXES 
! 2/18/2010: ALL PARTS TOGETHER!
! 7/26/2010: ADDING RESISTIVITY

	if(ishift/=0) then

	!   momentum fluxes

		fmoxxishiftj_2D(i,j) = p(i+ishift,j)*Rmaj(i) +  &
						rho(i+ishift,j)*u(i+ishift,j)**2*Rmaj(i+ishift)	+  &	!note the "i" index for p!
						(bz(i+ishift,j)**2+by(i+ishift,j)**2+bx(i+ishift,j)**2)/tmu0*Rmaj(i)  &
							- bx(i+ishift,j)**2/rmu0*Rmaj(i+ishift)

		fmoxxij_2D(i,j) = (p(i,j) +rho(i,j)*u(i,j)**2)*Rmaj(i) +  &
									(bz(i,j)**2+by(i,j)**2-bx(i,j)**2)/tmu0 * Rmaj(i)

		fmoyxij_2D(i,j) = rho(i,j)*u(i,j)*v(i,j)*Rmaj(i)  &
									-bx(i,j)*by(i,j)/rmu0 * Rmaj(i)

		fmoyxishiftj_2D(i,j) = rho(i+ishift,j)*u(i+ishift,j)*v(i+ishift,j)*Rmaj(i+ishift)  &
										-bx(i+ishift,j)*by(i+ishift,j)/rmu0 * Rmaj(i+ishift)

		fmozxishiftj_2D(i,j) = rho(i+ishift,j)*w(i+ishift,j)*u(i+ishift,j)*Rmaj(i+ishift)**2  &
										-bx(i+ishift,j)*bz(i+ishift,j)/rmu0 * Rmaj(i+ishift)**2

		fmozxij_2D(i,j) = rho(i,j)*w(i,j)*u(i,j)*Rmaj(i)**2  &
									-bx(i,j)*bz(i,j)/rmu0 * Rmaj(i)**2

	!   energy fluxes

		vdotbij = u(i,j)*bx(i,j)+v(i,j)*by(i,j)+w(i,j)*bz(i,j)
		vdotbishiftj = u(i+ishift,j)*bx(i+ishift,j)+v(i+ishift,j)*by(i+ishift,j)+  &
							w(i+ishift,j)*bz(i+ishift,j)
		bsqij = bx(i,j)**2+by(i,j)**2+bz(i,j)**2
		bsqishiftj = bx(i+ishift,j)**2+by(i+ishift,j)**2+bz(i+ishift,j)**2

		fenxij_2D(i,j) = Rmaj(i)*u(i,j)*(enfl(i,j)+p(i,j)) +  &
										Rmaj(i)*(u(i,j)*bsqij/2.d0-vdotbij*bx(i,j))/rmu0

		fenxishiftj_2D(i,j) = Rmaj(i+ishift)*u(i+ishift,j)*(enfl(i+ishift,j)+p(i+ishift,j)) +  &
								Rmaj(i+ishift)*(u(i+ishift,j)*bsqishiftj/2.d0-vdotbishiftj*bx(i+ishift,j))/rmu0

	!	NOW THE MAGNETIC PART
	!	(PREDICTED MAGNETIC FIELDS ONLY


		fbxxishiftj_2D(i,j) =  - res_coeff(1) * res_eta(i,j,0) * torus * bx(i+ishift,j)/Rmaj(i)  & !notice the index for Rmaj and res_eta!!
								+ res_coeff(2) * res_eta(i,j,2) * by(i+ishift,j) !notice the index for res_eta!!
		fbxxij_2D(i,j) =  - res_coeff(1) * res_eta(i,j,0) * torus * bx(i,j)/Rmaj(i)  &
								+ res_coeff(2) * res_eta(i,j,2) * by(i,j)

		! notice that this term is divided by Rmaj in the time integration part
		fbyxij_2D(i,j) = (u(i,j)*by(i,j)-v(i,j)*bx(i,j))*Rmaj(i)  &
								- res_coeff(1) * res_eta(i,j,0)*torus*by(i,j)  &
								- res_coeff(2) * res_eta(i,j,1) * by(i,j) * Rmaj(i)
		fbyxishiftj_2D(i,j) = (u(i+ishift,j)*by(i+ishift,j)-v(i+ishift,j)*bx(i+ishift,j))*Rmaj(i+ishift)  &
										- res_coeff(1) * res_eta(i,j,0)*torus*by(i+ishift,j)  & !notice the index for res_eta!!
										- res_coeff(2) * res_eta(i,j,1) * by(i+ishift,j) * Rmaj(i) !notice the index for Rmaj and res_eta!!

		fbzxishiftj_2D(i,j) = u(i+ishift,j)*bz(i+ishift,j)-w(i+ishift,j)*bx(i+ishift,j)  &
										- res_coeff(1) * res_eta(i,j,0)*torus*bz(i+ishift,j)/Rmaj(i)  & !notice the index for Rmaj and res_eta!!
										- res_coeff(2) * res_eta(i,j,1)*Rmaj(i+ishift)*bz(i+ishift,j)/Rmaj(i) !notice the index for res_eta!!
		fbzxij_2D(i,j) = u(i,j)*bz(i,j)-w(i,j)*bx(i,j)  &
										- res_coeff(1) * res_eta(i,j,0)*torus*bz(i,j)/Rmaj(i)  &
										- res_coeff(2) * res_eta(i,j,1)*bz(i,j) !!=- res_eta(i,j,1)*Rmaj(i)*bz(i,j)/Rmaj(i)
	endif

	if(jshift/=0) then

	!   momentum fluxes

		fmoxyijshift_2D(i,j) = rho(i,j+jshift)*u(i,j+jshift)*v(i,j+jshift)  &
										-bx(i,j+jshift)*by(i,j+jshift)/rmu0

		fmoxyij_2D(i,j) = rho(i,j)*u(i,j)*v(i,j)  &
									-bx(i,j)*by(i,j)/rmu0

		fmoyyijshift_2D(i,j) = p(i,j+jshift)+rho(i,j+jshift)*v(i,j+jshift)**2 +  &
										(bz(i,j+jshift)**2+bx(i,j+jshift)**2-by(i,j+jshift)**2)/tmu0

		fmoyyij_2D(i,j) = p(i,j)+rho(i,j)*v(i,j)**2 +  &
								(bz(i,j)**2+bx(i,j)**2-by(i,j)**2)/tmu0

		fmozyijshift_2D(i,j) = rho(i,j+jshift)*w(i,j+jshift)*v(i,j+jshift)  &
										-by(i,j+jshift)*bz(i,j+jshift)/rmu0

		fmozyij_2D(i,j) = rho(i,j)*w(i,j)*v(i,j)  &
									-by(i,j)*bz(i,j)/rmu0

	!   energy fluxes

		vdotbij = u(i,j)*bx(i,j)+v(i,j)*by(i,j)+w(i,j)*bz(i,j)
		vdotbijshift = u(i,j+jshift)*bx(i,j+jshift)+v(i,j+jshift)*by(i,j+jshift)+w(i,j+jshift)*bz(i,j+jshift)
		bsqij = bx(i,j)**2+by(i,j)**2+bz(i,j)**2
		bsqijshift = bx(i,j+jshift)**2+by(i,j+jshift)**2+bz(i,j+jshift)**2

		fenyij_2D(i,j) = v(i,j)*(enfl(i,j)+p(i,j)) +  &
								(v(i,j)*bsqij/2.d0-vdotbij*by(i,j))/rmu0

		fenyijshift_2D(i,j) = v(i,j+jshift)*(enfl(i,j+jshift)+p(i,j+jshift)) +  &
										(v(i,j+jshift)*bsqijshift/2.d0-vdotbijshift*by(i,j+jshift))/rmu0

	!	NOW THE MAGNETIC PART
	!	(PREDICTED MAGNETIC FIELDS ONLY

		fbxyijshift_2D(i,j) = v(i,j+jshift)*bx(i,j+jshift)-u(i,j+jshift)*by(i,j+jshift)  &
									- res_coeff(2) * res_eta(i,j,2) * bx(i,j+jshift) !notice the index for res_eta!!
		fbxyij_2D(i,j) = v(i,j)*bx(i,j)-u(i,j)*by(i,j)  &
								- res_coeff(2) * res_eta(i,j,2) * bx(i,j)

		fbyyijshift_2D(i,j) = res_coeff(2) * res_eta(i,j,1) * bx(i,j+jshift) !notice the index for res_eta!!
		fbyyij_2D(i,j) = res_coeff(2) * res_eta(i,j,1) * bx(i,j)

		fbzyijshift_2D(i,j) = v(i,j+jshift)*bz(i,j+jshift)-w(i,j+jshift)*by(i,j+jshift)  &
									- res_coeff(2) * res_eta(i,j,2) * bz(i,j+jshift) !notice the index for res_eta!!
		fbzyij_2D(i,j) = v(i,j)*bz(i,j)-w(i,j)*by(i,j)  &
								- res_coeff(2) * res_eta(i,j,2) * bz(i,j)

	endif



!	forcex_2D(i,j) = -dtx*(fmoxxij_2D(i,j)-fmoxxim1j_2D(i,j))
!	forcey_2D(i,j) =  -dtx*(fmoxyij_2D(i,j)-fmoxyim1j_2D(i,j))
!	forcez_2D(i,j) = -dtx*(fmozxij_2D(i,j)-fmozxim1j_2D(i,j))

	forcex_2D(i,j) = ishift * dtx*(fmoxxij_2D(i,j)-fmoxxishiftj_2D(i,j))/Rmaj(i)  &
							- abs(ishift) * torus * dt*bz(i,j)**2/Rmaj(i)/rmu0   &
							+ abs(ishift) * torus * dt*rho(i,j)*w(i,j)**2/Rmaj(i) +  &
							jshift * dty*(fmoxyij_2D(i,j)-fmoxyijshift_2D(i,j))

	forcey_2D(i,j) =  ishift*dtx*(fmoyxij_2D(i,j)-fmoyxishiftj_2D(i,j))/Rmaj(i) +  &
							jshift * dty*(fmoyyij_2D(i,j)-fmoyyijshift_2D(i,j))

	forcez_2D(i,j) = ishift * dtx*(fmozxij_2D(i,j)-fmozxishiftj_2D(i,j))/Rmaj(i)**2 +  &
							jshift * dty*(fmozyij_2D(i,j)-fmozyijshift_2D(i,j))

enddo
enddo
!$omp enddo
!$omp end parallel

	! now smooth out the peaks

	! momentum
	if(art_diff_option==0) then
		call art_diff_force(dt,dx,dy,nx,ny,forcex_2D,p,rho,u,v,0)
		call art_diff_force(dt,dx,dy,nx,ny,forcey_2D,p,rho,u,v,0)
		call art_diff_force(dt,dx,dy,nx,ny,forcez_2D,p,rho,u,v,0)
	elseif(art_diff_option==1) then
		call art_diff_force_alfven(dt,dx,dy,nx,ny,forcex_2D,p,rho,u,v,bx,by,bz,0)
		call art_diff_force_alfven(dt,dx,dy,nx,ny,forcey_2D,p,rho,u,v,bx,by,bz,0)
		call art_diff_force_alfven(dt,dx,dy,nx,ny,forcez_2D,p,rho,u,v,bx,by,bz,0)
	endif
	! now calculate the predicted variables

!$omp parallel default(shared)
!$omp do private(i,j)
	do j=1,ny
	do i=1,nx

!	if(sort_grid(i,j)<=0) cycle

	!	PREDICTED VARIABLES
	!	rhopr(i,j) =rho(i,j)-dtx*(gx(i,j)-gx(i-1,j))
		rhopr(i,j) = rho(i,j)  &
						+ ishift * dtx*(Rmaj(i)*gx(i,j)-Rmaj(i+ishift)*gx(i+ishift,j))/Rmaj(i)  &
						+ jshift * dty*(gy(i,j)-gy(i,j+jshift))

		gxpr(i,j) = gx(i,j) + forcex_2D(i,j)

		gypr(i,j) = gy(i,j) + forcey_2D(i,j)

		gzpr(i,j) = gz(i,j) + forcez_2D(i,j)

	!	enflpr(i,j)=enfl(i,j)-dtx*(fenxij_2D(i,j)-fenxim1j_2D(i,j))
		enflpr(i,j) = enfl(i,j)  &
						+ ishift*dtx*(fenxij_2D(i,j)-fenxishiftj_2D(i,j))/Rmaj(i)  &
						+ jshift * dty*(fenyij_2D(i,j)-fenyijshift_2D(i,j))


	!	NOW THE MAGNETIC PART
	!	(PREDICTED MAGNETIC FIELDS ONLY)

		bxpr(i,j) = bx(i,j)  &
						+ ishift * dtx*(fbxxij_2D(i,j)-fbxxishiftj_2D(i,j))  &
						- res_coeff(1) * abs(ishift) * torus * res_eta(i,j,0) * dt*bx(i,j)/Rmaj(i)**2  &
						+ jshift * dty*(fbxyij_2D(i,j)-fbxyijshift_2D(i,j))

		bypr(i,j) = by(i,j)  &
						+ ishift * dtx*(fbyxij_2D(i,j)-fbyxishiftj_2D(i,j)) / Rmaj(i)  &
						+ jshift * dty*(fbyyij_2D(i,j)-fbyyijshift_2D(i,j))


		bzpr(i,j) = bz(i,j)  &
						+ ishift * dtx*(fbzxij_2D(i,j)-fbzxishiftj_2D(i,j))  &
						- res_coeff(1) * abs(ishift) * torus * res_eta(i,j,0) * dt*bz(i,j)/Rmaj(i)**2  &
						+ jshift * dty*(fbzyij_2D(i,j)-fbzyijshift_2D(i,j))

		if(res_implicit_option==45) then

			eta_physpr(i,j) = eta_phys(i,j)  &
						+ ishift * dtx*(Rmaj(i)*eta_phys(i,j)*u(i,j)-Rmaj(i+ishift)*eta_phys(i+ishift,j)*u(i+ishift,j))/Rmaj(i)  &
						+ jshift * dty*(eta_phys(i,j)*v(i,j)-eta_phys(i,j+jshift)*v(i,j+jshift))

		endif

	end do
	end do
!$omp enddo
!$omp end parallel
 
	return

end subroutine magnetohydro_pred

