! ********************************************************************************
! magnetohydro_corr::  execute the  corrector step
!
! The corrector variables are :
!   density                             rho 
!	magnetic flux density				bz
!   x-momentum                          gx=rho*u  
!   y-momentum                          gy=rho*v         
!   total energy                        enfl=p/(rsh-1)+rho*(u^2+v^2)/2
! ********************************************************************************
!NOTE: this does the same as ALL Riccardo's various corr_back/forw routines
!NOTE: the predictor routine could also be included here; we keep them separate for clarity

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine magnetohydro_corr(ishift, jshift)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY: dkind, tmu0, rmu0, torus, nx, ny, dx, dy, dt,  &
												art_diff_option, res_coeff
    use mod_arrays,     ONLY: Rmaj, rhopr,bxpr,bypr,bzpr,upr,vpr,wpr,   &
                           ppr,gxpr,gypr,gzpr,enflpr,rho,bx,by,bz,gx,gy,gz,enfl, eta_phys, eta_physpr
	use vacuum_module, only : res_eta, res_implicit_option

	implicit none

	integer, intent(in) :: ishift, jshift
	!VERY IMPORTANT: these two determine the direction!

	real(kind=dkind) :: &
						fmoxxishiftj_2D(0:nx+1,0:ny+1), fmoxxij_2D(0:nx+1,0:ny+1),  &
						fmoxyij_2D(0:nx+1,0:ny+1),													&
						fmoxyijshift_2D(0:nx+1,0:ny+1), fmoyyij_2D(0:nx+1,0:ny+1),  &
						fmoyyijshift_2D(0:nx+1,0:ny+1),											  &
						fmoyxij_2D(0:nx+1,0:ny+1), fmoyxishiftj_2D(0:nx+1,0:ny+1),  &
						fmozxishiftj_2D(0:nx+1,0:ny+1), fmozxij_2D(0:nx+1,0:ny+1),  &
						fmozyijshift_2D(0:nx+1,0:ny+1), fmozyij_2D(0:nx+1,0:ny+1),  &
!
						fenxishiftj_2D(0:nx+1,0:ny+1), fenxij_2D(0:nx+1,0:ny+1),  &
						fenyijshift_2D(0:nx+1,0:ny+1), fenyij_2D(0:nx+1,0:ny+1),  &
!
						fbxxishiftj_2D(0:nx+1,0:ny+1), fbxxij_2D(0:nx+1,0:ny+1),  &
						fbzxishiftj_2D(0:nx+1,0:ny+1), fbzxij_2D(0:nx+1,0:ny+1),  &
						fbyxishiftj_2D(0:nx+1,0:ny+1), fbyxij_2D(0:nx+1,0:ny+1),  &
						fbzyijshift_2D(0:nx+1,0:ny+1), fbzyij_2D(0:nx+1,0:ny+1),  &
						fbxyijshift_2D(0:nx+1,0:ny+1), fbxyij_2D(0:nx+1,0:ny+1),  &
						fbyyijshift_2D(0:nx+1,0:ny+1), fbyyij_2D(0:nx+1,0:ny+1),  &
!
						forcex_2D(0:nx+1,0:ny+1), forcey_2D(0:nx+1,0:ny+1),  &
						forcez_2D(0:nx+1,0:ny+1)

	real(kind=dkind) :: vdotbishiftj, vdotbijshift, vdotbij,  &
								bsqishiftj, bsqijshift, bsqij

	real(kind=dkind) :: dtx, dty

	integer :: i,j

	dtx=dt/dx
	dty=dt/dy

	! 2/18/2010: inizializations and scalars have been removed
	! to improve parallelization

! first fill in the matrices

!$omp parallel default(shared)
!$omp do private(i,j,vdotbij,vdotbishiftj,vdotbijshift,bsqij,bsqishiftj,bsqijshift)
do j=1,ny
do i=1,nx

!	goto 100

!   GENERATION OF FLUXES 
! 2/18/2010: ALL PARTS TOGETHER!
! 7/26/2010: ADDING RESISTIVITY


	if(ishift/=0) then

	!   momentum fluxes

		fmoxxishiftj_2D(i,j) = ppr(i+ishift,j)*Rmaj(i) +  &
						rhopr(i+ishift,j)*upr(i+ishift,j)**2*Rmaj(i+ishift)	+  &	!note the "i" index for p!
						(bzpr(i+ishift,j)**2+bypr(i+ishift,j)**2+bxpr(i+ishift,j)**2)/tmu0*Rmaj(i)  &
							- bxpr(i+ishift,j)**2/rmu0*Rmaj(i+ishift)

		fmoxxij_2D(i,j) = (ppr(i,j) +rhopr(i,j)*upr(i,j)**2)*Rmaj(i) +  &
						(bzpr(i,j)**2+bypr(i,j)**2-bxpr(i,j)**2)/tmu0 * Rmaj(i)

		fmoyxij_2D(i,j) = rhopr(i,j)*upr(i,j)*vpr(i,j)*Rmaj(i)  &
						-bxpr(i,j)*bypr(i,j)/rmu0 * Rmaj(i)

		fmoyxishiftj_2D(i,j) = rhopr(i+ishift,j)*upr(i+ishift,j)*vpr(i+ishift,j)*Rmaj(i+ishift)  &
							-bxpr(i+ishift,j)*bypr(i+ishift,j)/rmu0 * Rmaj(i+ishift)

		fmozxishiftj_2D(i,j) = rhopr(i+ishift,j)*wpr(i+ishift,j)*upr(i+ishift,j)*Rmaj(i+ishift)**2  &
							-bxpr(i+ishift,j)*bzpr(i+ishift,j)/rmu0 * Rmaj(i+ishift)**2

		fmozxij_2D(i,j) = rhopr(i,j)*wpr(i,j)*upr(i,j)*Rmaj(i)**2  &
						-bxpr(i,j)*bzpr(i,j)/rmu0 * Rmaj(i)**2

	!   energy fluxes
		vdotbij = upr(i,j)*bxpr(i,j)+vpr(i,j)*bypr(i,j)+wpr(i,j)*bzpr(i,j)
		vdotbishiftj = upr(i+ishift,j)*bxpr(i+ishift,j)+vpr(i+ishift,j)*bypr(i+ishift,j)+  &
							wpr(i+ishift,j)*bzpr(i+ishift,j)
		bsqij = bxpr(i,j)**2+bypr(i,j)**2+bzpr(i,j)**2
		bsqishiftj = bxpr(i+ishift,j)**2+bypr(i+ishift,j)**2+bzpr(i+ishift,j)**2

		fenxij_2D(i,j) = upr(i,j)*(enflpr(i,j)+ppr(i,j))*Rmaj(i) +  &
					(upr(i,j)*bsqij/2.d0-vdotbij*bxpr(i,j))/rmu0*Rmaj(i)

		fenxishiftj_2D(i,j) = upr(i+ishift,j)*(enflpr(i+ishift,j)+ppr(i+ishift,j))*Rmaj(i+ishift) +  &
							(upr(i+ishift,j)*bsqishiftj/2.d0-vdotbishiftj*bxpr(i+ishift,j))/rmu0*Rmaj(i+ishift)

	!	NOW THE MAGNETIC PART
	!	(CORRECTED MAGNETIC FIELDS ONLY)

		fbzxishiftj_2D(i,j) = upr(i+ishift,j)*bzpr(i+ishift,j)-wpr(i+ishift,j)*bxpr(i+ishift,j)  &
										- res_coeff(1) * res_eta(i,j,0)*torus*bzpr(i+ishift,j)/Rmaj(i)  & !notice the index for Rmaj and res_eta!!
										- res_coeff(2) * res_eta(i,j,1)*Rmaj(i+ishift)*bzpr(i+ishift,j)/Rmaj(i) !notice the index for res_eta!!
		fbzxij_2D(i,j) = upr(i,j)*bzpr(i,j)-wpr(i,j)*bxpr(i,j)  &
										- res_coeff(1) * res_eta(i,j,0)*torus*bzpr(i,j)/Rmaj(i)  &
										- res_coeff(2) * res_eta(i,j,1)*bzpr(i,j) !! =- res_eta(i,j,1)*Rmaj(i)*bz(i,j)/Rmaj(i)

		! notice that this term is divided by Rmaj in the time integration part
		fbyxij_2D(i,j) = (upr(i,j)*bypr(i,j)-vpr(i,j)*bxpr(i,j))*Rmaj(i)  &
								- res_coeff(1) * res_eta(i,j,0)*torus*bypr(i,j)  &
								- res_coeff(2) * res_eta(i,j,1) * bypr(i,j) * Rmaj(i)
		fbyxishiftj_2D(i,j) = (upr(i+ishift,j)*bypr(i+ishift,j)-vpr(i+ishift,j)*bxpr(i+ishift,j))*Rmaj(i+ishift)  &
										- res_coeff(1) * res_eta(i,j,0)*torus*bypr(i+ishift,j)  & !notice the index for res_eta!!
										- res_coeff(1) * res_eta(i,j,1) * bypr(i+ishift,j) * Rmaj(i) !notice the index for Rmaj and res_eta!!

		fbxxishiftj_2D(i,j) =  - res_coeff(1) * res_eta(i,j,0) * torus * bxpr(i+ishift,j)/Rmaj(i)  & !notice the index for Rmaj and res_eta!!
								+ res_coeff(2) * res_eta(i,j,2) * bypr(i+ishift,j) !notice the index for res_eta!!
		fbxxij_2D(i,j) = - res_coeff(1) * res_eta(i,j,0) * torus * bxpr(i,j)/Rmaj(i)  &
								+ res_coeff(2) * res_eta(i,j,2) * bypr(i,j)

	endif

	if(jshift/=0) then

	!   momentum fluxes

		fmoxyijshift_2D(i,j) = rhopr(i,j+jshift)*upr(i,j+jshift)*vpr(i,j+jshift)  &
								-bxpr(i,j+jshift)*bypr(i,j+jshift)/rmu0

		fmoxyij_2D(i,j) = rhopr(i,j)*upr(i,j)*vpr(i,j)  &
						-bxpr(i,j)*bypr(i,j)/rmu0

		fmoyyijshift_2D(i,j) = ppr(i,j+jshift)+rhopr(i,j+jshift)*vpr(i,j+jshift)**2 +  &
								(bzpr(i,j+jshift)**2+bxpr(i,j+jshift)**2-bypr(i,j+jshift)**2)/tmu0

		fmoyyij_2D(i,j) = ppr(i,j)+rhopr(i,j)*vpr(i,j)**2 +  &
						(bzpr(i,j)**2+bxpr(i,j)**2-bypr(i,j)**2)/tmu0

		fmozyijshift_2D(i,j) = rhopr(i,j+jshift)*wpr(i,j+jshift)*vpr(i,j+jshift)  &
								-bypr(i,j+jshift)*bzpr(i,j+jshift)/rmu0

		fmozyij_2D(i,j) = rhopr(i,j)*wpr(i,j)*vpr(i,j)  &
						-bypr(i,j)*bzpr(i,j)/rmu0

	!   energy fluxes

		vdotbij = upr(i,j)*bxpr(i,j)+vpr(i,j)*bypr(i,j)+wpr(i,j)*bzpr(i,j)
		vdotbijshift = upr(i,j+jshift)*bxpr(i,j+jshift)+  &
					vpr(i,j+jshift)*bypr(i,j+jshift)+wpr(i,j+jshift)*bzpr(i,j+jshift)
		bsqij = bxpr(i,j)**2+bypr(i,j)**2+bzpr(i,j)**2
		bsqijshift = bxpr(i,j+jshift)**2+bypr(i,j+jshift)**2+bzpr(i,j+jshift)**2

		fenyij_2D(i,j) = vpr(i,j)*(enflpr(i,j)+ppr(i,j)) +  &
					(vpr(i,j)*bsqij/2.d0-vdotbij*bypr(i,j))/rmu0

		fenyijshift_2D(i,j) = vpr(i,j+jshift)*(enflpr(i,j+jshift)+ppr(i,j+jshift)) +  &
							(vpr(i,j+jshift)*bsqijshift/2.d0-vdotbijshift*bypr(i,j+jshift))/rmu0

	!	NOW THE MAGNETIC PART
	!	(CORRECTED MAGNETIC FIELDS ONLY)

		fbxyijshift_2D(i,j) = vpr(i,j+jshift)*bxpr(i,j+jshift)-upr(i,j+jshift)*bypr(i,j+jshift)  &
									- res_coeff(2) * res_eta(i,j,2) * bxpr(i,j+jshift) !notice the index for res_eta!!
		fbxyij_2D(i,j) = vpr(i,j)*bxpr(i,j)-upr(i,j)*bypr(i,j)  &
								- res_coeff(2) * res_eta(i,j,2) * bxpr(i,j)

		fbzyijshift_2D(i,j) = vpr(i,j+jshift)*bzpr(i,j+jshift)-wpr(i,j+jshift)*bypr(i,j+jshift)  &
									- res_coeff(2) * res_eta(i,j,2) * bzpr(i,j+jshift) !notice the index for res_eta!!
		fbzyij_2D(i,j) = vpr(i,j)*bzpr(i,j)-wpr(i,j)*bypr(i,j)  &
								- res_coeff(2) * res_eta(i,j,2) * bzpr(i,j)

		fbyyijshift_2D(i,j) = res_coeff(2) * res_eta(i,j,1) * bxpr(i,j+jshift) !notice the index for res_eta!!
		fbyyij_2D(i,j) = res_coeff(2) * res_eta(i,j,1) * bxpr(i,j)

	endif

	! 2/18/2010: moving to arrays is not necessary anymore

	forcex_2D(i,j) = ishift * dtx*(fmoxxij_2D(i,j)-fmoxxishiftj_2D(i,j))/Rmaj(i)  &
							- abs(ishift) * torus * dt*bzpr(i,j)**2/Rmaj(i)/rmu0   &
							+ abs(ishift) * torus * dt*rhopr(i,j)*wpr(i,j)**2/Rmaj(i) +  &
							jshift * dty*(fmoxyij_2D(i,j)-fmoxyijshift_2D(i,j))

	forcey_2D(i,j) =  ishift*dtx*(fmoyxij_2D(i,j)-fmoyxishiftj_2D(i,j))/Rmaj(i) +  &
							jshift * dty*(fmoyyij_2D(i,j)-fmoyyijshift_2D(i,j))

	forcez_2D(i,j) = ishift * dtx*(fmozxij_2D(i,j)-fmozxishiftj_2D(i,j))/Rmaj(i)**2 +  &
							jshift * dty*(fmozyij_2D(i,j)-fmozyijshift_2D(i,j))


enddo
enddo
!$omp enddo
!$omp end parallel

	! now smooth out the peaks

	! momentum
	if(art_diff_option==0) then
		call art_diff_force(dt,dx,dy,nx,ny,forcex_2D,ppr,rhopr,upr,vpr,0)
		call art_diff_force(dt,dx,dy,nx,ny,forcey_2D,ppr,rhopr,upr,vpr,0)
		call art_diff_force(dt,dx,dy,nx,ny,forcez_2D,ppr,rhopr,upr,vpr,0)
	elseif(art_diff_option==1) then
		call art_diff_force_alfven(dt,dx,dy,nx,ny,forcex_2D,ppr,rhopr,upr,vpr,bxpr,bypr,bzpr,0)
		call art_diff_force_alfven(dt,dx,dy,nx,ny,forcey_2D,ppr,rhopr,upr,vpr,bxpr,bypr,bzpr,0)
		call art_diff_force_alfven(dt,dx,dy,nx,ny,forcez_2D,ppr,rhopr,upr,vpr,bxpr,bypr,bzpr,0)
	endif

	! now calculate the corrected variables

!$omp parallel default(shared)
!$omp do private(i,j)
	do j=1,ny
	do i=1,nx

		!CORRECTED VARIABLES


!	FIRST THE MAGNETIC PART
!	(CORRECTED MAGNETIC FIELDS ONLY)

		bx(i,j) = bx(i,j)  &
						+ ishift * dtx*(fbxxij_2D(i,j)-fbxxishiftj_2D(i,j))  &
!						- abs(ishift) * torus * res_eta(i,j,0) * dt*bxpr(i,j)/Rmaj(i)**2  &
						+ jshift * dty*(fbxyij_2D(i,j)-fbxyijshift_2D(i,j))

		by(i,j) = by(i,j)  &
						+ ishift * dtx*(fbyxij_2D(i,j)-fbyxishiftj_2D(i,j)) / Rmaj(i)  &
						+ jshift * dty*(fbyyij_2D(i,j)-fbyyijshift_2D(i,j))

		bz(i,j) = bz(i,j)  &
						+ ishift * dtx*(fbzxij_2D(i,j)-fbzxishiftj_2D(i,j))  &
!						- abs(ishift) * torus * res_eta(i,j,0) * dt*bz(i,j)/Rmaj(i)**2  &
						+ jshift * dty*(fbzyij_2D(i,j)-fbzyijshift_2D(i,j))

!	rho(i,j) =rho(i,j)-dtx*(gxpr(i,j)-gxpr(i-1,j))
		rho(i,j) = rho(i,j)  &
						+ ishift * dtx*(Rmaj(i)*gxpr(i,j)-Rmaj(i+ishift)*gxpr(i+ishift,j))/Rmaj(i)  &
						+ jshift * dty*(gypr(i,j)-gypr(i,j+jshift))

		gx(i,j) = gx(i,j) + forcex_2D(i,j)

		gy(i,j) = gy(i,j) + forcey_2D(i,j)

		gz(i,j) = gz(i,j) + forcez_2D(i,j)

	!	enflpr(i,j)=enfl(i,j)-dtx*(fenxij_2D(i,j)-fenxim1j_2D(i,j))
		enfl(i,j) = enfl(i,j)  &
						+ ishift*dtx*(fenxij_2D(i,j)-fenxishiftj_2D(i,j))/Rmaj(i)  &
						+ jshift * dty*(fenyij_2D(i,j)-fenyijshift_2D(i,j))

		if(res_implicit_option==45) then

			eta_phys(i,j) = eta_phys(i,j)  &
						+ ishift * dtx*(Rmaj(i)*eta_physpr(i,j)*upr(i,j)-Rmaj(i+ishift)*eta_physpr(i+ishift,j)*upr(i+ishift,j))/Rmaj(i)  &
						+ jshift * dty*(eta_physpr(i,j)*vpr(i,j)-eta_physpr(i,j+jshift)*vpr(i,j+jshift))

		endif


	end do
	end do
!$omp enddo
!$omp end parallel

	return

end subroutine magnetohydro_corr

