!**************************************************************
! Advance the hydro solution using the
!                      predictor-corrector scheme
!   Variables:
!	The code is written in a conservative form:
!   The primitive variables are:
!	rho =    density
!	bz  =    magnetic flux density
!	u	=    flow velocity in the x-direction
!	v   =    flow velocity in the y-direction
!	p   =    pressure 
!
!   Other quantities: 
!
!   The conservative variables are:
!   x-momentum                          gx=rho*u
!   y-momentum                          gy=rho*v
!   total energy                        enfl=p/(rsh-1)+rho*(u^2+v^2)/2

!
!   Important: rho,u,v,p,gx,gy,enfl are simultaneously used as:
!                                               initial values
!											    corrected values
!											    final values
!
!   The variables ending with "pr" are the predicted variables:
!              rhopr,bzpr,upr,vpr,ppr,gxpr,gypr,enflpr
!****************************************************************************

!    subroutine magnetohydro_all_directions(dt,dx,dy,nx,ny,nmx,nmy)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine magnetohydro_all_directions(i_pred, j_pred, i_corr, j_corr)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, only :dkind,  source_option, nx, ny, dx, dy, dt, divB_option
	use mod_arrays, only : nmx,nmy,rho,bx,by,bz,u,v,w,p, rhopr, bxpr, bypr, bzpr, gx, gxpr,  &
											gy, gypr, gz, gzpr, upr, vpr, wpr, ppr, enfl, enflpr, eta_phys, eta_physpr
	use boundary_routines, only : boundary_vacuum_field_copy

	implicit none

	integer :: i_pred, j_pred, i_corr, j_corr
	! these control the direction:
	! 1-> forward, -1->backward
	! the code is set to run with alternate directions (only one index at a time is nonzero)
	logical, save :: boundary_copy = .true.

!	call write_mom_x(rho(0:nx+1,0:ny+1),u(0:nx+1,0:ny+1),v(0:nx+1,0:ny+1),w(0:nx+1,0:ny+1),  &
!									p(0:nx+1,0:ny+1),bx(0:nx+1,0:ny+1),by(0:nx+1,0:ny+1),bz(0:nx+1,0:ny+1))


! PREDICTOR STEP

	if((boundary_copy).or.(divB_option==3).or.(divB_option==4)) then
		call boundary_vacuum_field_copy(bxpr(0:nx+1,0:ny+1), bypr(0:nx+1,0:ny+1), bzpr(0:nx+1,0:ny+1))
		! in principle, this should be necessary only at the first iteration
		boundary_copy = .false.
	endif

!	print*, 'entering MHD_all_dir'

     call conservative_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)

	call magnetohydro_pred(i_pred,j_pred)

	call primitive_var(rhopr,gxpr,gypr,gzpr,enflpr,upr,vpr,wpr,ppr,bxpr,bypr,bzpr)

	if(source_option>0) then
		call momentum_source(rhopr,bxpr,bypr,bzpr,upr,vpr,wpr,ppr)
	endif

	call boundary(nx,ny,nmx,nmy,upr,vpr,wpr,rhopr,bxpr,bypr,bzpr,ppr,eta_physpr)

!	call write_predictor(rhopr(0:nx+1,0:ny+1),upr(0:nx+1,0:ny+1),vpr(0:nx+1,0:ny+1),wpr(0:nx+1,0:ny+1),  &
!									ppr(0:nx+1,0:ny+1),bxpr(0:nx+1,0:ny+1),bypr(0:nx+1,0:ny+1),bzpr(0:nx+1,0:ny+1))

!	print*, 'predictor step done'

! END PREDICTOR STEP

! CORRECTOR STEP

     call conservative_var(rhopr,gxpr,gypr,gzpr,enflpr,upr,vpr,wpr,ppr,bxpr,bypr,bzpr) 

	call magnetohydro_corr(i_corr,j_corr)


!	call primitive_var(nx,ny,nmx,nmy,rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)
!
!	call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p)
!
!	call write_corrector(rho(0:nx+1,0:ny+1),u(0:nx+1,0:ny+1),v(0:nx+1,0:ny+1),w(0:nx+1,0:ny+1),  &
!									p(0:nx+1,0:ny+1),bx(0:nx+1,0:ny+1),by(0:nx+1,0:ny+1),bz(0:nx+1,0:ny+1))

!	print*, 'corrector step done'

	call average_var

	call primitive_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)

	if(source_option>0) then
		call momentum_source(rho,bx,by,bz,u,v,w,p)
	endif

	call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

!	call write_mom_x(rho(0:nx+1,0:ny+1),u(0:nx+1,0:ny+1),v(0:nx+1,0:ny+1),w(0:nx+1,0:ny+1),  &
!									p(0:nx+1,0:ny+1),bx(0:nx+1,0:ny+1),by(0:nx+1,0:ny+1),bz(0:nx+1,0:ny+1))

!	call write_corrector(rho(0:nx+1,0:ny+1),u(0:nx+1,0:ny+1),v(0:nx+1,0:ny+1),w(0:nx+1,0:ny+1),  &
!									p(0:nx+1,0:ny+1),bx(0:nx+1,0:ny+1),by(0:nx+1,0:ny+1),bz(0:nx+1,0:ny+1))

! END CORRECTOR STEP

!	print*, 'exiting MHD_all_dir'

	return

end subroutine magnetohydro_all_directions

