!*********************************************************************
!  magnetohydro:  calls the predictor-corrector
!          subroutines using alternate directions
!*********************************************************************


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine magnetohydro(icycle)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY: dx,dy,dt,nx,ny,source_option, i_oper_splitting, boundary_option
	use mod_arrays,     ONLY: nmx,nmy,rho,bx,by,bz,u,v,w,p,eta_phys

	implicit none

	integer :: icycle
!	print*, 'calling boundary'

    call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)


!	 	call write_mom_x(rho(0:nx+1,0:ny+1),u(0:nx+1,0:ny+1),v(0:nx+1,0:ny+1),w(0:nx+1,0:ny+1),  &
!									p(0:nx+1,0:ny+1),bx(0:nx+1,0:ny+1),by(0:nx+1,0:ny+1),bz(0:nx+1,0:ny+1))


	if(i_oper_splitting) then

	    if(modulo(icycle,2)==1) then
		! the cycle number is odd


		! use forward-backward scheme if icycle is odd

			call magnetohydro_all_directions(0, -1, 0, 1)
			call magnetohydro_all_directions(1, 0, -1, 0)

		elseif(modulo(icycle,2)==0) then
		! the cycle number is even

		! use backward-forward scheme if icycle is even
			call magnetohydro_all_directions(-1, 0, 1, 0)
			call magnetohydro_all_directions(0, 1, 0, -1)

		endif

	else

	! distinguish four different possibilities

	    if(modulo(icycle,4)==1) then
		! the cycle number is 4n+1

			call magnetohydro_all_directions(1, -1, 1, -1)

	    elseif(modulo(icycle,4)==2) then
		! the cycle number is 4n+2

			call magnetohydro_all_directions(-1, 1, 1, -1)

	    elseif(modulo(icycle,4)==3) then
		! the cycle number is 4n+3

			call magnetohydro_all_directions(1, -1, -1, 1)

	    elseif(modulo(icycle,4)==0) then
		! the cycle number is 4n

			call magnetohydro_all_directions(-1,1, -1, 1)

		endif

	endif

	if((boundary_option==14).or.(boundary_option==15).or.(boundary_option==16)) then
	!outflow boundary condition: recycling is needed
		call mass_recycling
	endif

     call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

!	 	call write_mom_x(rho(0:nx+1,0:ny+1),u(0:nx+1,0:ny+1),v(0:nx+1,0:ny+1),w(0:nx+1,0:ny+1),  &
!									p(0:nx+1,0:ny+1),bx(0:nx+1,0:ny+1),by(0:nx+1,0:ny+1),bz(0:nx+1,0:ny+1))

	call auxiliary

	if(source_option<0) then
		call momentum_source(rho,bx,by,bz,u,v,w,p)
	     call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)
	endif



end subroutine magnetohydro

