!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine ludcmp(a,n,np,indx,d)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

! Given a matrix a(1:n,1:n), with physical dimension np by np, this routine replaces it by 
! the LU decomposition of a row-wise permutation of itself. a and n arei nput. a is output, 
! arranged as in equation (2.3.14) above; indx(1:n) is an output vector that records the 
! row permutation eﬀected by the partial pivoting; d is output as 
! ±1depending on whether 
! the number of row interchanges was even or odd, respectively. This routine is used in 
! combination with lubksb to solve linear equations or invert a matrix.

	use mod_parameters, only : dkind

	implicit none

	integer, parameter :: nmax=1000
	real(kind=dkind), parameter :: tiny=1.0d-20

	integer :: n, np
	real(kind=dkind) :: a(np,np),vv(nmax)
	integer :: indx(n)

	real(kind=dkind) :: d, aamax, sum, dum
	integer :: i,j,k, imax

	d=1.d0

	do i=1,n

		aamax=0.d0

		do j=1,n
			if (abs(a(i,j)).gt.aamax) aamax=abs(a(i,j))
		enddo

		if (aamax.eq.0.d0) pause 'singular matrix.'
		vv(i)=1.d0/aamax

	enddo

	do j=1,n

		if (j.gt.1) then

			do i=1,j-1

				sum=a(i,j)

				if (i.gt.1)then
					do k=1,i-1
						sum=sum-a(i,k)*a(k,j)
					enddo
					a(i,j)=sum
				endif

			enddo

		endif

		aamax=0.d0

		do i=j,n

			sum=a(i,j)

			if (j.gt.1)then

				do k=1,j-1
					sum=sum-a(i,k)*a(k,j)
				enddo

				a(i,j)=sum

			endif

			dum=vv(i)*abs(sum)

			if (dum.ge.aamax) then
				imax=i
				aamax=dum
			endif

		enddo

		if (j.ne.imax)then

			do k=1,n
				dum=a(imax,k)
				a(imax,k)=a(j,k)
				a(j,k)=dum
			enddo

			d=-d
			vv(imax)=vv(j)

		endif

		indx(j)=imax

		if(j.ne.n)then

			if(a(j,j).eq.0.d0)a(j,j)=tiny
			dum=1./a(j,j)

			do i=j+1,n
				a(i,j)=a(i,j)*dum
			enddo

		endif

	enddo

	if(a(n,n).eq.0.d0)a(n,n)=tiny

	return

end subroutine ludcmp

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine lubksb(a,n,np,indx,b)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

! Solves the set of n linear equationsA·X=B. Here a is input, not as the matrix A but 
! rather as its LU decomposition, determined by the routine ludcmp. indx is input as the 
! permutation vector returned by ludcmp. b(1:n) is input as the right-hand side vector B,
! and returns with the solution vector X. a, n, np, and indx are not modiﬁed by this routine 
! and can be left in place for successive calls with diﬀerent right-hand sides b. This routine 
! takes into account the possibility that b will beginwith many zero elements, so it is eﬃcient 
! for use in matrix inversion.

	use mod_parameters, only : dkind

	implicit none

	integer :: n, np
	integer :: indx(n)
	real(kind=dkind) :: a(np,np),b(n)
	real(kind=dkind) :: sum
	integer :: i, j, ii, ll

	ii=0
	do 12 i=1,n
	ll=indx(i)
	sum=b(ll)
	b(ll)=b(i)
	if (ii.ne.0)then
	do 11 j=ii,i-1
	sum=sum-a(i,j)*b(j)
	11        continue
	else if (sum.ne.0.d0) then
	ii=i
	endif
	b(i)=sum
	12    continue
	do 14 i=n,1,-1
	sum=b(i)
	if(i.lt.n)then
	do 13 j=i+1,n
	sum=sum-a(i,j)*b(j)
	13        continue
	endif
	b(i)=sum/a(i,i)
	14    continue

return

end subroutine lubksb

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine lnsrch(n,xold,fold,g,p,x,f,stpmax,check,func)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind

	implicit none

	INTEGER n
	LOGICAL check
	REAL(kind=dkind) f,fold,stpmax,g(n),p(n),x(n),xold(n),func,ALF,TOLX
	PARAMETER (ALF=1.d-4,TOLX=1.d-7)
	EXTERNAL func
!	CU    USES func
	INTEGER i
	REAL(kind=dkind) a,alam,alam2,alamin,b,disc,f2,fold2,rhs1,rhs2,slope,sum,temp,  &
					test,tmplam

	check=.false.
	sum=0.d0
	do 11 i=1,n
	sum=sum+p(i)*p(i)
11    continue
	sum=sqrt(sum)
	if(sum.gt.stpmax)then
	do 12 i=1,n
	  p(i)=p(i)*stpmax/sum
12      continue
	endif
	slope=0.d0
	do 13 i=1,n
	slope=slope+g(i)*p(i)
13    continue
	test=0.d0
	do 14 i=1,n
	temp=abs(p(i))/max(abs(xold(i)),1.d0)
	if(temp.gt.test)test=temp
14    continue
	alamin=TOLX/test
	alam=1.d0
	1     continue
	do 15 i=1,n
	  x(i)=xold(i)+alam*p(i)
15      continue
	f=func(x)
	if(alam.lt.alamin)then
	  do 16 i=1,n
		x(i)=xold(i)
16        continue
	  check=.true.
	  return
	else if(f.le.fold+ALF*alam*slope)then
	  return
	else
	  if(alam.eq.1.d0)then
		tmplam=-slope/(2.d0*(f-fold-slope))
	  else
		rhs1=f-fold-alam*slope
		rhs2=f2-fold2-alam2*slope
		a=(rhs1/alam**2-rhs2/alam2**2)/(alam-alam2)
		b=(-alam2*rhs1/alam**2+alam*rhs2/alam2**2)/(alam-alam2)
		if(a.eq.0.d0)then
		  tmplam=-slope/(2.d0*b)
		else
		  disc=b*b-3.d0*a*slope
		  if(disc.lt.0.d0) pause 'roundoff problem in lnsrch'
		  tmplam=(-b+sqrt(disc))/(3.d0*a)
		endif
		if(tmplam.gt..5d0*alam)tmplam=.5d0*alam
	  endif
	endif
	alam2=alam
	f2=f
	fold2=fold
	alam=max(tmplam,.1d0*alam)
	goto 1

end subroutine lnsrch


