!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine initial
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, nx,ny,dx,dy,xlength,ylength,  &
												numerical_input_option, boundary_option,  &
												vacuum_region, conservation_file

    use mod_arrays,     ONLY:nmx,nmy,rho,bx,by,bz,u,v,w,p,yv,eta_phys

	use numerical_input, only : numerical_equilibrium, FLOW_equilibrium
	use GS_equilibrium, only : GS_solution

	use boundary_routines, only : sort_grid, set_current, set_boundary_square, set_boundary_vacuum, set_boundary_values

	use vacuum_module, only : nil_vacuum, set_vacuum

	implicit none

	logical :: integral_file, database_file
	real(kind=dkind) :: dummkopf
	integer :: visit_file = 75

	call set_boundary_values

	if(vacuum_region==0) then
		call nil_vacuum
	elseif(vacuum_region==1) then
		call set_vacuum
	endif

	if(allocated(sort_grid)) then
		continue
	else
		if(vacuum_region==0) then
			call set_boundary_square(nx,ny)
		else
			call set_boundary_vacuum
		endif
		if(boundary_option<0) call set_current
	endif


	inquire(file='conservation_integrals.dat', exist=integral_file)

	open(conservation_file, file='conservation_integrals.dat')

	! open file for conservation integrals
	if(integral_file) then
	
		do

			read(conservation_file,111,end=69) dummkopf, dummkopf, dummkopf, dummkopf, dummkopf, dummkopf

		enddo

		69 write(conservation_file,*) '       '

	else

		write(conservation_file,*) '     '

	endif

	! open file for visit database
	inquire(file='database_SIM2D.visit', exist=database_file)

	open(visit_file, file='database_SIM2D.visit')

	if(database_file) then
	
		continue

	else

		write(visit_file,200) '!NBLOCKS 1'

	endif

	close(visit_file)

	! second visit file
	inquire(file='short_database_SIM2D.visit', exist=database_file)

	open(visit_file, file='short_database_SIM2D.visit')

	if(database_file) then
	
		continue

	else

		write(visit_file,200) '!NBLOCKS 1'

	endif

	close(visit_file)

	if (numerical_input_option==0) then
		return
	elseif (numerical_input_option==1) then
		call numerical_equilibrium
		print*, 'reading cylindrical equilibrium'
	elseif(numerical_input_option == 2) then
		call FLOW_equilibrium
		print*, 'reading FLOW equilibrium'
	elseif((numerical_input_option == 3).or.(numerical_input_option == 4).or.  &
				(numerical_input_option == 5).or.(numerical_input_option==6).or.  &
				(abs(numerical_input_option)==7).or.(numerical_input_option==8).or.  &
				(numerical_input_option==9)) then
		call GS_solution
	endif


    call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

111 format(6(e15.9, 3x))
200 format((a10))

end  subroutine initial

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine div_init_cycle
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	! run some divergence to get things "straight"

	use mod_parameters, only : dkind, nx, ny, divergence_init, divergence_tolerance
    use mod_arrays,     ONLY:nmx,nmy,rho,bx,by,bz,u,v,w,p,yv,eta_phys

	implicit none

	real(kind=dkind) :: divB_err, divB_tol_init
	integer :: divB_ite


	divB_err = 1.d1
	divB_ite = 0
	divB_tol_init = min(divergence_tolerance*1.d-3,2.d-8)

	do while((divB_err>divB_tol_init).and.(divB_ite<=100))
		call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)
		call divergence_B(bx,by,0,divB_err,0.d0)
		divB_ite = divB_ite + 1
	enddo

	print*, 'initial divergence of B:', divB_err
	divergence_init = .false.

    call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

end subroutine div_init_cycle


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine initial_velocity
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
! given an equilibrium at t=0, overwrites the velocity field with an assigned function of position

	use mod_parameters, only : dkind, nx, ny, rsh, rsource_min, rsource_max
	use mod_arrays, only : rho, p, u, v, w, bx, by, bz
	use GS_equilibrium, only : mach_theta_option, mach_theta_edge, mach_theta_max
	use vacuum_module, only : edge_distance

	implicit none

	real(kind=dkind) :: rloc, Csp, Mach, Bpol
	integer :: i, j

	do j = 1, ny
	do i = 1, nx

		if(mach_theta_option==-1) then

			rloc = edge_distance(i,j)

			if((rloc<rsource_min).or.(rloc>rsource_max)) cycle

			if(rloc>0.d0) then
			! external point

				Mach = mach_theta_edge - (rsource_max-rloc)/rsource_max * (mach_theta_edge-mach_theta_max)

			elseif(rloc<0.d0) then
			! internal point

				Mach = mach_theta_max * (1.d0 - rloc/rsource_min)

			endif

			Bpol = sqrt(bx(i,j)**2+by(i,j)**2)
			Csp = sqrt( (rsh*p(i,j)/rho(i,j)) / (bx(i,j)**2+by(i,j)**2+bz(i,j)**2) ) * Bpol

			u(i,j) = Mach * Csp * bx(i,j)/Bpol
			v(i,j) = Mach * Csp * by(i,j)/Bpol

		endif

	enddo
	enddo

	continue

	return

end subroutine initial_velocity