!**************************************************************************
! Subroutine Conservative_var generates conservative variables
!                             from primitive variables
!
!   The conservative variables are: 
!   x-momentum                          gx=rho*u  
!   y-momentum                          gy=rho*v         
!   total energy                        enfl=p/(rsh-1)+rho*(u^2+v^2)/2
!****************************************************************************

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine conservative_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz) 
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
	 
	use mod_parameters, ONLY: dkind, rsh,tmu0, nx, ny
	use mod_arrays, only : nmx, nmy

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rho, gx, gy, gz, enfl, u, v, w, p, bx, by, bz
	integer :: i, j

!$omp parallel default(shared)
!$omp do private(i,j)
	do  j=0,ny+1
    do  i=0,nx+1

    gx(i,j)=rho(i,j)*u(i,j)
	gy(i,j)=rho(i,j)*v(i,j)
 	gz(i,j)=rho(i,j)*w(i,j)

	enfl(i,j)=p(i,j)/(rsh-1.d0)+0.5d0*rho(i,j)*(u(i,j)**2+v(i,j)**2+w(i,j)**2) &
	          +(bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/tmu0

!	rhopsi(i,j)=psi(i,j)*rho(i,j)

	end do
	end do
!$omp enddo
!$omp end parallel

	return

end  subroutine conservative_var
