!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

	use mod_parameters, ONLY:  dkind, torus, boundary_option, vacuum_region

	use boundary_routines, only : sort_grid,  &
								boundary_reflect_square_two, set_boundary_square,  &
								set_boundary_vacuum, boundary_reflect_square,  &
								boundary_reflect_square_vortex_model,  &
								set_current, boundary_reflect_square_current,  &
								boundary_reflect_square_rhoflat, boundary_vacuum_0,  &
								boundary_vacuum_1, boundary_vacuum_vn0,  &
								boundary_vacuum_CS, boundary_vacuum_CS_2, boundary_vacuum_CS_3

	implicit none

	integer :: nmx, nmy, nx, ny
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rho, p, bx, by, bz, u, v, w, eta_phys

	continue

	if(allocated(sort_grid)) then
		continue
	else
		if(vacuum_region==0) then
			call set_boundary_square(nx,ny)
		else
			call set_boundary_vacuum
		endif
		if(boundary_option<0) call set_current
	endif

	if(vacuum_region==0) then
	! plasma only

		if((boundary_option==0).or.(boundary_option==4).or.(boundary_option==5)) then
		! gridless options (boundary_option==4,5) have been removed
			call boundary_reflect_square(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==1) then
			call boundary_reflect_square_two(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==3) then
			call boundary_reflect_square_vortex_model(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==6) then
			call boundary_reflect_square_rhoflat(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif((boundary_option==-1).or.(boundary_option==-4).or.(boundary_option==-5)) then
			call boundary_reflect_square_current(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		endif

	elseif(vacuum_region==1) then
	! plasma and vacuum

		if(boundary_option==10) then
			call boundary_vacuum_0(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==11) then
			call boundary_vacuum_1(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==12) then
			call boundary_vacuum_vn0(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==13) then
			call boundary_reflect_square_rhoflat(nx,ny,nmx,nmy,u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==14) then
			call boundary_vacuum_CS(u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==15) then
			call boundary_vacuum_CS_2(u,v,w,rho,p,bx,by,bz)
		elseif(boundary_option==16) then
			call boundary_vacuum_CS_3(u,v,w,rho,p,bx,by,bz,eta_phys)
		else
			print*, 'error in boundary option: boundary_option = ', boundary_option
		endif

	endif



    return

end subroutine boundary
