!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine auxiliary
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, only : dkind, nx, ny, dt, dx, dy, art_diff_option, boundary_option, timen, t_smooth,  &
												dt_smooth, smoothing_option, divB_option, source_type, run_source,  &
												poloidal_momentum, poloidal_momentum_0

	use mod_arrays, only : nmx,nmy,rho,bx,by,bz,u,v,w,p, eta_phys

	implicit none

	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) ::  gx, gy, gz, enfl
 	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: ptemp, rhotemp
    logical :: ieven, iodd	! define if needed!
	real(kind=dkind) :: divB_err
	integer :: divB_ite

	ptemp(:,:) = p(:,:)
	rhotemp(:,:) = rho(:,:)

	if((art_diff_option==0).or.(art_diff_option==2).or.(art_diff_option==4)) then

		!$omp parallel default(shared)
		!$omp sections

		!$omp section
		 call art_dif_peaks_nn(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,0) !,1)

		!$omp section
		 call art_dif_peaks_nn(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,0) !,1)

		!$omp section
		 call art_dif_peaks_nn(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,0) !,1)

		!$omp section
		 call art_dif_peaks_nn(dt,dx,dy,nx,ny,eta_phys,ptemp,rhotemp,u,v,0) !,1)

		!$omp end sections
		!$omp end parallel

	elseif((art_diff_option==1).or.(art_diff_option==3).or.(art_diff_option==5)) then

		!$omp parallel default(shared)
		!$omp sections

		!$omp section
		call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,rho,ptemp,rhotemp,u,v,bx,by,bz,0)

		!$omp section
		 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,p,ptemp,rhotemp,u,v,bx,by,bz,0)

		!$omp section
		 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,w,ptemp,rhotemp,u,v,bx,by,bz,0)

		!$omp section
		 call art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,eta_phys,ptemp,rhotemp,u,v,bx,by,bz,0)

		!$omp end sections
		!$omp end parallel

	endif

     call art_cond(dt,dx,dy,nx,ny,nmx,nmy,rho,p,enfl)

     call conservative_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)

     call art_visc_Alfven(gx,gy,enfl)

     call primitive_var(rho,gx,gy,gz,enfl,u,v,w,p,bx,by,bz)

    call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)


	if(abs(boundary_option)==4) then
	! gridless options (boundary_option==4,5) have been removed
		divB_err = 1.d1; divB_ite = 0
		do while((divB_err>1.d-4).and.(divB_ite<100))
			call divergence_B(bx,by,1,divB_err,timen)
			call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)
			divB_ite = divB_ite+1
		enddo
	else
		call divergence_B(bx,by,1,divB_err,timen)
	endif

    call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)

	if ((smoothing_option>=0).and.((timen >= dt_smooth).and.(timen >= t_smooth))) then
		call smoothing_cycle
		t_smooth = t_smooth + dt_smooth
	endif

	if((source_type<0).and.((timen >= dt_smooth).and.(timen >= t_smooth))) then
	! use dt_smooth as check interval for source

		call poloidal_momentum_integral

		if((poloidal_momentum>1.1d0*poloidal_momentum_0).and.(run_source)) then
			run_source = .false.
		elseif(poloidal_momentum<0.9d0*poloidal_momentum_0) then
			if(run_source) then
				continue
			else
				run_source = .true.
			endif
		endif

	endif

	 return

end subroutine auxiliary