!****************************************************************************************
! art_visc::   calculate the correction to the momemtum and fluid energy
!                   produced by two explicit artificial viscosity terms
! 
!
!              The term with av1 is proportional to dx,dy and the velocity
!              The term with av2 is proportional to dx^2, dy^2 and velocity gradients
!
!              The term with v_shear introduce shear viscosity (default should be zero)
!****************************************************************************************


!-------------------------------------------------------------------------------------------

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine art_visc_Alfven(gxn, gyn, enfln)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
! same as before, without passing arrays

	use mod_parameters, ONLY: dkind, v_shear,art_visc1,art_visc2, &
		                      art_visc_sound_1,art_visc_sound_2, v_shear_edge, v_shear_exponent,  &
							  dt,dx,dy,nx,ny, xlength, ylength, rmu0

	use mod_arrays, only : nmx,nmy, xV, yV, Rmaj,  &
										rho, u, v, bx, by, bz

	use boundary_routines, only : sort_grid


	Implicit none
	 
	real(kind=dkind):: enfln(0:nmx+1,0:nmy+1),   &
			    gxn(0:nmx+1,0:nmy+1),gyn(0:nmx+1,0:nmy+1)

	real(kind=dkind):: p(0:nmx+1,0:nmy+1)

	integer :: i,j

	real(kind=dkind) :: cs0, edge_factor, rloc, v_shear_loc
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j, csij,csijp1,csip1j,csim1j,csijm1, dtx, dty, av_1, av_2, avs_1, avs_2
	real(kind=dkind) :: 	dcsdxij, dcsdxim1j,	dcsdyij, dcsdyijm1,	dcsdxip1j, dcsdyijp1, dudxim1j,  &
									dudxip1j, dudxij, dudyij, dudyijm1, dudyijp1, dudyip1j, dudyim1j,  &
									dvdyijm1, dvdyijp1, dvdyij, dvdxij, dvdxim1j, dvdxip1j, dvdxijp1, dvdxijm1,  &
									omij, omijp1, omijm1, omip1j, omim1j, ds, a_dudxip1j, a_dvdyijp1,  &
									a_dudxim1j, a_dvdyijm1, a_uip1j, a_vijp1, a_uim1j, a_vijm1, a_csip1j, a_csijp1,  &
									a_csim1j, a_csijm1, a_dcsdxip1j, a_dcsdyijp1, a_dcsdxim1j, a_dcsdyijm1,  &
									a_csgrad_ij, rnuxim1j, rnuyijm1, rnuxip1j, rnuyijp1, wxyijp1, wxyijm1, wyxim1j, wyxip1j,  &
									wxxip1j, wxxim1j, wyyijm1, wyyijp1, fenxim1j, fenxip1j, fenyijm1, fenyijp1
								
	if(art_visc1==0d0.and.art_visc2==0d0.and.&
		art_visc_sound_1==0.d0.and.art_visc_sound_2==0.d0.and.v_shear==0.d0)return

    dtx=dt/dx
	dty=dt/dy
	av_1=art_visc1
    av_2=art_visc2
	avs_1=art_visc_sound_1
	avs_2=art_visc_sound_2


do  j=0,ny+1
do  i=0,nx+1

	p(i,j) = (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/rmu0

enddo
enddo

!	print*, 'cs_0^2 = ', p(nx/2,ny/2)/rho(nx/2,ny/2)
	cs0 = dsqrt(p(nx/2,ny/2)/rho(nx/2,ny/2))

!!!$omp parallel default(private) shared(p, rho, u, v, gxn, gyn, enfln)
!!!$omp do private(i,j)
do  j=1,ny
do  i=1,nx

	if(sort_grid(i,j)<=0) cycle

!	rloc = sqrt((xV(i)-0.5d0)**2+(yV(j)-0.5d0)**2)

!	edge_factor = (1.d0 + v_shear_edge*(rloc/0.5d0)**v_shear_exponent)

	rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
	edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)

!	v_shear_loc = v_shear * (1.d0 + (rloc/0.5d0)**12)

	! enhance all viscosity next to the edge
!	av_1=art_visc1 *edge_factor
!    av_2=art_visc2 *edge_factor
!	avs_1=art_visc_sound_1 *edge_factor
!	avs_2=art_visc_sound_2 *edge_factor
	v_shear_loc = v_shear *edge_factor
	
!!$	print*, p(i,j), rho(i,j), u(i,j),v(i,j)
!!$	print*, rloc, edge_factor, v_shear_loc

! Temperatures using ideal gas equation of state :: T = p*An/rho
	tij=     p(i,j)/rho(i,j)
    tijp1=   p(i,j+1)/rho(i,j+1)
	tijm1=   p(i,j-1)/rho(i,j-1)
	tip1j=   p(i+1,j)/rho(i+1,j)
	tim1j=   p(i-1,j)/rho(i-1,j)
	
!!$	print*, tij,tijp1,tijm1,tip1j,tim1j

! Sound speed
	csij=    dsqrt(max(tij,0.d0))
    csijp1=  dsqrt(max(tijp1,0.d0))
    csip1j=  dsqrt(max(tip1j,0.d0))
	csim1j=  dsqrt(max(tim1j,0.d0))
	csijm1=  dsqrt(max(tijm1,0.d0))
	
!!$	print*, csij, csijp1,  csip1j,	csim1j,csijm1

!	csij=    dsqrt(tij)
!    csijp1=  dsqrt(tijp1)
!   csip1j=  dsqrt(tip1j)
!	csim1j=  dsqrt(tim1j)
!	csijm1=  dsqrt(tijm1)

! Sound speed gradients
	dcsdxij=      0.5*(csip1j-csim1j)
	dcsdxim1j=         csij-csim1j
	dcsdyij=      0.5*(csijp1-csijm1)
	dcsdyijm1=         csij-csijm1
	dcsdxip1j=         csip1j-csij
    dcsdyijp1=         csijp1-csij

!!$ print*, dcsdxij, dcsdxim1j, 	dcsdyij, dcsdyijm1, dcsdxip1j,   dcsdyijp1

!  Velocity gradients

	dudxim1j=u(i,j)-u(i-1,j)
	dudxip1j=u(i+1,j)-u(i,j)
	dudxij=0.5*(u(i+1,j)-u(i-1,j))
	dudyij=0.5*(u(i,j+1)-u(i,j-1))
	dudyijm1=u(i,j)-u(i,j-1)
	dudyijp1=u(i,j+1)-u(i,j)
	dudyip1j=0.25*(u(i+1,j+1)-u(i+1,j-1))+0.25*(u(i,j+1)-u(i,j-1))
	dudyim1j=0.25*(u(i-1,j+1)-u(i-1,j-1))+0.25*(u(i,j+1)-u(i,j-1))

!!$ print*, dudxim1j, dudxip1j, dudxij, 	dudyij, dudyijm1, dudyijp1, dudyip1j, dudyim1j

	dvdyijm1=v(i,j)-v(i,j-1)
	dvdyijp1=v(i,j+1)-v(i,j)
	dvdyij=0.5*(v(i,j+1)-v(i,j-1))
	dvdxij=0.5*(v(i+1,j)-v(i-1,j))
    dvdxim1j=v(i,j)-v(i-1,j)
	dvdxip1j=v(i+1,j)-v(i,j)
	dvdxijp1=0.25*(v(i+1,j+1)-v(i-1,j+1))+0.25*(v(i+1,j)-v(i-1,j))
	dvdxijm1=0.25*(v(i+1,j-1)-v(i-1,j-1))+0.25*(v(i+1,j)-v(i-1,j))

!!$ print*, 	dvdyijm1, 	dvdyijp1, 	dvdyij, dvdxij,     dvdxim1j, dvdxip1j, dvdxijp1, 	dvdxijm1


	omij=dudyij/dy-dvdxij/dx
	omijp1=dudyijp1/dy-dvdxijp1/dx
	omijm1=dudyijm1/dy-dvdxijm1/dx
	omip1j=dudyip1j/dy-dvdxip1j/dx
	omim1j=dudyim1j/dy-dvdxim1j/dx
	ds=dsqrt(dx**2+dy**2)

!!$ print*, omij,omijp1,omijm1, omip1j, omim1j,ds

	a_dudxip1j=dabs(dudxip1j)
	a_dvdyijp1=dabs(dvdyijp1)
	a_dudxim1j=dabs(dudxim1j)
	a_dvdyijm1=dabs(dvdyijm1)
	a_uip1j=0.5*dabs(u(i,j)+u(i+1,j))
	a_vijp1=0.5*dabs(v(i,j)+v(i,j+1))
	a_uim1j=0.5*dabs(u(i,j)+u(i-1,j))
	a_vijm1=0.5*dabs(v(i,j)+v(i,j-1))
	a_csip1j=0.5*dabs(csij+csip1j)
	a_csijp1=0.5*dabs(csij+csijp1)
	a_csim1j=0.5*dabs(csij+csim1j)
	a_csijm1=0.5*dabs(csij+csijm1)
	a_dcsdxip1j=dabs(dcsdxip1j)
	a_dcsdyijp1=dabs(dcsdyijp1)
	a_dcsdxim1j=dabs(dcsdxim1j)
	a_dcsdyijm1=dabs(dcsdyijm1)

	a_csgrad_ij=dsqrt((dcsdxij/dx)**2+(dcsdyij/dy)**2)*ds

!!$ print*, 	a_dudxip1j, a_dvdyijp1, a_dudxim1j, a_dvdyijm1, a_uip1j, a_vijp1, a_uim1j, a_vijm1, a_csip1j, a_csijp1, a_csim1j, a_csijm1, a_dcsdxip1j, a_dcsdyijp1, a_dcsdxim1j, a_dcsdyijm1

	a_csgrad_ij=dsqrt((dcsdxij/dx)**2+(dcsdyij/dy)**2)*ds

	! use central sound speed
	csij = (csij+cs0)/2.d0


!	rnuxim1j=0.5*(rho(i-1,j)+rho(i,j))*&
!	   (avs_2*a_csgrad_ij+avs_1*csij) 

!	rnuyijm1=0.5*(rho(i,j-1)+rho(i,j))*&
!	   (avs_2*a_csgrad_ij+avs_1*csij)

!	rnuxip1j=0.5*(rho(i+1,j)+rho(i,j))*&
!	   (avs_2*a_csgrad_ij+avs_1*csij) 

!	rnuyijp1=0.5*(rho(i,j+1)+rho(i,j))*&
!	   (avs_2*a_csgrad_ij+avs_1*csij)


	rnuxim1j=0.5d0*(Rmaj(i-1)*rho(i-1,j)+Rmaj(i)*rho(i,j))*&
	   (avs_2*a_csgrad_ij+avs_1*csij) 

	rnuyijm1=0.5d0*(rho(i,j-1)+rho(i,j))*&
	   (avs_2*a_csgrad_ij+avs_1*csij)

	rnuxip1j=0.5d0*(Rmaj(i+1)*rho(i+1,j)+Rmaj(i)*rho(i,j))*&
	   (avs_2*a_csgrad_ij+avs_1*csij) 

	rnuyijp1=0.5d0*(rho(i,j+1)+rho(i,j))*&
	   (avs_2*a_csgrad_ij+avs_1*csij)

!!$ print*, rnuxim1j, rnuyijm1, 	rnuxip1j, 	rnuyijp1

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!	rnuxim1j=0.5*(rho(i-1,j)+rho(i,j))*av_1*dabs(omim1j)*ds 
!
!	rnuyijm1=0.5*(rho(i,j-1)+rho(i,j))*av_1*dabs(omijm1)*ds 
!
!	rnuxip1j=0.5*(rho(i+1,j)+rho(i,j))*av_1*dabs(omip1j)*ds 
!
!	rnuyijp1=0.5*(rho(i,j+1)+rho(i,j))*av_1*dabs(omijp1)*ds 

	rnuxim1j = rnuxim1j + 0.5d0*(Rmaj(i-1)*rho(i-1,j)+Rmaj(i)*rho(i,j))*&
				av_1*dabs(omim1j)*ds 

	rnuyijm1 = rnuyijm1 + 0.5d0*(rho(i,j-1)+rho(i,j))*&
					av_1*dabs(omijm1)*ds 

	rnuxip1j = rnuxip1j + 0.5d0*(Rmaj(i+1)*rho(i+1,j)+Rmaj(i)*rho(i,j))*&
					av_1*dabs(omip1j)*ds 

	rnuyijp1 = rnuyijp1 + 0.5d0*(rho(i,j+1)+rho(i,j))*&
					av_1*dabs(omijp1)*ds 

!!$ print*, 	rnuxim1j ,	rnuyijm1 , 	rnuxip1j, rnuyijp1 


!   momentum fluxes

	wxyijp1=  -v_shear_loc*rnuyijp1*dudyijp1
	wxyijm1=  -v_shear_loc*rnuyijm1*dudyijm1
	wyxim1j=  -v_shear_loc*rnuxim1j*dvdxim1j 
	wyxip1j=  -v_shear_loc*rnuxip1j*dvdxip1j 

!	wxxip1j=   rnuxip1j*dmax1(0.D0,-dudxip1j)
!	wxxim1j=   rnuxim1j*dmax1(0.D0,-dudxim1j)
!	wyyijm1=   rnuyijm1*dmax1(0.D0,-dvdyijm1)
!	wyyijp1=   rnuyijp1*dmax1(0.D0,-dvdyijp1)

	wxxip1j=   v_shear_loc*rnuxip1j*(-dudxip1j)
	wxxim1j=   v_shear_loc*rnuxim1j*(-dudxim1j)
	wyyijm1=   v_shear_loc*rnuyijm1*(-dvdyijm1)
	wyyijp1=   v_shear_loc*rnuyijp1*(-dvdyijp1)


!   energy fluxes

    fenxim1j=0.5*((u(i-1,j)+u(i,j))*wxxim1j+(v(i-1,j)+v(i,j))*wyxim1j)*Rmaj(i-1)
    fenxip1j=0.5*((u(i+1,j)+u(i,j))*wxxip1j+(v(i+1,j)+v(i,j))*wyxip1j)*Rmaj(i+1)
	fenyijm1=0.5*((u(i,j-1)+u(i,j))*wxyijm1+(v(i,j-1)+v(i,j))*wyyijm1)
    fenyijp1=0.5*((u(i,j+1)+u(i,j))*wxyijp1+(v(i,j+1)+v(i,j))*wyyijp1)	
 
!   Correction of  ENERGY AND MOMEMTUM FLUXES

!!$ print*, i,j
!!$ print*, dtx, dty
!!$ print*, fenxim1j, fenxip1j, fenyijm1, fenyijp1
!!$ print*, wxxip1j, wxxim1j,Rmaj(i),wxyijp1,wxyijm1
!!$ print*, wyxip1j,wyxim1j, Rmaj(i), wyyijp1, wyyijm1
!!$ print*, '      '
!!$pause


      gxn(i,j)   = gxn(i,j)  -0.5*dtx*(wxxip1j-wxxim1j)/Rmaj(i)  -0.5*dty*(wxyijp1-wxyijm1)
      gyn(i,j)   = gyn(i,j)  -0.5*dtx*(wyxip1j-wyxim1j)/Rmaj(i)  -0.5*dty*(wyyijp1-wyyijm1)
  	  enfln(i,j) = enfln(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/Rmaj(i)-0.5*dty*(fenyijp1-fenyijm1)


end do
end do
!!!$omp enddo
!!!$omp end parallel


	return

end subroutine art_visc_Alfven
