!********************************************************************
! art_diff:    diffuses the variable PHI at non-monotonic points.
!			   If  PHI(i,j) is greater or lower than both its
!			   immediate neighboring points, ART_DIFF executes a 
!			   diffusion step with diffusion coefficient proportional
!			   to dx and dy
!**********************************************************************               



!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine art_difB(dt,dx,dy,nx,ny,nmx,nmy,phi,p,u,v)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, art_diff1,art_diff2

	implicit none

	integer :: nx, ny, nmx, nmy
	real(kind=dkind) :: dx, dy, dt, dtx, dty
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rhod, p, u, v, rho, phi
	real(kind=dkind) :: at_cs, at_v, rloc, check_i, check_j, check_ij, check_ji
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: csijp1, csip1j, csij , csim1j, csijm1
	real(kind=dkind) :: velij, velip1j, velim1j, velijp1, velijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1
	real(kind=dkind) :: qtxip1j, qtyijp1, qtxim1j, qtyijm1
	real(kind=dkind) :: fenxip1j, fenyijp1, fenxim1j, fenyijm1

	integer :: i, j

    dtx=dt/dx
	dty=dt/dy


    at_cs=art_diff1
	at_v =art_diff2

	do j=0,ny+1
	do i=0,nx+1
	rhod(i,j)=phi(i,j)
	end do
	end do

	do  j=1,ny
    do  i=1,nx

 check_j=(rhod(i,j)-rhod(i,j-1))*(rhod(i,j)-rhod(i,j+1))
 check_i=(rhod(i,j)-rhod(i-1,j))*(rhod(i,j)-rhod(i+1,j))
 check_ij=(rhod(i,j)-rhod(i-1,j+1))*(rhod(i,j)-rhod(i+1,j-1))
 check_ji=(rhod(i,j)-rhod(i-1,j-1))*(rhod(i,j)-rhod(i+1,j+1))


if(check_i>=0d0.and.check_j>=0d0.and.check_ij>=0d0.and.check_ji>=0d0)then


	tij  =p(i,j)/rhod(i,j)
    tijp1=p(i,j+1)/rhod(i,j+1)
	tijm1=p(i,j-1)/rhod(i,j-1)
	tip1j=p(i+1,j)/rhod(i+1,j)
	tim1j=p(i-1,j)/rhod(i-1,j)

    csijp1=dsqrt(dmax1(0.D0,tijp1))
    csip1j=dsqrt(dmax1(0.D0,tip1j))
	csij  =dsqrt(dmax1(0.D0,tij))
	csim1j=dsqrt(dmax1(0.D0,tim1j))
	csijm1=dsqrt(dmax1(0.D0,tijm1))

! Sound speed gradients
!	dcsdxip1j=         csip1j-csij
!	dcsdxij=      0.5*(csip1j-csim1j)
!	dcsdxim1j=         csij-csim1j
!   dcsdyijp1=         csijp1-csij
!	dcsdyij=      0.5*(csijp1-csijm1)
!	dcsdyijm1=         csij-csijm1


	velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
	velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
	velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
	velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
	velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)





    rTxip1j=(0.5*(velip1j+velij))
	rTxim1j=(0.5*(velim1j+velij))
	rTyijp1=(0.5*(velijp1+velij))
	rTyijm1=(0.5*(velijm1+velij))

!   rTxip1j=at_cs*dabs(dcsdxip1j)
!	rTxim1j=at_cs*dabs(dcsdxim1j)
!	rTyijp1=at_cs*dabs(dcsdyijp1)
!	rTyijm1=at_cs*dabs(dcsdyijm1)

	qtxip1j=rTxip1j*(rhod(i+1,j)-rhod(i,j))
	qtyijp1=rTyijp1*(rhod(i,j+1)-rhod(i,j)) 
	qtxim1j=rTxim1j*(rhod(i,j)-rhod(i-1,j))
	qtyijm1=rTyijm1*(rhod(i,j)-rhod(i,j-1)) 


    fenxip1j=-qtxip1j
	fenyijp1=-qtyijp1
    fenxim1j=-qtxim1j
	fenyijm1=-qtyijm1


	PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)-0.5*dty*(fenyijp1-fenyijm1)

endif

end do
end do

	return
	end


!********************************************************************
! art_diff:    diffuses the variable PHI at non-monotonic points.
!			   If  PHI(i,j) is greater or lower than both its
!			   immediate neighboring points, ART_DIFF executes a 
!			   diffusion step with diffusion coefficient proportional
!			   to dx and dy
!**********************************************************************               
! this version has been modified to receive all arrays (0:nx+1,0:ny+1)

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 subroutine art_dif_peaks_nn(dt,dx,dy,nx,ny,phi,p,rho,u,v,enhance)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, art_diff1,art_diff2, v_shear_edge, v_shear_exponent,  &
												xlength, ylength, art_diff_option, diff_index_range,  &
												rdiff_min, x_axis, y_axis, istart, iend, jstart, jend
	use mod_arrays, only : nmx, nmy, xV, yV, Rmaj
	use boundary_routines, only : sort_grid

	implicit none 

	integer :: nx, ny
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rhod,p, u, v, rho, phi
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: bx,by,bz
	real(kind=dkind) :: dt, dx, dy, dtx, dty
	real(kind=dkind) :: at_cs, at_v

	integer :: enhance
	real(kind=dkind) :: edge_factor, rloc
	real(kind=dkind) :: check_i, check_j, check_ij, check_ji
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: velij, velip1j, velim1j, velijp1, velijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1
	real(kind=dkind) :: csij, csijp1, csip1j, csim1j, csijm1

	real(kind=dkind) :: qtxip1j, qtyijp1, qtxim1j, qtyijm1
	real(kind=dkind) :: fenxip1j, fenyijp1, fenxim1j, fenyijm1

	integer :: npeaks
	integer, dimension(1:nx*ny,1:2) :: peak_index
	integer :: i,j,k


    dtx=dt/dx
	dty=dt/dy


    at_cs=art_diff1
	at_v =art_diff2

	npeaks = 0

	if((at_v==0.d0).and.(at_cs==0.d0)) return

	do j=0,ny+1
	do i=0,nx+1
		rhod(i,j)=rho(i,j)
	end do
	end do

	!$omp parallel default(private) shared(phi)
	!$omp do
	do  j = jstart, jend
	do  i = istart, iend

		if(art_diff_option==4) then

			rloc = sqrt((xV(i)-x_axis)**2+(yV(j)-y_axis)**2)
			if(rloc<rdiff_min) cycle

		endif

		if(sort_grid(i,j)<=0) cycle

		check_j=(phi(i,j)-phi(i,j-1))*(phi(i,j)-phi(i,j+1))
		check_i=(phi(i,j)-phi(i-1,j))*(phi(i,j)-phi(i+1,j))
		check_ij=(phi(i,j)-phi(i-1,j+1))*(phi(i,j)-phi(i+1,j-1))
		check_ji=(phi(i,j)-phi(i-1,j-1))*(phi(i,j)-phi(i+1,j+1))

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff1 * edge_factor
			at_v = art_diff2 * edge_factor

		endif


	!if(check_i>=0d0.and.check_j>=0d0.and.check_ij>=0d0.and.check_ji>=0d0)then

	if((art_diff_option>=2).and.((check_i<0d0).or.(check_j<0d0).or.(check_ij<0d0).or.(check_ji<0d0))) cycle

	if(art_diff_option==4) then

		npeaks = npeaks + 1
		peak_index(npeaks,1) = i
		peak_index(npeaks,2) = j

	endif


		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =p(i,j)/rhod(i,j)
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
!		if(rhod(i,j+1)==0.d0)then
			tijp1 = 0.d0
		else
			tijp1=p(i,j+1)/rhod(i,j+1)
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
!		if(rhod(i,j-1)==0.d0) then
			tijm1 = 0.d0
		else
			tijm1=p(i,j-1)/rhod(i,j-1)
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
!		if(rhod(i+1,j)==0.d0) then
			tip1j = 0.d0
		else
			tip1j=p(i+1,j)/rhod(i+1,j)
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
!		if(rhod(i-1,j)==0.d0) then
			tim1j = 0.d0
		else
			tim1j=p(i-1,j)/rhod(i-1,j)
		endif


	!!$    csijp1=dsqrt(dmax1(0.D0,tijp1))
	!!$    csip1j=dsqrt(dmax1(0.D0,tip1j))
	!!$	csij  =dsqrt(dmax1(0.D0,tij))
	!!$	csim1j=dsqrt(dmax1(0.D0,tim1j))
	!!$	csijm1=dsqrt(dmax1(0.D0,tijm1))

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

	! Sound speed gradients
	!	dcsdxip1j=         csip1j-csij
	!	dcsdxij=      0.5*(csip1j-csim1j)
	!	dcsdxim1j=         csij-csim1j
	!   dcsdyijp1=         csijp1-csij
	!	dcsdyij=      0.5*(csijp1-csijm1)
	!	dcsdyijm1=         csij-csijm1


		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)





		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

	!   rTxip1j=at_cs*dabs(dcsdxip1j)
	!	rTxim1j=at_cs*dabs(dcsdxim1j)
	!	rTyijp1=at_cs*dabs(dcsdyijp1)
	!	rTyijm1=at_cs*dabs(dcsdyijm1)

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 


		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue

	!endif

	end do
	end do
	!$omp enddo
	!$omp end parallel

	! neighbouring points cycle

	do k = 1, npeaks
	do  j = peak_index(k,2)-diff_index_range, peak_index(k,2)+diff_index_range
	do  i = peak_index(k,1)-diff_index_range, peak_index(k,1)+diff_index_range

		if((i<1).or.(i>nx).or.(j<1).or.(j>ny)) cycle
		if(sort_grid(i,j)<=0) cycle
		if((j==peak_index(k,2)).and.(i==peak_index(k,1))) cycle
		! to avoid repeating the diffusion in the original peak

		check_j=(phi(i,j)-phi(i,j-1))*(phi(i,j)-phi(i,j+1))
		check_i=(phi(i,j)-phi(i-1,j))*(phi(i,j)-phi(i+1,j))
		check_ij=(phi(i,j)-phi(i-1,j+1))*(phi(i,j)-phi(i+1,j-1))
		check_ji=(phi(i,j)-phi(i-1,j-1))*(phi(i,j)-phi(i+1,j+1))

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff1 * edge_factor
			at_v = art_diff2 * edge_factor

		endif

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =p(i,j)/rhod(i,j)
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
			tijp1 = 0.d0
		else
			tijp1=p(i,j+1)/rhod(i,j+1)
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
			tijm1 = 0.d0
		else
			tijm1=p(i,j-1)/rhod(i,j-1)
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
			tip1j = 0.d0
		else
			tip1j=p(i+1,j)/rhod(i+1,j)
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
			tim1j = 0.d0
		else
			tim1j=p(i-1,j)/rhod(i-1,j)
		endif

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)

		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 

		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1

		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue

	!endif

	end do
	end do
	enddo

return
end


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine art_diff_force(dt,dx,dy,nx,ny,phi,p,rho,u,v,enhance)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, art_diff_force1,art_diff_force2, v_shear_edge,  &
												v_shear_exponent, xlength, ylength, art_diff_option,  &
												diff_index_range, rdiff_min, x_axis, y_axis
	use mod_arrays, only : xV, yV, Rmaj
	use boundary_routines, only : sort_grid

	implicit none

	integer :: nx, ny
	real(kind=dkind) :: dx, dy, dt, dtx, dty
	real(kind=dkind), dimension(0:nx+1,0:ny+1) :: rhod, p, u, v, rho, phi
	real(kind=dkind) :: at_cs, at_v, rloc, check_i, check_j, check_ij, check_ji
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: csijp1, csip1j, csij , csim1j, csijm1
	real(kind=dkind) :: velij, velip1j, velim1j, velijp1, velijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1
	real(kind=dkind) :: qtxip1j, qtyijp1, qtxim1j, qtyijm1
	real(kind=dkind) :: fenxip1j, fenyijp1, fenxim1j, fenyijm1

	integer :: enhance
	real(kind=dkind) edge_factor
	integer :: npeaks
	integer, dimension(1:nx*ny,1:2) :: peak_index
	integer :: i,j,k

    dtx=dt/dx
	dty=dt/dy

	npeaks = 0

    at_cs = art_diff_force1
	at_v = art_diff_force2

	if((at_v==0.d0).and.(at_cs==0.d0)) return

	do j=0,ny+1
	do i=0,nx+1
		rhod(i,j)=rho(i,j)
	end do
	end do

	do  j=1,ny
	do  i=1,nx

		if(art_diff_option==4) then

			rloc = sqrt((xV(i)-x_axis)**2+(yV(j)-y_axis)**2)
			if(rloc<rdiff_min) cycle

		endif

		if(sort_grid(i,j)<=0) cycle

		check_j=(phi(i,j)-phi(i,j-1))*(phi(i,j)-phi(i,j+1))
		check_i=(phi(i,j)-phi(i-1,j))*(phi(i,j)-phi(i+1,j))
		check_ij=(phi(i,j)-phi(i-1,j+1))*(phi(i,j)-phi(i+1,j-1))
		check_ji=(phi(i,j)-phi(i-1,j-1))*(phi(i,j)-phi(i+1,j+1))

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff_force1 * edge_factor
			at_v = art_diff_force2 * edge_factor

		endif


	!if(check_i>=0d0.and.check_j>=0d0.and.check_ij>=0d0.and.check_ji>=0d0)then
	if((art_diff_option>=2).and.((check_i<0d0).or.(check_j<0d0).or.(check_ij<0d0).or.(check_ji<0d0))) cycle

	if(art_diff_option==4) then

		npeaks = npeaks + 1
		peak_index(npeaks,1) = i
		peak_index(npeaks,2) = j

	endif

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =p(i,j)/rhod(i,j)
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
!		if(rhod(i,j+1)==0.d0)then
			tijp1 = 0.d0
		else
			tijp1=p(i,j+1)/rhod(i,j+1)
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
!		if(rhod(i,j-1)==0.d0) then
			tijm1 = 0.d0
		else
			tijm1=p(i,j-1)/rhod(i,j-1)
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
!		if(rhod(i+1,j)==0.d0) then
			tip1j = 0.d0
		else
			tip1j=p(i+1,j)/rhod(i+1,j)
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
!		if(rhod(i-1,j)==0.d0) then
			tim1j = 0.d0
		else
			tim1j=p(i-1,j)/rhod(i-1,j)
		endif


	!!$    csijp1=dsqrt(dmax1(0.D0,tijp1))
	!!$    csip1j=dsqrt(dmax1(0.D0,tip1j))
	!!$	csij  =dsqrt(dmax1(0.D0,tij))
	!!$	csim1j=dsqrt(dmax1(0.D0,tim1j))
	!!$	csijm1=dsqrt(dmax1(0.D0,tijm1))

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

	! Sound speed gradients
	!	dcsdxip1j=         csip1j-csij
	!	dcsdxij=      0.5*(csip1j-csim1j)
	!	dcsdxim1j=         csij-csim1j
	!   dcsdyijp1=         csijp1-csij
	!	dcsdyij=      0.5*(csijp1-csijm1)
	!	dcsdyijm1=         csij-csijm1


		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)





		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

	!   rTxip1j=at_cs*dabs(dcsdxip1j)
	!	rTxim1j=at_cs*dabs(dcsdxim1j)
	!	rTyijp1=at_cs*dabs(dcsdyijp1)
	!	rTyijm1=at_cs*dabs(dcsdyijm1)

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 


		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue

	!endif

	end do
	end do


	! neighbouring points cycle

	do k = 1, npeaks
	do  j = peak_index(k,2)-diff_index_range, peak_index(k,2)+diff_index_range
	do  i = peak_index(k,1)-diff_index_range, peak_index(k,1)+diff_index_range

		if((i<1).or.(i>nx).or.(j<1).or.(j>ny)) cycle
		if(sort_grid(i,j)<=0) cycle
		if((j==peak_index(k,2)).and.(i==peak_index(k,1))) cycle
		! to avoid repeating the diffusion in the original peak

		if(sort_grid(i,j)<=0) cycle

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff_force1 * edge_factor
			at_v = art_diff_force2 * edge_factor

		endif

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =p(i,j)/rhod(i,j)
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
			tijp1 = 0.d0
		else
			tijp1=p(i,j+1)/rhod(i,j+1)
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
			tijm1 = 0.d0
		else
			tijm1=p(i,j-1)/rhod(i,j-1)
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
			tip1j = 0.d0
		else
			tip1j=p(i+1,j)/rhod(i+1,j)
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
			tim1j = 0.d0
		else
			tim1j=p(i-1,j)/rhod(i-1,j)
		endif

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)

		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 


		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue


	enddo
	enddo
	enddo

return

end

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine art_dif_peaks_nn_alfven(dt,dx,dy,nx,ny,phi,p,rhod,u,v,bx,by,bz,enhance)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, art_diff1,art_diff2, v_shear_edge, v_shear_exponent,  &
												xlength, ylength, rmu0, art_diff_option, diff_index_range,  &
												rdiff_min, x_axis, y_axis, istart, iend, jstart, jend
	use mod_arrays, only : nmx, nmy, xV, yV, Rmaj
	use boundary_routines, only : sort_grid

	implicit none 

	integer :: nx, ny
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rhod,p, u, v, phi
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: bx,by,bz
	real(kind=dkind) :: dt, dx, dy, dtx, dty
	real(kind=dkind) :: at_cs, at_v

	integer :: enhance
	real(kind=dkind) :: edge_factor, rloc
	real(kind=dkind) :: check_i, check_j, check_ij, check_ji
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: velij, velip1j, velim1j, velijp1, velijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1
	real(kind=dkind) :: csij, csijp1, csip1j, csim1j, csijm1

	real(kind=dkind) :: qtxip1j, qtyijp1, qtxim1j, qtyijm1
	real(kind=dkind) :: fenxip1j, fenyijp1, fenxim1j, fenyijm1

	integer :: npeaks
	integer, dimension(1:nx*ny,1:2) :: peak_index
	integer :: i,j,k

    dtx=dt/dx
	dty=dt/dy

	npeaks = 0

    at_cs=art_diff1
	at_v =art_diff2

	if((at_v==0.d0).and.(at_cs==0.d0)) return

!!	!$omp parallel default(private), shared(phi,sort_grid,xV,yV,rhod,bx,by,bz,Rmaj)
!!	!$omp do
	do  j = jstart, jend
	do  i = istart, iend

		if(art_diff_option==5) then

			rloc = sqrt((xV(i)-x_axis)**2+(yV(j)-y_axis)**2)
			if(rloc<rdiff_min) cycle

		endif

		if(sort_grid(i,j)<=0) cycle

		if(art_diff_option>=3) then

			check_j=(phi(i,j)-phi(i,j-1))*(phi(i,j)-phi(i,j+1))
			check_i=(phi(i,j)-phi(i-1,j))*(phi(i,j)-phi(i+1,j))
			check_ij=(phi(i,j)-phi(i-1,j+1))*(phi(i,j)-phi(i+1,j-1))
			check_ji=(phi(i,j)-phi(i-1,j-1))*(phi(i,j)-phi(i+1,j+1))

		endif

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff1 * edge_factor
			at_v = art_diff2 * edge_factor

		endif


	!if(check_i>=0d0.and.check_j>=0d0.and.check_ij>=0d0.and.check_ji>=0d0)then
	if((art_diff_option>=3).and.((check_i<0d0).or.(check_j<0d0).or.(check_ij<0d0).or.(check_ji<0d0))) cycle

	if(art_diff_option==5) then

		npeaks = npeaks + 1
		peak_index(npeaks,1) = i
		peak_index(npeaks,2) = j

	endif

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =sqrt ( (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/(rmu0*rhod(i,j)) )
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
!		if(rhod(i,j+1)==0.d0)then
			tijp1 = 0.d0
		else
			tijp1  =sqrt ( (bx(i,j+1)**2+by(i,j+1)**2+bz(i,j+1)**2)/(rmu0*rhod(i,j+1)) )
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
!		if(rhod(i,j-1)==0.d0) then
			tijm1 = 0.d0
		else
			tijm1  =sqrt ( (bx(i,j-1)**2+by(i,j-1)**2+bz(i,j-1)**2)/(rmu0*rhod(i,j-1)) )
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
!		if(rhod(i+1,j)==0.d0) then
			tip1j = 0.d0
		else
			tip1j  =sqrt ( (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/(rmu0*rhod(i+1,j)) )
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
!		if(rhod(i-1,j)==0.d0) then
			tim1j = 0.d0
		else
			tim1j  =sqrt ( (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/(rmu0*rhod(i-1,j)) )
		endif


	!!$    csijp1=dsqrt(dmax1(0.D0,tijp1))
	!!$    csip1j=dsqrt(dmax1(0.D0,tip1j))
	!!$	csij  =dsqrt(dmax1(0.D0,tij))
	!!$	csim1j=dsqrt(dmax1(0.D0,tim1j))
	!!$	csijm1=dsqrt(dmax1(0.D0,tijm1))

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

	! Sound speed gradients
	!	dcsdxip1j=         csip1j-csij
	!	dcsdxij=      0.5*(csip1j-csim1j)
	!	dcsdxim1j=         csij-csim1j
	!   dcsdyijp1=         csijp1-csij
	!	dcsdyij=      0.5*(csijp1-csijm1)
	!	dcsdyijm1=         csij-csijm1


		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)





		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

	!   rTxip1j=at_cs*dabs(dcsdxip1j)
	!	rTxim1j=at_cs*dabs(dcsdxim1j)
	!	rTyijp1=at_cs*dabs(dcsdyijp1)
	!	rTyijm1=at_cs*dabs(dcsdyijm1)

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 


		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue

	!endif

	end do
	end do
!!	!$omp enddo
!!	!$omp end parallel

	! neighbouring points cycle

	do k = 1, npeaks
	do  j = peak_index(k,2)-diff_index_range, peak_index(k,2)+diff_index_range
	do  i = peak_index(k,1)-diff_index_range, peak_index(k,1)+diff_index_range

		if((i<1).or.(i>nx).or.(j<1).or.(j>ny)) cycle
		if(sort_grid(i,j)<=0) cycle
		if((j==peak_index(k,2)).and.(i==peak_index(k,1))) cycle
		! to avoid repeating the diffusion in the original peak

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff1 * edge_factor
			at_v = art_diff2 * edge_factor

		endif


		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =sqrt ( (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/(rmu0*rhod(i,j)) )
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
			tijp1 = 0.d0
		else
			tijp1  =sqrt ( (bx(i,j+1)**2+by(i,j+1)**2+bz(i,j+1)**2)/(rmu0*rhod(i,j+1)) )
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
			tijm1 = 0.d0
		else
			tijm1  =sqrt ( (bx(i,j-1)**2+by(i,j-1)**2+bz(i,j-1)**2)/(rmu0*rhod(i,j-1)) )
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
			tip1j = 0.d0
		else
			tip1j  =sqrt ( (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/(rmu0*rhod(i+1,j)) )
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
			tim1j = 0.d0
		else
			tim1j  =sqrt ( (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/(rmu0*rhod(i-1,j)) )
		endif

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)

		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 

		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue


	enddo
	enddo
	enddo

return

end

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine art_diff_force_alfven(dt,dx,dy,nx,ny,phi,p,rho,u,v,bx,by,bz,enhance)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, art_diff_force1,art_diff_force2, v_shear_edge,  &
												v_shear_exponent, xlength, ylength, rmu0,  &
												art_diff_option, diff_index_range, rdiff_min,  &
												x_axis, y_axis
	use mod_arrays, only : xV, yV, Rmaj
	use boundary_routines, only : sort_grid

	implicit none

	integer :: nx, ny
	real(kind=dkind) :: dx, dy, dt, dtx, dty
	real(kind=dkind), dimension(0:nx+1,0:ny+1) :: rhod, p, u, v, rho, phi
	real(kind=dkind) :: at_cs, at_v, rloc, check_i, check_j, check_ij, check_ji
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: csijp1, csip1j, csij , csim1j, csijm1
	real(kind=dkind) :: velij, velip1j, velim1j, velijp1, velijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1
	real(kind=dkind) :: qtxip1j, qtyijp1, qtxim1j, qtyijm1
	real(kind=dkind) :: fenxip1j, fenyijp1, fenxim1j, fenyijm1

	integer :: enhance
	real(kind=dkind) edge_factor
	real(kind=dkind), dimension(0:nx+1,0:ny+1) :: bx,by,bz
	integer :: npeaks
	integer, dimension(1:nx*ny,1:2) :: peak_index
	integer :: i,j,k

    dtx=dt/dx
	dty=dt/dy

	npeaks = 0

    at_cs = art_diff_force1
	at_v = art_diff_force2

	if((at_v==0.d0).and.(at_cs==0.d0)) return

	do j=0,ny+1
	do i=0,nx+1
		rhod(i,j)=rho(i,j)
	end do
	end do

	do  j=1,ny
	do  i=1,nx

		if(art_diff_option==5) then

			rloc = sqrt((xV(i)-x_axis)**2+(yV(j)-y_axis)**2)
			if(rloc<rdiff_min) cycle

		endif

		if(sort_grid(i,j)<=0) cycle

		check_j=(phi(i,j)-phi(i,j-1))*(phi(i,j)-phi(i,j+1))
		check_i=(phi(i,j)-phi(i-1,j))*(phi(i,j)-phi(i+1,j))
		check_ij=(phi(i,j)-phi(i-1,j+1))*(phi(i,j)-phi(i+1,j-1))
		check_ji=(phi(i,j)-phi(i-1,j-1))*(phi(i,j)-phi(i+1,j+1))

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff_force1 * edge_factor
			at_v = art_diff_force2 * edge_factor

		endif


	!if(check_i>=0d0.and.check_j>=0d0.and.check_ij>=0d0.and.check_ji>=0d0)then
	if((art_diff_option>=3).and.((check_i<0d0).or.(check_j<0d0).or.(check_ij<0d0).or.(check_ji<0d0))) cycle

	if(art_diff_option==5) then

		npeaks = npeaks + 1
		peak_index(npeaks,1) = i
		peak_index(npeaks,2) = j

	endif

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =sqrt ( (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/(rmu0*rhod(i,j)) )
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
!		if(rhod(i,j+1)==0.d0)then
			tijp1 = 0.d0
		else
			tijp1  =sqrt ( (bx(i,j+1)**2+by(i,j+1)**2+bz(i,j+1)**2)/(rmu0*rhod(i,j+1)) )
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
!		if(rhod(i,j-1)==0.d0) then
			tijm1 = 0.d0
		else
			tijm1  =sqrt ( (bx(i,j-1)**2+by(i,j-1)**2+bz(i,j-1)**2)/(rmu0*rhod(i,j-1)) )
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
!		if(rhod(i+1,j)==0.d0) then
			tip1j = 0.d0
		else
			tip1j  =sqrt ( (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/(rmu0*rhod(i+1,j)) )
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
!		if(rhod(i-1,j)==0.d0) then
			tim1j = 0.d0
		else
			tim1j  =sqrt ( (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/(rmu0*rhod(i-1,j)) )
		endif


	!!$    csijp1=dsqrt(dmax1(0.D0,tijp1))
	!!$    csip1j=dsqrt(dmax1(0.D0,tip1j))
	!!$	csij  =dsqrt(dmax1(0.D0,tij))
	!!$	csim1j=dsqrt(dmax1(0.D0,tim1j))
	!!$	csijm1=dsqrt(dmax1(0.D0,tijm1))

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

	! Sound speed gradients
	!	dcsdxip1j=         csip1j-csij
	!	dcsdxij=      0.5*(csip1j-csim1j)
	!	dcsdxim1j=         csij-csim1j
	!   dcsdyijp1=         csijp1-csij
	!	dcsdyij=      0.5*(csijp1-csijm1)
	!	dcsdyijm1=         csij-csijm1


		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)





		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

	!   rTxip1j=at_cs*dabs(dcsdxip1j)
	!	rTxim1j=at_cs*dabs(dcsdxim1j)
	!	rTyijp1=at_cs*dabs(dcsdyijp1)
	!	rTyijm1=at_cs*dabs(dcsdyijm1)

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 


		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue

	!endif

	end do
	end do


	! neighbouring points cycle

	do k = 1, npeaks
	do  j = peak_index(k,2)-diff_index_range, peak_index(k,2)+diff_index_range
	do  i = peak_index(k,1)-diff_index_range, peak_index(k,1)+diff_index_range

		if((i<1).or.(i>nx).or.(j<1).or.(j>ny)) cycle
		if(sort_grid(i,j)<=0) cycle
		if((j==peak_index(k,2)).and.(i==peak_index(k,1))) cycle
		! to avoid repeating the diffusion in the original peak

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff_force1 * edge_factor
			at_v = art_diff_force2 * edge_factor

		endif

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =sqrt ( (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/(rmu0*rhod(i,j)) )
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
			tijp1 = 0.d0
		else
			tijp1  =sqrt ( (bx(i,j+1)**2+by(i,j+1)**2+bz(i,j+1)**2)/(rmu0*rhod(i,j+1)) )
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
			tijm1 = 0.d0
		else
			tijm1  =sqrt ( (bx(i,j-1)**2+by(i,j-1)**2+bz(i,j-1)**2)/(rmu0*rhod(i,j-1)) )
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
			tip1j = 0.d0
		else
			tip1j  =sqrt ( (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/(rmu0*rhod(i+1,j)) )
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
			tim1j = 0.d0
		else
			tim1j  =sqrt ( (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/(rmu0*rhod(i-1,j)) )
		endif

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)

		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

		qtxip1j=rTxip1j*(phi(i+1,j)-phi(i,j)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1)-phi(i,j)) 
		qtxim1j=rTxim1j*(phi(i,j)-phi(i-1,j)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j)-phi(i,j-1)) 

		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		PHI(i,j)=PHI(i,j)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue


	enddo
	enddo
	enddo

return

end


!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine art_dif_alfven_array(dt,dx,dy,nx,ny,phi,p,rhod,u,v,bx,by,bz,enhance,nvar)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY : dkind, art_diff1,art_diff2, v_shear_edge, v_shear_exponent,  &
												xlength, ylength, rmu0, art_diff_option, diff_index_range,  &
												rdiff_min, x_axis, y_axis, istart, iend, jstart, jend
	use mod_arrays, only : nmx, nmy, xV, yV, Rmaj
	use boundary_routines, only : sort_grid

	implicit none 

	integer :: nx, ny
	integer :: nvar
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rhod,p, u, v
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1,1:nvar) :: phi
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: bx,by,bz
	real(kind=dkind) :: dt, dx, dy, dtx, dty
	real(kind=dkind) :: at_cs, at_v

	integer :: enhance
	real(kind=dkind) :: edge_factor, rloc
	real(kind=dkind) :: check_i, check_j, check_ij, check_ji
	real(kind=dkind) :: tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: velij, velip1j, velim1j, velijp1, velijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1
	real(kind=dkind) :: csij, csijp1, csip1j, csim1j, csijm1

	real(kind=dkind) :: qtxip1j, qtyijp1, qtxim1j, qtyijm1
	real(kind=dkind) :: fenxip1j, fenyijp1, fenxim1j, fenyijm1

	integer :: npeaks(1:nvar)
	integer, dimension(1:nx*ny,1:2,1:nvar) :: peak_index
	integer :: i, j, k, m

    dtx=dt/dx
	dty=dt/dy

	npeaks = 0

    at_cs=art_diff1
	at_v =art_diff2

	if((at_v==0.d0).and.(at_cs==0.d0)) return

	!$omp parallel default(shared)
	!$omp do private(i,j,m,rloc,edge_factor,at_cs,at_v,check_i,check_j,check_ij,check_ji,tij,tijp1,tijm1,tip1j,tim1j, csijp1, csip1j, csij, csim1j, csijm1, velij, velip1j, velim1j, velijp1, velijm1, rTxip1j, rTxim1j, rTyijp1, rTyijm1, qtxip1j, qtyijp1, qtxim1j, qtyijm1, fenxip1j, fenyijp1, fenxim1j, fenyijm1)

	do  j = jstart, jend
	do  i = istart, iend

		if(art_diff_option==5) then

			rloc = sqrt((xV(i)-x_axis)**2+(yV(j)-y_axis)**2)
			if(rloc<rdiff_min) cycle

		endif

		if(sort_grid(i,j)<=0) cycle

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff1 * edge_factor
			at_v = art_diff2 * edge_factor

		endif

		do m = 1, nvar

			if(art_diff_option>=3) then

				check_j = (phi(i,j,m)-phi(i,j-1,m))*(phi(i,j,m)-phi(i,j+1,m))
				check_i = (phi(i,j,m)-phi(i-1,j,m))*(phi(i,j,m)-phi(i+1,j,m))
				check_ij = (phi(i,j,m)-phi(i-1,j+1,m))*(phi(i,j,m)-phi(i+1,j-1,m))
				check_ji = (phi(i,j,m)-phi(i-1,j-1,m))*(phi(i,j,m)-phi(i+1,j+1,m))

			endif

			!if(check_i>=0d0.and.check_j>=0d0.and.check_ij>=0d0.and.check_ji>=0d0)then
			if((art_diff_option>=3).and.((check_i<0d0).or.(check_j<0d0).or.(check_ij<0d0).or.(check_ji<0d0))) cycle

			if(art_diff_option==5) then

				npeaks(m) = npeaks(m) + 1
				peak_index(npeaks(m),1,m) = i
				peak_index(npeaks(m),2,m) = j

			endif

		enddo

		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij = sqrt ( (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/(rmu0*rhod(i,j)) )
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
!		if(rhod(i,j+1)==0.d0)then
			tijp1 = 0.d0
		else
			tijp1 = sqrt ( (bx(i,j+1)**2+by(i,j+1)**2+bz(i,j+1)**2)/(rmu0*rhod(i,j+1)) )
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
!		if(rhod(i,j-1)==0.d0) then
			tijm1 = 0.d0
		else
			tijm1 = sqrt ( (bx(i,j-1)**2+by(i,j-1)**2+bz(i,j-1)**2)/(rmu0*rhod(i,j-1)) )
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
!		if(rhod(i+1,j)==0.d0) then
			tip1j = 0.d0
		else
			tip1j = sqrt ( (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/(rmu0*rhod(i+1,j)) )
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
!		if(rhod(i-1,j)==0.d0) then
			tim1j = 0.d0
		else
			tim1j = sqrt ( (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/(rmu0*rhod(i-1,j)) )
		endif

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)

		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

		do m = 1, nvar

			qtxip1j=rTxip1j*(phi(i+1,j,m)-phi(i,j,m)) * Rmaj(i+1)
			qtyijp1=rTyijp1*(phi(i,j+1,m)-phi(i,j,m)) 
			qtxim1j=rTxim1j*(phi(i,j,m)-phi(i-1,j,m)) * Rmaj(i-1)
			qtyijm1=rTyijm1*(phi(i,j,m)-phi(i,j-1,m)) 

			fenxip1j=-qtxip1j
			fenyijp1=-qtyijp1
			fenxim1j=-qtxim1j
			fenyijm1=-qtyijm1

			phi(i,j,m) = phi(i,j,m)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
									-0.5*dty*(fenyijp1-fenyijm1)

		enddo

	!endif

	end do
	end do
	!$omp enddo
	!$omp end parallel

	! neighbouring points cycle

	!$omp parallel default(shared)
	!$omp do private(i,j,m,rloc,edge_factor,at_cs,at_v,check_i,check_j,check_ij,check_ji,tij,tijp1,tijm1,tip1j,tim1j, csijp1, csip1j, csij, csim1j, csijm1, velij, velip1j, velim1j, velijp1, velijm1, rTxip1j, rTxim1j, rTyijp1, rTyijm1, qtxip1j, qtyijp1, qtxim1j, qtyijm1, fenxip1j, fenyijp1, fenxim1j, fenyijm1)
	do m = 1, nvar
	do k = 1, npeaks(m)
	do  j = peak_index(k,2,m)-diff_index_range, peak_index(k,2,m)+diff_index_range
	do  i = peak_index(k,1,m)-diff_index_range, peak_index(k,1,m)+diff_index_range

		if((i<1).or.(i>nx).or.(j<1).or.(j>ny)) cycle
		if(sort_grid(i,j)<=0) cycle
		if((j==peak_index(k,2,m)).and.(i==peak_index(k,1,m))) cycle
		! to avoid repeating the diffusion in the original peak

		if(enhance == 1) then

			rloc = sqrt((xV(i)-xlength/2.d0)**2+(yV(j)-ylength/2.d0)**2)
			edge_factor = (1.d0 + v_shear_edge*(rloc/((xlength+ylength)/4.d0))**v_shear_exponent)
			at_cs = art_diff1 * edge_factor
			at_v = art_diff2 * edge_factor

		endif


		if(rhod(i,j)==0.d0) then
			tij = 0.d0
		else
			tij  =sqrt ( (bx(i,j)**2+by(i,j)**2+bz(i,j)**2)/(rmu0*rhod(i,j)) )
		endif

		if((rhod(i,j+1)==0.d0).or.(sort_grid(i,j+1)<=0)) then
			tijp1 = 0.d0
		else
			tijp1  =sqrt ( (bx(i,j+1)**2+by(i,j+1)**2+bz(i,j+1)**2)/(rmu0*rhod(i,j+1)) )
		endif

		if((rhod(i,j-1)==0.d0).or.(sort_grid(i,j-1)<=0)) then
			tijm1 = 0.d0
		else
			tijm1  =sqrt ( (bx(i,j-1)**2+by(i,j-1)**2+bz(i,j-1)**2)/(rmu0*rhod(i,j-1)) )
		endif

		if((rhod(i+1,j)==0.d0).or.(sort_grid(i+1,j)<=0)) then
			tip1j = 0.d0
		else
			tip1j  =sqrt ( (bx(i+1,j)**2+by(i+1,j)**2+bz(i+1,j)**2)/(rmu0*rhod(i+1,j)) )
		endif

		if((rhod(i-1,j)==0.d0).or.(sort_grid(i-1,j)<=0)) then
			tim1j = 0.d0
		else
			tim1j  =sqrt ( (bx(i-1,j)**2+by(i-1,j)**2+bz(i-1,j)**2)/(rmu0*rhod(i-1,j)) )
		endif

		csijp1=dsqrt(dmax1(0.D0,abs(tijp1)))
		csip1j=dsqrt(dmax1(0.D0,abs(tip1j)))
		csij  =dsqrt(dmax1(0.D0,abs(tij)))
		csim1j=dsqrt(dmax1(0.D0,abs(tim1j)))
		csijm1=dsqrt(dmax1(0.D0,abs(tijm1)))

		velij  =at_cs*csij+  at_v*dsqrt(u(i,j)**2+v(i,j)**2)
		velip1j=at_cs*csip1j+at_v*dsqrt(u(i+1,j)**2+v(i+1,j)**2)
		velim1j=at_cs*csim1j+at_v*dsqrt(u(i-1,j)**2+v(i-1,j)**2)
		velijp1=at_cs*csijp1+at_v*dsqrt(u(i,j+1)**2+v(i,j+1)**2)
		velijm1=at_cs*csijm1+at_v*dsqrt(u(i,j-1)**2+v(i,j-1)**2)

		rTxip1j=(0.5*(velip1j+velij))
		rTxim1j=(0.5*(velim1j+velij))
		rTyijp1=(0.5*(velijp1+velij))
		rTyijm1=(0.5*(velijm1+velij))

		qtxip1j=rTxip1j*(phi(i+1,j,m)-phi(i,j,m)) * Rmaj(i+1)
		qtyijp1=rTyijp1*(phi(i,j+1,m)-phi(i,j,m)) 
		qtxim1j=rTxim1j*(phi(i,j,m)-phi(i-1,j,m)) * Rmaj(i-1)
		qtyijm1=rTyijm1*(phi(i,j,m)-phi(i,j-1,m)) 

		fenxip1j=-qtxip1j
		fenyijp1=-qtyijp1
		fenxim1j=-qtxim1j
		fenyijm1=-qtyijm1


		phi(i,j,m)=PHI(i,j,m)-0.5*dtx*(fenxip1j-fenxim1j)/ Rmaj(i)  &
								-0.5*dty*(fenyijp1-fenyijm1)
		continue


	enddo
	enddo
	enddo
	enddo
	!$omp enddo
	!$omp end parallel

	return

end subroutine art_dif_alfven_array
