!****************************************************************************************
! art_cond::   calculate the correction to the fluid energy
!              produced by two explicit artificial thermal conduction terms
!
!              The term with at0 is proportional to dx,dy and the sound speed
!              The term with at1 is proportional to dx^2, dy^2 and sound speed gradients
!****************************************************************************************

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
subroutine art_cond(dt,dx,dy,nx,ny,nmx,nmy,rho,p,enfl)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  

use mod_parameters, ONLY : dkind, An,rsh,art_cond1,art_cond2
                        

	Implicit none
	
	integer :: nx, ny, nmx, nmy
	real(kind=dkind), dimension(0:nmx+1,0:nmy+1) :: rho, p, enfl
	real(kind=dkind) :: dt, dx, dy
	real(kind=dkind) :: dtx, dty, cv, at1, at2, tij, tijp1, tijm1, tip1j, tim1j
	real(kind=dkind) :: 	csij, csijp1, csip1j, csim1j, csijm1
	real(kind=dkind) :: dcsdxip1j, dcsdxij, dcsdxim1j, dcsdyijp1, dcsdyij, dcsdyijm1
	real(kind=dkind) :: rTxip1j, rTxim1j, rTyijp1, rTyijm1, rTyij, rTxij
	real(kind=dkind) :: qtxim1j, qtxip1j, qtyijm1, qtyijp1, qtxij, qtyij
	real(kind=dkind) :: fenxim1j, fenxip1j, fenyijm1, fenyijp1, fenxij, fenyij
	integer :: i, j

if(art_cond1==0d0.and.art_cond2==0d0)return

    dtx=dt/dx
	dty=dt/dy
    cv=1./((rsh-1.)*An)   ! specific heat
	at1=art_cond1
	at2=art_cond2

!$omp parallel default(shared)
!$omp do private(i, j, tij, tijp1, tijm1, tip1j, tim1j, csij, csijp1, csip1j, csim1j, csijm1, dcsdxip1j, dcsdxij, dcsdxim1j, dcsdyijp1, dcsdyij, dcsdyijm1, rTxip1j, rTxim1j, rTyijp1, rTyijm1, rTyij, rTxij, qtxim1j, qtxip1j, qtyijm1, qtyijp1, qtxij, qtyij, fenxim1j, fenxip1j, fenyijm1, fenyijp1, fenxij, fenyij)
do  j=1,ny
do  i=1,nx


! Temperatures using ideal gas equation of state :: T = p*An/rho
	tij=     dmax1(p(i,j)*An/rho(i,j),0d0)
    tijp1=   dmax1(p(i,j+1)*An/rho(i,j+1),0d0)
	tijm1=   dmax1(p(i,j-1)*An/rho(i,j-1),0d0)
	tip1j=   dmax1(p(i+1,j)*An/rho(i+1,j),0d0)
	tim1j=   dmax1(p(i-1,j)*An/rho(i-1,j),0d0)

! Sound speed
	csij=    dsqrt(tij*rsh/An)
    csijp1=  dsqrt(tijp1*rsh/An)
    csip1j=  dsqrt(tip1j*rsh/An)
	csim1j=  dsqrt(tim1j*rsh/An)
	csijm1=  dsqrt(tijm1*rsh/An)      

! Sound speed gradients
	dcsdxip1j=         csip1j-csij
	dcsdxij=      0.5*(csip1j-csim1j)
	dcsdxim1j=         csij-csim1j
    dcsdyijp1=         csijp1-csij
	dcsdyij=      0.5*(csijp1-csijm1)
	dcsdyijm1=         csij-csijm1



rTxip1j=cv*0.5*(rho(i+1,j)+rho(i,j))*(at2*dabs(dcsdxip1j)+at1*0.5*(csip1j+csij))
rTxim1j=cv*0.5*(rho(i-1,j)+rho(i,j))*(at2*dabs(dcsdxim1j)+at1*0.5*(csim1j+csij))
rTyijp1=cv*0.5*(rho(i,j+1)+rho(i,j))*(at2*dabs(dcsdyijp1)+at1*0.5*(csijp1+csij))
rTyijm1=cv*0.5*(rho(i,j-1)+rho(i,j))*(at2*dabs(dcsdyijm1)+at1*0.5*(csijm1+csij))
rTyij=  cv*rho(i,j)*(at2*dabs(dcsdyij)+at1*csij)
rTxij=  cv*rho(i,j)*(at2*dabs(dcsdxij)+at1*csij)

qtxim1j=   rTxim1j*(tij-tim1j)
qtxip1j=   rTxip1j*(tip1j-tij)
qtyijm1=   rTyijm1*(tij-tijm1) 
qtyijp1=   rTyijp1*(tijp1-tij)
qtxij  =   rTxij*0.5*(tip1j-tim1j)
qtyij  =   rTyij*0.5*(tijp1-tijm1)


fenxim1j=  -qtxim1j
fenxip1j=  -qtxip1j
fenyijm1=  -qtyijm1
fenyijp1=  -qtyijp1
fenxij  =  -qtxij
fenyij  =  -qtyij
 
! CORRECTION OF  FLUID ENERGY
   
enfl(i,j)=enfl(i,j)-0.5*dtx*(fenxip1j-fenxim1j)-0.5*dty*(fenyijp1-fenyijm1)

end do
end do
!$omp enddo
!$omp end parallel

	return

end
