!*****************************************************************
!  advance_solution:  advance the solution of the MHD
!                      equations
!*****************************************************************
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine advance_solution(icycle)
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	use mod_parameters, ONLY: dkind,dx,dy,dt,nx,ny, timen
	use mod_arrays,     ONLY: nmx,nmy,rho,bx,by,bz,u,v,w,p,eta_phys
	use vacuum_module, only : resistive_diffusion
							  
	implicit none

	real(kind=dkind) :: divB_err
	integer :: icycle

!   use the modulo command to determines if icycle is odd or even (in magnetohydro itself)

!   solve the ideal/resistive MHD equations (minus the magnetic diffusion part)
	call magnetohydro(icycle)

! Resistive diffusion
	call resistive_diffusion(icycle)

	call divergence_B(bx,by,1,divB_err,timen)


!	call art_diff_bz(dt,dx,dy,nx,ny,nmx,nmy,rho,p,bz,ieven,iodd)

!   applies the boundary conditions	
    call boundary(nx,ny,nmx,nmy,u,v,w,rho,bx,by,bz,p,eta_phys)


	return

end subroutine advance_solution
