!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine readinput
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
! Loads input plasma shape and plasma shape recalculated with FLOW free-boundary equilibrium.

	use mod_parameters, only : dkind, theta_points_max_lim
	use mod_arrays, only : r_in_data, r_out_data, theta_points

	implicit none

	real(kind=dkind), dimension(theta_points_max_lim,2) :: dummy
	integer :: i

	! input plasma shape
	i = 0

	open(33,file='roftheta.dat', status='old', action='read')

	do 

		i = i+1
		read(33,*,end=99) dummy(i,1),dummy(i,2)

	enddo

99	continue

	close(33)

	theta_points = i-1

	allocate(r_in_data(theta_points,2))

	do i=1,theta_points

		r_in_data(i,1) = dummy(i,1)
		r_in_data(i,2) = dummy(i,2)

	enddo

	! recalculated plasma shape
	i = 0

	open(33,file='r_edge_of_theta.dat', status='old', action='read')

	do 

		i = i+1
		read(33,*,end=199) dummy(i,1),dummy(i,2)

	enddo

199	continue

	close(33)

	if(i-1 == theta_points) then

		! all is well
		continue

	else

		print*, 'error in file size:'
		print*, 'point in = ', theta_points
		print*, 'point out = ', i-1
		pause
		stop

	endif

	allocate(r_out_data(theta_points,2))

	do i=1,theta_points

		r_out_data(i,1) = dummy(i,1)
		r_out_data(i,2) = dummy(i,2)

	enddo

	continue

	return

  end subroutine readinput