!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
subroutine output
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
! calculates a couple of estimates of the boundary shape error

	use mod_parameters, only : dkind
	use mod_arrays, only : theta_points, r_in_data, r_out_data

	implicit none

	real(kind=dkind) :: err_L2, err_norm_L2,  err_L2_ave, err_norm_L2_ave,  &
									err_Linf, err_norm_Linf
	real(kind=dkind) :: errloc, rloc, rloc_out
	integer :: i

	err_L2 = 0.d0
	err_norm_L2 = 0.d0
	err_L2_ave = 0.d0
	err_norm_L2_ave = 0.d0
	err_Linf = 0.d0
	err_norm_Linf = 0.d0

	do i = 1, theta_points-1

		rloc = r_in_data(i,2)
		rloc_out = r_out_data(i,2)

		errloc = abs(rloc-rloc_out)
		err_L2 = err_L2 + errloc**2
		err_norm_L2 = err_norm_L2 + errloc**2/rloc**2

		err_Linf = max(err_Linf,errloc)
		err_norm_Linf = max(err_norm_Linf,errloc/rloc)

		continue

	enddo

	err_L2 = sqrt(err_L2)
	err_norm_L2 = sqrt(err_norm_L2)

	err_L2_ave = err_L2/theta_points
	err_norm_L2_ave = err_norm_L2/theta_points

	write(*,*) 'err_L2 = ', err_L2
	write(*,*) 'err_norm_L2 = ', err_norm_L2
	write(*,*) '  '
	write(*,*) 'err_L2_ave = ', err_L2_ave
	write(*,*) 'err_norm_L2_ave = ', err_norm_L2_ave
	write(*,*) '  '
	write(*,*) 'err_Linf = ', err_Linf
	write(*,*) 'err_norm_Linf = ', err_norm_Linf
	write(*,*) '  '

	open(69, file='error_evaluation.dat')

	write(69,*) 'err_L2 = ', err_L2
	write(69,*) 'err_norm_L2 = ', err_norm_L2
	write(69,*) 'err_L2_ave = ', err_L2_ave
	write(69,*) 'err_norm_L2_ave = ', err_norm_L2_ave
	write(69,*) 'err_Linf = ', err_Linf
	write(69,*) 'err_norm_Linf = ', err_norm_Linf

	close(69)

end subroutine output
